<?xml version="1.0" encoding="UTF-8" ?>
<!--
****************
(C) 2005, 1060 Research Limited. All rights reserved.
Licensed under the 1060 Public License v1.0 - http://www.1060research.com/license
1060 is a registered trademark of 1060 Research Ltd.
**********
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	<xsl:template match="/">
		<rss version="2.0">
			<channel>
				<title><xsl:value-of select="/results/row/topictitle"/></title>
				<link><xsl:value-of select="$param/results/row[setting='WWWHOSTNAME']/value"/>forum/topic/<xsl:value-of select="/results/row/topicnumber"/></link>
				<description>
					Entries: <xsl:value-of select="/results/row[1]/total"/> Views: <xsl:value-of select="/results/row[1]/hits"/>
				</description>
				<language>en-us</language>
				<ttl>60</ttl>	
				<xsl:apply-templates select="results/row"/>
			</channel>
		</rss>
    </xsl:template>
	
	<!--
	///////////////////////
	//Match each entry item
	///////////////////////
	-->
	<xsl:template match="row">
		
		<item>
			<title><xsl:value-of select="title"/></title>
			<link><xsl:value-of select="$param/results/row[setting='WWWHOSTNAME']/value"/>forum/topic/<xsl:value-of select="topicnumber"/></link>
			<guid isPermaLink="true"><xsl:value-of select="$param/results/row[setting='WWWHOSTNAME']/value"/>forum/topic/<xsl:value-of select="topicnumber"/></guid>
			<description>
				<xsl:value-of select="entry"/>
			</description>
			<generator>1060 NetKernel Standard Edition v2.x.x 1060 Forum v1.0.0</generator>
			<pubDate>
				<xsl:value-of select="substring(dateDayName, 1,3)"/>,
				<xsl:text> </xsl:text>
				<xsl:call-template name="addzero">
					<xsl:with-param name="n" select="dateDayOfMonth"/>
				</xsl:call-template>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring(dateMonthName, 1, 3)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="dateYear"/>
				<xsl:text> </xsl:text>
				<xsl:call-template name="addzero">
					<xsl:with-param name="n" select="timeHour"/>
				</xsl:call-template>:<xsl:call-template name="addzero">
					<xsl:with-param name="n" select="timeMinute"/>
				</xsl:call-template>:00
				<xsl:text> </xsl:text>GMT</pubDate>
		</item>
	</xsl:template>
	

	<xsl:template name="toText">
		<xsl:param name="entry"/>
		<xsl:param name="text"/>
		<xsl:if test="string-length($text) &lt; 100 and descendant::*">
			<xsl:call-template name="toText">
				<xsl:with-param name="entry" select="descendant::*"/>
				<xsl:with-param name="text" select="concat($text,' ', $entry/text())"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:value-of select="$text"/>
	</xsl:template>
		
	<!--
	//////////////////////////////////////////////
	//Utility to add Zero to a number less than 10
	//////////////////////////////////////////////
	-->
	<xsl:template name="addzero">
		<xsl:param name="n"/>
		<xsl:if test="$n &lt; 10">0</xsl:if><xsl:value-of select="$n"/>
	</xsl:template>
	
</xsl:stylesheet> 
