<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:include href="ffcpl:/main/forum/common/lib.xsl"/>
	<xsl:output method="xml"/>
	<xsl:param name="meta"/>
	<xsl:variable name="meta2" select="$meta/meta/info/results/row"/>
	<xsl:param name="param"/>
	<xsl:template match="/">
		<div title="Topic - {/results/row[1]/title}" desc="from forum {$meta2/name}">
			<xsl:if test="string-length($meta2/imageurl)">
				<xsl:attribute name="img"><xsl:value-of select="$meta2/imageurl"/></xsl:attribute>
			</xsl:if>
			<table width="100%"><tr>
				<td class="titlebar" width="0%">
					<a href="[[xrl:topics-new]]?id={$meta/meta/info/results/row/forumid}" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">new topic</span><span class="cc">&#160;</span></a>
					<xsl:if test="$meta2/status='open'">
						<a href="[[xrl:entry-new]]?id={$meta/meta/info/results/row/id}" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">post reply</span><span class="cc">&#160;</span></a>
					</xsl:if>
				</td>
				<td class="nav-links">
					<!--<xsl:copy-of select="$meta/meta/info/results/row"/>-->
					<a href="xrl:index" xrl:resolve="href"><xsl:value-of select="$meta2/fgname"/></a> -> <a href="[[xrl:topic-index]]{$meta2/forumid}" xrl:resolve="href"><xsl:value-of select="$meta2/name"/></a>
					-> <xsl:value-of select="$meta/meta/info/results/row/title"/>
				</td>
				</tr>
				<tr>
				<td>
					<xrl:include href="xrl:moderators-widget">
						<nvp>
							<id><xsl:value-of select="$meta2/forumid"/></id>
						</nvp>
					</xrl:include>
				</td>
				<td class="nav">
					<xsl:if test="ceiling ( $meta/meta/stats/results/row/pages ) &gt; 1">
					Go to page 
					<xrl:include href="xrl:page-nav-widget">
						<nvp>
							<uri>/forum/topic</uri>
							<id><xsl:value-of select="$meta/meta/info/results/row/id"/></id>
							<page><xsl:value-of select="$param/nvp/page"/></page>
							<total><xsl:value-of select="ceiling ( $meta/meta/stats/results/row/pages )"/></total>
						</nvp>
					</xrl:include>
					</xsl:if>
				</td>
			</tr></table>
			
			<xsl:apply-templates/>
			
			<table width="100%">
			<xsl:if test="ceiling ( $meta/meta/stats/results/row/pages ) &gt; 1">
				<tr><td colspan="2" class="nav">Go to page
				<xrl:include href="xrl:page-nav-widget">
					<nvp>
						<uri>/forum/topic</uri>
						<id><xsl:value-of select="$meta/meta/info/results/row/id"/></id>
						<page><xsl:value-of select="$param/nvp/page"/></page>
						<total><xsl:value-of select="ceiling ( $meta/meta/stats/results/row/pages )"/></total>
					</nvp>
				</xrl:include>
				</td></tr>
			</xsl:if>
			<tr>
				<td class="titlebar">
					<a href="[[xrl:topics-new]]?id={$meta/meta/info/results/row/forumid}" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">new topic</span><span class="cc">&#160;</span></a>
					<xsl:if test="$meta2/status='open'">
						<a href="[[xrl:entry-new]]?id={$meta/meta/info/results/row/id}" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">post reply</span><span class="cc">&#160;</span></a>
					</xsl:if>
				</td>
				<td class="titlebar" style="float: right; margin-top: 4px;">
					<a href="[[xrl:rss-topic]]{$meta/meta/info/results/row/id}" xrl:resolve="href"><img src="xrl:img_rss" xrl:resolve="src" alt="RSS" align="middle"/></a>
					<a href="[[xrl:moderate-topic]]{$meta/meta/info/results/row/id}/1" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">moderate</span><span class="cc">&#160;</span></a>
				</td>
			</tr>
		</table>
	</div>
	</xsl:template>
	
	<xsl:template match="null">
		<div>No Replies to this Topic</div>
	</xsl:template>
	
	<xsl:template match="results">
		<table width="100%" class="forum-toc" >
			<xsl:apply-templates select="row"/>
		</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr class="group-block">
			<td class="forum-title" colspan="2">
				<img align="middle" src="xrl:img_topic" xrl:resolve="src"/>
				<xsl:value-of select="title"/>
			</td>
		</tr>
		<tr>
			<td style="vertical-align: top;" width="25%">
				<xrl:include href="xrl:user-meta-widget">
					<nvp>
						<id><xsl:value-of select="usernumber"/></id>
					</nvp>
				</xrl:include>
			</td>
			<td width="75%" style="vertical-align: top;" class="entry-content">
				<div><span  class="forum-date">Posted:
					<xsl:value-of select="dateDayOfMonth"/>-<xsl:value-of select="dateMonthName"/>-<xsl:value-of select="dateYear"/>
					<xsl:text> </xsl:text>
					<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeMinute"/></xsl:call-template>
				</span></div>
				<xsl:copy-of select="entry/*"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet> 
