<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:include href="ffcpl:/main/forum/common/lib.xsl"/>
	<xsl:output method="xml"/>
	<xsl:param name="param"/>
	
	<xsl:template match="/search">
		<div title="Search - {stats/results/row/ssearch}" desc="found {stats/results/row/total} matches">
			<!--<xsl:copy-of select="."/>-->
			<table width="100%"><tr>
				<td class="titlebar">Not found what you where looking for? Try the
				<a href="xrl:search-new" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">advanced search</span><span class="cc">&#160;</span></a>
				</td>
				<td class="nav">
					<xsl:call-template name="nav"/>
				</td>
			</tr></table>
			
			<xsl:apply-templates select="data/*"/>
			
			<div class="nav">
				<xsl:call-template name="nav"/>
			</div>
			
		</div>
	</xsl:template>
	
	<xsl:template match="null">
		<div>No results found. </div>
	</xsl:template>
	
	<xsl:template match="results">
		<table width="100%" class="forum-toc" >									
			<xsl:apply-templates select="row"/>
		</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr class="forum-title">
			<td class="group-block" colspan="2">
				<a href="/forum/index/{forumid}"><xsl:value-of select="forumname"/></a> > <a href="/forum/topic/{topicid}"><xsl:value-of select="topictitle"/></a>
			</td>
		</tr>
		<tr>
			<td width="25%" style="vertical-align: top;">
				<xrl:include href="xrl:user-meta-widget">
					<nvp>
						<id><xsl:value-of select="userid"/></id>
					</nvp>
				</xrl:include>
			</td>
			<td width="75%" style="vertical-align: top;" class="entry-content">
				<div><span  class="forum-date">Posted:
					<xsl:value-of select="dateDayOfMonth"/>-<xsl:value-of select="dateMonthName"/>-<xsl:value-of select="dateYear"/>
					<xsl:text> </xsl:text>
					<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeMinute"/></xsl:call-template>
				</span></div>
                                <xsl:if test="string-length(entrytitle)">
                                    <div class="entry-title"><xsl:value-of select="entrytitle"/></div>
                                </xsl:if>
				<xsl:copy-of select="entry/*"/>
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="nav">
		<xsl:if test="stats/results/row/pages &gt; 1">
			Go to page <xrl:include href="xrl:page-nav-widget">
			<nvp>
				<uri>/forum/search</uri>
				<id><xsl:value-of select="$param/nvp/id"/></id>
				<page><xsl:value-of select="$param/nvp/page"/></page>
				<total><xsl:value-of select="ceiling ( /search/stats/results/row/pages )"/></total>
			</nvp>
		</xrl:include>
		</xsl:if>
	</xsl:template>
	
	
</xsl:stylesheet> 
