<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:param name="errors"/>
	<xsl:template match="/results">
		<div title="User - {row/userid}" desc="Public profile of user">
		<!--
			<xrl:include href="xrl:widget-menu"/>
			<h2>Membership Profile -  Thank Tony</h2>
	-->
			<xsl:apply-templates/>	
			<div class="titlebar">
				<a href="[[xrl:message-form]]?id={row/id}" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">send message</span><span class="cc">&#160;</span></a>
			</div>
		</div>
	</xsl:template>
	<xsl:template match="row">
		<table><tr>
			<td>
				<xsl:if test="string-length(imageurl)">
					<img src="{imageurl}"/>
				</xsl:if>
			</td>
			<td>
				<div class="forum-user-name"><xsl:value-of select="userid"/></div>
				<div class="forum-user-join">Posts: <xsl:value-of select="posts"/></div>
				<xsl:if test="string-length(location)">
					<div class="forum-user-join">Location: <xsl:value-of select="location"/></div>
				</xsl:if>
				<xsl:if test="string-length(biog)">
					<div class="forum-user-join">Biography: <xsl:value-of select="biog"/></div>
				</xsl:if>
				<xsl:if test="string-length(web)">
					<div class="forum-user-join">Web page: <a href="{web}"><xsl:value-of select="web"/></a></div>
				</xsl:if>
			</td>
		</tr></table>
	</xsl:template>
</xsl:stylesheet> 
