<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:param name="param"/>
	<xsl:param name="meta"/>
	<xsl:variable name="meta2" select="$meta/meta/info/results/row"/>
	<xsl:include href="ffcpl:/main/forum/common/lib.xsl"/>
	<xsl:template match="/">
		<div title="Forum - {$meta2/name}" desc="{$meta2/descr}">
			<xsl:if test="string-length($meta2/imageurl)">
				<xsl:attribute name="img"><xsl:value-of select="$meta2/imageurl"/></xsl:attribute>
			</xsl:if>
			<table width="100%">
			<tr>
				<td width="0%" class="titlebar">
					<a href="[[xrl:topics-new]]?id={$meta2/id}" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">new topic</span><span class="cc">&#160;</span></a>
				</td>
				<td class="nav-links">
					<!--<xsl:copy-of select="$meta/meta/info/results/row"/>-->
					<a href="xrl:index" xrl:resolve="href"><xsl:value-of select="$meta2/fgname"/></a> -> <xsl:value-of select="$meta2/name"/>
				</td>
			</tr>
			<tr>
				<td>
					<xrl:include href="xrl:moderators-widget">
						<nvp>
							<id><xsl:value-of select="$meta2/id"/></id>
						</nvp>
					</xrl:include>
				</td>
				<td class="nav">
					<xsl:if test="ceiling ( $meta/meta/stats/results/row/pages ) &gt; 1">
					Go to page 
					<xrl:include href="xrl:page-nav-widget">
						<nvp>
							<uri>/forum/index</uri>
							<id><xsl:value-of select="$meta/meta/info/results/row/id"/></id>
							<page><xsl:value-of select="$param/nvp/page"/></page>
							<total><xsl:value-of select="ceiling ( $meta/meta/stats/results/row/pages )"/></total>
						</nvp>
					</xrl:include>
					</xsl:if>
				</td>
			</tr></table>
			<xsl:apply-templates/>
			
			<table width="100%">
			<xsl:if test="ceiling ( $meta/meta/stats/results/row/pages ) &gt; 1">
				<tr><td colspan="4" class="nav">Go to page
					<xrl:include href="xrl:page-nav-widget">
						<nvp>
							<uri>/forum/index</uri>
							<id><xsl:value-of select="$meta/meta/info/results/row/id"/></id>
							<page><xsl:value-of select="$param/nvp/page"/></page>
							<total><xsl:value-of select="ceiling ( $meta/meta/stats/results/row/pages )"/></total>
						</nvp>
					</xrl:include>
				</td></tr>
			</xsl:if>
			<tr class="titlebar">
				<td valign="middle" width="0%">
					<a href="[[xrl:topics-new]]?id={$meta2/id}" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">new topic</span><span class="cc">&#160;</span></a>
				</td>
				<td valign="middle" style="text-align: right;" class="tiny" width="100%">
					To find out about new postings as they occur<br/>please subscribe to one of these feeds:
				</td>
				<td valign="middle" width="0%">
					<a href="[[xrl:atom-forum]]{$meta/meta/info/results/row/id}" xrl:resolve="href" style="margin-right: 5px;"><img src="xrl:img_atom" xrl:resolve="src" alt="Atom" /></a>
					<a href="[[xrl:rss-forum]]{$meta/meta/info/results/row/id}" xrl:resolve="href" style="margin-right: 5px;"><img src="xrl:img_rss" xrl:resolve="src" alt="RSS" /></a>
				</td>
				<td valign="middle" width="0%">
					<a href="[[xrl:moderate-forum]]{$meta/meta/info/results/row/id}/1" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">moderate</span><span class="cc">&#160;</span></a>
				</td>
			</tr>
		</table>
	</div>
	</xsl:template>
	
	<xsl:template match="null">
		<div>No Topics for this Forum</div>
	</xsl:template>
	
	<xsl:template match="results">
	
		<table class="forum-toc" width="100%">
			<tr class="group-header">
			<td>Topics</td><td class="forum-stat">Replies</td><td class="forum-stat">Users</td><td class="forum-stat">Views</td><td class="forum-stat">Created</td><td>Last Posts</td>
			</tr>
			<xsl:apply-templates select="row"/>
		</table>
		
		
	</xsl:template>
	<xsl:template match="row">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="flag='announce' or flag=3">
						<img align="middle" src="xrl:img_announce" xrl:resolve="src"/> Announce: 
					</xsl:when>
					<xsl:when test="flag='sticky' or flag=2">
						<img align="middle" src="xrl:img_sticky" xrl:resolve="src"/> Sticky: 
					</xsl:when>
					<xsl:when test="status='locked' or status=2">
						<img align="middle" src="xrl:img_locked" xrl:resolve="src"/>
					</xsl:when>
					<xsl:otherwise>
						<img align="middle" src="xrl:img_topic" xrl:resolve="src"/>
					</xsl:otherwise>
				</xsl:choose>
				<a href="/forum/topic/{id}/1" xrl:resolve="href"><xsl:value-of select="title"/></a>
			</td>
			<td class="forum-stat"><xsl:value-of select="total"/></td>
			<td class="forum-stat"><a href="[[xrl:membership-profile-public]]?id={usernumber}" xrl:resolve="href"><xsl:value-of select="userid"/></a></td>
			<td class="forum-stat"><xsl:value-of select="hits"/></td>
			<td class="forum-stat"><xsl:value-of select="dateDayOfMonth"/>-<xsl:value-of select="dateMonthName"/>-<xsl:value-of select="dateYear"/></td>
			<td class="forum-last-post">
				<b><xsl:value-of select="etitle"/></b><br/>
				<!--<span style="background-color: silver"><xsl:value-of select="esummary"/></span><br/>-->
				by <xsl:value-of select="euserid"/> at
				<xsl:call-template name="addzero"><xsl:with-param name="n" select="etimeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="etimeMinute"/></xsl:call-template><br/>
				<xsl:value-of select="edateDayOfMonth"/>-<xsl:value-of select="edateMonthName"/>-<xsl:value-of select="edateYear"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet> 
