<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:param name="param"/>
	<xsl:param name="meta"/>
	<xsl:param name="forums"/>
	<xsl:key name="forums" match="row" use="groupid"/>
	<xsl:variable name="meta2" select="$meta/meta/info/results/row"/>
	<xsl:template match="/">
		<div title="Moderate: {$meta2/name}" desc="{$meta2/descr}" >
			<div class="titlebar" style="padding: 2px; margin-bottom: 2;"><a href="[[xrl:topic-index]]{$param/nvp/id}" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">back to forum</span><span class="cc">&#160;</span></a></div>
			<table><tr><td>
			<form action="[[xrl:moderate-topic-update]]/{$param/nvp/id}" xrl:resolve="action" method="POST">
				<input type="hidden" name="id" value="{$param/nvp/id}"/>
				<input type="hidden" name="page" value="{$param/nvp/page}"/>
				<xsl:apply-templates/>
				<div>
					<input type="submit" value="Update Topics"/>
				</div>
			</form>
			</td></tr></table>
		</div>
	</xsl:template>
	<xsl:template match="null">
		<div>No Topics for this Forum</div>
	</xsl:template>
	<xsl:template match="results">
		<table class="forum-toc">
			<tr class="group-header">
			<td colspan="6">Status Flags</td><td>Topic</td><td>User</td><td>Entries</td><td>Views</td><td>Created</td><td>Delete</td><td>Move Forum</td>
			</tr>
			<tr class="group-header">
			<td>Normal</td><td>Sticky</td><td>Announce</td><td>UnLocked</td><td>Locked</td><td>Removed</td><td colspan="6"/><td/>
			</tr>
			<xsl:apply-templates select="row"/>
		</table>
		
		<div class="nav">Go to page <xrl:include href="xrl:page-nav-widget">
			<nvp>
				<uri>/forum/moderate/forum</uri>
				<id><xsl:value-of select="$meta/meta/info/results/row/id"/></id>
				<page><xsl:value-of select="$param/nvp/page"/></page>
				<total><xsl:value-of select="ceiling ( $meta/meta/stats/results/row/pages )"/></total>
			</nvp>
		</xrl:include>
		</div>
	</xsl:template>
	<xsl:template match="row">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="flag='normal' or flag=1">
						<input type="radio" name="flag-{id}" value="normal" CHECKED="true"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="flag-{id}" value="normal"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="flag='sticky' or flag=2">
						<input type="radio" name="flag-{id}" value="sticky" CHECKED="true"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="flag-{id}" value="sticky"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="flag='announce' or flag=3">
						<input type="radio" name="flag-{id}" value="announce" CHECKED="true"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="flag-{id}" value="announce"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="status='open' or status=1">
						<input type="radio" name="status-{id}" value="open" CHECKED="true"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="status-{id}" value="open"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="status='locked' or status=2">
						<input type="radio" name="status-{id}" value="locked" CHECKED="true"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="status-{id}" value="locked"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="status='removed' or status=3">
						<input type="radio" name="status-{id}" value="removed" CHECKED="true"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="radio" name="status-{id}" value="removed"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td><a href="/forum/moderate/topic/{id}/1" xrl:resolve="href"><xsl:value-of select="title"/></a></td>
			<td><xsl:value-of select="userid"/></td>
			<td><xsl:value-of select="total"/></td>
			<td><xsl:value-of select="hits"/></td>
			<td><xsl:value-of select="dateDayOfMonth"/>-<xsl:value-of select="dateMonthName"/>-<xsl:value-of select="dateYear"/></td>

			<td>
				<span stlye="border: 1px solid red;"><input type="checkbox" name="delete" value="{id}" /></span>
			</td>
			<td>
				<xsl:variable name="forumid" select="forumid"/>
				<select name="move-{id}">
					<xsl:for-each select="$forums/results/row[count(. | key('forums', groupid)[1]) = 1]">
						<optgroup label="{groupname}">
							<xsl:for-each select="key('forums',groupid)">
								<xsl:variable name="tempid" select="id"/>
								<option value="{$tempid}" label="{name}">
									<xsl:if test="$forumid=$tempid">
										<xsl:attribute name="SELECTED">true</xsl:attribute>
									</xsl:if>
									<xsl:value-of select="name"/></option>
							</xsl:for-each>
						</optgroup>
					</xsl:for-each>
				</select>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet> 