<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:include href="ffcpl:/main/forum/common/lib.xsl"/>
	<xsl:output method="xml"/>
	<xsl:param name="meta"/>
	<xsl:variable name="meta2" select="$meta/meta/info/results/row"/>
	<xsl:param name="param"/>
	<xsl:template match="/">
		<div title="Moderate: {$meta2/title}" desc=" ">
			<div class="titlebar" style="padding: 2px; margin-bottom: 2;"><a href="/forum/moderate/forum/{$meta/meta/info/results/row/forumid}/1"><span class="aa">&#160;</span><span class="bb">moderate forum</span><span class="cc">&#160;</span></a></div>
			<form action="[[xrl:moderate-entry-update]]/{$param/nvp/id}" xrl:resolve="action" method="POST">
				<input type="hidden" name="id" value="{$param/nvp/id}"/>
				<input type="hidden" name="page" value="{$param/nvp/page}"/>
				
				<xsl:apply-templates/>
				<div>
					<input type="submit" value="Delete Entries"/>
				</div>
			</form>
		</div>
	</xsl:template>
	
	<xsl:template match="null">
		<div>No Topics for this Forum</div>
	</xsl:template>
	
	<xsl:template match="results">
		<table width="100%" class="forum-toc" >
			<tr class="group-header">
				<td colspan="2"/><td class="forum-stat">Delete</td>
			</tr>
			<xsl:apply-templates select="row"/>
			<tr >
				<td style="border: none;" colspan="3" class="nav">Go to page
					<xrl:include href="xrl:page-nav-widget">
						<nvp>
							<uri>/forum/moderate/topic</uri>
							<id><xsl:value-of select="$meta/meta/info/results/row/id"/></id>
							<page><xsl:value-of select="$param/nvp/page"/></page>
							<total><xsl:value-of select="ceiling ( $meta/meta/stats/results/row/pages )"/></total>
						</nvp>
					</xrl:include>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<td class="forum-user">
				<xrl:include href="xrl:user-meta-widget">
					<nvp>
						<id><xsl:value-of select="usernumber"/></id>
					</nvp>
				</xrl:include>
			</td>
			<td>
				<div class="forum-date">
					<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="timeMinute"/></xsl:call-template><br/>
					<xsl:value-of select="dateDayOfMonth"/>-<xsl:value-of select="dateMonthName"/>-<xsl:value-of select="dateYear"/>
				</div>
				<div class="entry-title"><xsl:value-of select="title"/></div>
				<div class="entry-content">
					<xsl:copy-of select="entry/*"/>
				</div>
			</td>
			<td class="forum-stat">
				<input type="checkbox" name="delete" value="{id}" />
			</td>
		</tr>
	</xsl:template>
	
</xsl:stylesheet> 