/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;

public class Unpacker
extends Thread {
    private AutomatedInstallData idata;
    private AbstractUIProgressHandler handler;
    private UninstallData udata;
    private String jarLocation;
    private VariableSubstitutor vs;
    private static ArrayList instances = new ArrayList();
    private File absolute_installpath;

    public Unpacker(AutomatedInstallData automatedInstallData, AbstractUIProgressHandler abstractUIProgressHandler) {
        super("IzPack - Unpacker thread");
        this.idata = automatedInstallData;
        this.handler = abstractUIProgressHandler;
        this.vs = new VariableSubstitutor(automatedInstallData.getVariableValueMap());
    }

    public static ArrayList getRunningInstances() {
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        instances.add(this);
        try {
            Object object;
            FileOutputStream fileOutputStream = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
            ArrayList<Serializable> arrayList3 = new ArrayList<Serializable>();
            List list = this.idata.selectedPacks;
            int n = list.size();
            this.handler.startAction("Unpacking", n);
            this.udata = UninstallData.getInstance();
            if (this.idata.kind.equalsIgnoreCase("web") || this.idata.kind.equalsIgnoreCase("web-kunststoff")) {
                InputStream inputStream = this.getClass().getResourceAsStream("/res/WebInstallers.url");
                object = new BufferedReader(new InputStreamReader(inputStream));
                this.jarLocation = ((BufferedReader)object).readLine();
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                Object object2;
                Serializable serializable;
                Object object3;
                int n4;
                int n5 = this.idata.allPacks.indexOf(list.get(i));
                ObjectInputStream objectInputStream = new ObjectInputStream(this.getPackAsStream(n5));
                int n6 = objectInputStream.readInt();
                this.handler.nextStep(((Pack)list.get((int)i)).name, i + 1, n6);
                for (n4 = 0; n4 < n6; ++n4) {
                    PackFile packFile = (PackFile)objectInputStream.readObject();
                    if (OsConstraint.oneMatchesCurrentSystem(packFile.osConstraints)) {
                        Object object4;
                        object3 = this.translatePath(packFile.targetPath);
                        serializable = new File((String)object3);
                        object2 = ((File)serializable).getParentFile();
                        if (!((File)object2).exists() && !((File)object2).mkdirs()) {
                            this.handler.emitError("Error creating directories", "Could not create directory\n" + ((File)object2).getPath());
                            this.handler.stopAction();
                            return;
                        }
                        this.udata.addFile((String)object3);
                        this.handler.progress(n4, (String)object3);
                        if (((File)serializable).exists() && packFile.override != 1) {
                            boolean bl = false;
                            if (packFile.override != 0) {
                                if (packFile.override == 1) {
                                    bl = true;
                                } else if (packFile.override == 4) {
                                    bl = ((File)serializable).lastModified() < packFile.mtime;
                                } else {
                                    int n7;
                                    int n8 = -1;
                                    if (packFile.override == 2) {
                                        n8 = 49;
                                    }
                                    if (packFile.override == 3) {
                                        n8 = 47;
                                    }
                                    boolean bl2 = bl = (n7 = this.handler.askQuestion(this.idata.langpack.getString("InstallPanel.overwrite.title") + ((File)serializable).getName(), this.idata.langpack.getString("InstallPanel.overwrite.question") + ((File)serializable).getAbsolutePath(), 37, n8)) == 47;
                                }
                            }
                            if (!bl) {
                                if (packFile.isBackReference()) continue;
                                objectInputStream.skip(packFile.length);
                                continue;
                            }
                        }
                        fileOutputStream = new FileOutputStream((File)serializable);
                        byte[] byArray = new byte[5120];
                        long l = 0L;
                        ObjectInputStream objectInputStream2 = objectInputStream;
                        if (packFile.isBackReference()) {
                            object4 = this.getPackAsStream(packFile.previousPackNumber);
                            objectInputStream2 = new ObjectInputStream((InputStream)object4);
                            ((InputStream)object4).skip(packFile.offsetInPreviousPack - 4L);
                        }
                        while (l < packFile.length) {
                            int n9 = packFile.length - l < (long)byArray.length ? (int)(packFile.length - l) : byArray.length;
                            int n10 = objectInputStream2.read(byArray, 0, n9);
                            if (n10 == -1) {
                                throw new IOException("Unexpected end of stream");
                            }
                            fileOutputStream.write(byArray, 0, n10);
                            l += (long)n10;
                        }
                        fileOutputStream.close();
                        if (objectInputStream2 != objectInputStream) {
                            objectInputStream2.close();
                        }
                        if (packFile.mtime >= 0L) {
                            ((File)serializable).setLastModified(packFile.mtime);
                        }
                        if (!((String)(object4 = ((File)serializable).getName())).startsWith("izpack-keepme") || !((String)object4).endsWith(".tmp")) continue;
                        ((File)serializable).delete();
                        continue;
                    }
                    if (packFile.isBackReference()) continue;
                    objectInputStream.skip(packFile.length);
                }
                n4 = objectInputStream.readInt();
                for (n3 = 0; n3 < n4; ++n3) {
                    object3 = (ParsableFile)objectInputStream.readObject();
                    ((ParsableFile)object3).path = this.translatePath(((ParsableFile)object3).path);
                    arrayList.add(object3);
                }
                n3 = objectInputStream.readInt();
                for (n2 = 0; n2 < n3; ++n2) {
                    serializable = (ExecutableFile)objectInputStream.readObject();
                    ((ExecutableFile)serializable).path = this.translatePath(((ExecutableFile)serializable).path);
                    if (null != ((ExecutableFile)serializable).argList && !((ExecutableFile)serializable).argList.isEmpty()) {
                        object2 = null;
                        for (int j = 0; j < ((ExecutableFile)serializable).argList.size(); ++j) {
                            object2 = (String)((ExecutableFile)serializable).argList.get(j);
                            object2 = this.translatePath((String)object2);
                            ((ExecutableFile)serializable).argList.set(j, object2);
                        }
                    }
                    arrayList2.add(serializable);
                    if (((ExecutableFile)serializable).executionStage != 2) continue;
                    this.udata.addExecutable((ExecutableFile)serializable);
                }
                n2 = objectInputStream.readInt();
                for (int j = 0; j < n2; ++j) {
                    object2 = (UpdateCheck)objectInputStream.readObject();
                    arrayList3.add((Serializable)object2);
                }
                objectInputStream.close();
            }
            ScriptParser scriptParser = new ScriptParser(arrayList, this.vs);
            scriptParser.parseFiles();
            object = new FileExecutor(arrayList2);
            if (((FileExecutor)object).executeFiles(0, this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
            }
            if (this.idata.info.getWriteUninstaller()) {
                this.putUninstaller();
            }
            this.performUpdateChecks(arrayList3);
            this.handler.stopAction();
        }
        catch (Exception exception) {
            this.handler.stopAction();
            this.handler.emitError("An error occured", exception.toString());
            exception.printStackTrace();
        }
        finally {
            instances.remove(instances.indexOf(this));
        }
    }

    private void performUpdateChecks(ArrayList arrayList) {
        Object object;
        Object object2;
        Object object3;
        Stack<Object> stack;
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        RECompiler rECompiler = new RECompiler();
        this.absolute_installpath = new File(this.idata.getInstallPath()).getAbsoluteFile();
        Object object4 = arrayList.iterator();
        while (object4.hasNext()) {
            stack = (UpdateCheck)object4.next();
            if (((UpdateCheck)((Object)stack)).includesList != null) {
                arrayList2.addAll(this.preparePatterns(((UpdateCheck)((Object)stack)).includesList, rECompiler));
            }
            if (((UpdateCheck)((Object)stack)).excludesList == null) continue;
            arrayList3.addAll(this.preparePatterns(((UpdateCheck)((Object)stack)).excludesList, rECompiler));
        }
        if (arrayList2.size() == 0) {
            return;
        }
        object4 = new TreeSet();
        stack = this.udata.getFilesList().iterator();
        while (stack.hasNext()) {
            object3 = (String)stack.next();
            object2 = new File((String)object3);
            if (!((File)object2).isAbsolute()) {
                object2 = new File(this.absolute_installpath, (String)object3);
            }
            ((TreeSet)object4).add(((File)object2).getAbsolutePath());
        }
        stack = new Stack<Object>();
        object3 = new ArrayList();
        try {
            stack.add(this.absolute_installpath);
            while (!stack.empty()) {
                object2 = (File)stack.pop();
                object = ((File)object2).listFiles();
                if (object == null) {
                    throw new IOException(((File)object2).getPath() + "is not a directory!");
                }
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object5 = object[i];
                    String string = ((File)object5).getPath();
                    if (((TreeSet)object4).contains(string)) continue;
                    if (this.fileMatchesOnePattern(string, arrayList2) && !this.fileMatchesOnePattern(string, arrayList3)) {
                        ((ArrayList)object3).add(object5);
                    }
                    if (!((File)object5).isDirectory()) continue;
                    stack.push(object5);
                }
            }
        }
        catch (IOException iOException) {
            this.handler.emitError("error while performing update checks", iOException.toString());
        }
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            object = (File)object2.next();
            if (((File)object).isDirectory()) continue;
            this.handler.emitNotification("deleting " + ((File)object).getPath());
            ((File)object).delete();
        }
    }

    private boolean fileMatchesOnePattern(String string, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RE rE = (RE)iterator.next();
            if (!rE.match(string)) continue;
            return true;
        }
        return false;
    }

    private List preparePatterns(ArrayList arrayList, RECompiler rECompiler) {
        ArrayList<RE> arrayList2 = new ArrayList<RE>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.length() <= 0) continue;
            File file = new File(string = this.vs.substitute(string, "plain"));
            if (!file.isAbsolute()) {
                string = new File(this.absolute_installpath, string).toString();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = -1;
            int n2 = 0;
            block8: while (n2 < string.length()) {
                char c;
                if (n != -1) {
                    c = (char)n;
                    n = -1;
                } else {
                    c = string.charAt(n2++);
                }
                switch (c) {
                    case '/': {
                        stringBuffer.append(File.separator);
                        continue block8;
                    }
                    case '.': 
                    case '\\': {
                        stringBuffer.append("\\");
                        stringBuffer.append(c);
                        continue block8;
                    }
                    case '*': {
                        if (n2 == string.length()) {
                            stringBuffer.append("[^" + File.separator + "]*");
                            continue block8;
                        }
                        if ((n = (int)string.charAt(n2++)) == 42) {
                            stringBuffer.append(".*");
                            n = -1;
                            continue block8;
                        }
                        stringBuffer.append("[^" + File.separator + "]*");
                        continue block8;
                    }
                }
                stringBuffer.append(c);
            }
            stringBuffer.append('$');
            try {
                arrayList2.add(new RE(rECompiler.compile(stringBuffer.toString())));
            }
            catch (RESyntaxException rESyntaxException) {
                this.handler.emitNotification("internal error: pattern \"" + string + "\" produced invalid RE \"" + file.getPath() + "\"");
            }
        }
        return arrayList2;
    }

    private void putUninstaller() throws Exception {
        int n;
        ZipOutputStream zipOutputStream;
        String string = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
        String string2 = string + File.separator + "uninstaller.jar";
        File file = new File(string);
        file.mkdirs();
        this.udata.setUninstallerJarFilename(string2);
        this.udata.setUninstallerPath(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.idata.uninstallOutJar = zipOutputStream = new ZipOutputStream(fileOutputStream);
        zipOutputStream.setLevel(9);
        this.udata.addFile(string2);
        InputStream inputStream = this.getClass().getResourceAsStream("/res/IzPack.uninstaller");
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            n = zipInputStream.read();
            while (n != -1) {
                zipOutputStream.write(n);
                n = zipInputStream.read();
            }
            zipInputStream.closeEntry();
            zipOutputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        zipOutputStream.putNextEntry(new ZipEntry("langpack.xml"));
        n = inputStream.read();
        while (n != -1) {
            zipOutputStream.write(n);
            n = inputStream.read();
        }
        zipOutputStream.closeEntry();
    }

    private InputStream getPackAsStream(int n) throws Exception {
        InputStream inputStream = null;
        if (this.idata.kind.equalsIgnoreCase("standard") || this.idata.kind.equalsIgnoreCase("standard-kunststoff")) {
            inputStream = this.getClass().getResourceAsStream("/packs/pack" + n);
        } else if (this.idata.kind.equalsIgnoreCase("web") || this.idata.kind.equalsIgnoreCase("web-kunststoff")) {
            URL uRL = new URL("jar:" + this.jarLocation + "!/packs/pack" + n);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            inputStream = jarURLConnection.getInputStream();
        }
        return inputStream;
    }

    private String translatePath(String string) {
        string = this.vs.substitute(string, null);
        return string.replace('/', File.separatorChar);
    }
}

