# This file has been autogenerated by the pywayland scanner

# Copyright (C) 2015 Martin Gräßlin
# Copyright (C) 2015 Marco Martin
# Copyright (C) 2020 Vlad Zahorodnii
# Copyright (C) 2024 Xaver Hugl
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlRegion


class ExtBackgroundEffectSurfaceV1(Interface):
    """Background effects for a surface

    The background effect object provides a way to specify a region behind a
    surface that should have background effects like blur applied.

    If the :class:`~pywayland.protocol.wayland.WlSurface` associated with the
    :class:`ExtBackgroundEffectSurfaceV1` object has been destroyed, this
    object becomes inert.
    """

    name = "ext_background_effect_surface_v1"
    version = 1

    class error(enum.IntEnum):
        surface_destroyed = 0


class ExtBackgroundEffectSurfaceV1Proxy(Proxy[ExtBackgroundEffectSurfaceV1]):
    interface = ExtBackgroundEffectSurfaceV1

    @ExtBackgroundEffectSurfaceV1.request()
    def destroy(self) -> None:
        """Release the blur object

        Informs the server that the client will no longer be using this
        protocol object. The effect regions will be removed on the next commit.
        """
        self._marshal(0)
        self._destroy()

    @ExtBackgroundEffectSurfaceV1.request(
        Argument(ArgumentType.Object, interface=WlRegion, nullable=True),
    )
    def set_blur_region(self, region: WlRegion | None) -> None:
        """Set blur region

        This request sets the region of the surface that will have its
        background blurred.

        The blur region is specified in the surface-local coordinates, and
        clipped by the compositor to the surface size.

        The initial value for the blur region is empty. Setting the pending
        blur region has copy semantics, and the
        :class:`~pywayland.protocol.wayland.WlRegion` object can be destroyed
        immediately. A NULL :class:`~pywayland.protocol.wayland.WlRegion`
        removes the effect.

        The blur region is double-buffered state, and will be applied on the
        next :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.

        The blur algorithm is subject to compositor policies.

        If the associated surface has been destroyed, the surface_destroyed
        error will be raised.

        :param region:
            blur region of the surface
        :type region:
            :class:`~pywayland.protocol.wayland.WlRegion` or `None`
        """
        self._marshal(1, region)


class ExtBackgroundEffectSurfaceV1Resource(Resource):
    interface = ExtBackgroundEffectSurfaceV1


class ExtBackgroundEffectSurfaceV1Global(Global):
    interface = ExtBackgroundEffectSurfaceV1


ExtBackgroundEffectSurfaceV1._gen_c()
ExtBackgroundEffectSurfaceV1.proxy_class = ExtBackgroundEffectSurfaceV1Proxy
ExtBackgroundEffectSurfaceV1.resource_class = ExtBackgroundEffectSurfaceV1Resource
ExtBackgroundEffectSurfaceV1.global_class = ExtBackgroundEffectSurfaceV1Global
