/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.OntologyVisibilityManager;
import org.protege.editor.owl.model.OntologyVisibilityManagerListener;
import org.semanticweb.owlapi.model.OWLOntology;

public class OntologyVisibilityManagerImpl
implements OntologyVisibilityManager {
    private Set<OWLOntology> visibleOntologies = new HashSet<OWLOntology>();
    private List<OntologyVisibilityManagerListener> listeners = new ArrayList<OntologyVisibilityManagerListener>();

    @Override
    public Set<OWLOntology> getVisibleOntologies() {
        return Collections.unmodifiableSet(this.visibleOntologies);
    }

    @Override
    public boolean isVisible(OWLOntology ontology) {
        return this.visibleOntologies.contains(ontology);
    }

    @Override
    public void setVisible(Set<OWLOntology> ontologies) {
        if (!this.visibleOntologies.equals(ontologies)) {
            this.visibleOntologies.clear();
            this.visibleOntologies.addAll(ontologies);
            this.fireVisibilityChanged();
        }
    }

    @Override
    public void setVisible(OWLOntology ontology, boolean b) {
        if (b) {
            if (this.visibleOntologies.add(ontology)) {
                this.fireVisibilityChanged();
            }
        } else if (this.visibleOntologies.remove(ontology)) {
            this.fireVisibilityChanged();
        }
    }

    @Override
    public void addListener(OntologyVisibilityManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OntologyVisibilityManagerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireVisibilityChanged() {
        ArrayList<OntologyVisibilityManagerListener> listenersCopy = new ArrayList<OntologyVisibilityManagerListener>(this.listeners);
        for (OntologyVisibilityManagerListener listener : listenersCopy) {
            listener.ontologyVisibilityChanged(this);
        }
    }
}

