import { TypeRegistry } from "@smithy/core/schema";
import type { StaticErrorSchema, StaticOperationSchema, StaticStructureSchema, StaticUnionSchema } from "@smithy/types";
export declare var CloudFrontServiceException$: StaticErrorSchema;
export declare var AccessDenied$: StaticErrorSchema;
export declare var BatchTooLarge$: StaticErrorSchema;
export declare var CachePolicyAlreadyExists$: StaticErrorSchema;
export declare var CachePolicyInUse$: StaticErrorSchema;
export declare var CannotChangeImmutablePublicKeyFields$: StaticErrorSchema;
export declare var CannotDeleteEntityWhileInUse$: StaticErrorSchema;
export declare var CannotUpdateEntityWhileInUse$: StaticErrorSchema;
export declare var CloudFrontOriginAccessIdentityAlreadyExists$: StaticErrorSchema;
export declare var CloudFrontOriginAccessIdentityInUse$: StaticErrorSchema;
export declare var CNAMEAlreadyExists$: StaticErrorSchema;
export declare var ContinuousDeploymentPolicyAlreadyExists$: StaticErrorSchema;
export declare var ContinuousDeploymentPolicyInUse$: StaticErrorSchema;
export declare var DistributionAlreadyExists$: StaticErrorSchema;
export declare var DistributionNotDisabled$: StaticErrorSchema;
export declare var EntityAlreadyExists$: StaticErrorSchema;
export declare var EntityLimitExceeded$: StaticErrorSchema;
export declare var EntityNotFound$: StaticErrorSchema;
export declare var EntitySizeLimitExceeded$: StaticErrorSchema;
export declare var FieldLevelEncryptionConfigAlreadyExists$: StaticErrorSchema;
export declare var FieldLevelEncryptionConfigInUse$: StaticErrorSchema;
export declare var FieldLevelEncryptionProfileAlreadyExists$: StaticErrorSchema;
export declare var FieldLevelEncryptionProfileInUse$: StaticErrorSchema;
export declare var FieldLevelEncryptionProfileSizeExceeded$: StaticErrorSchema;
export declare var FunctionAlreadyExists$: StaticErrorSchema;
export declare var FunctionInUse$: StaticErrorSchema;
export declare var FunctionSizeLimitExceeded$: StaticErrorSchema;
export declare var IllegalDelete$: StaticErrorSchema;
export declare var IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior$: StaticErrorSchema;
export declare var IllegalOriginAccessConfiguration$: StaticErrorSchema;
export declare var IllegalUpdate$: StaticErrorSchema;
export declare var InconsistentQuantities$: StaticErrorSchema;
export declare var InvalidArgument$: StaticErrorSchema;
export declare var InvalidAssociation$: StaticErrorSchema;
export declare var InvalidDefaultRootObject$: StaticErrorSchema;
export declare var InvalidDomainNameForOriginAccessControl$: StaticErrorSchema;
export declare var InvalidErrorCode$: StaticErrorSchema;
export declare var InvalidForwardCookies$: StaticErrorSchema;
export declare var InvalidFunctionAssociation$: StaticErrorSchema;
export declare var InvalidGeoRestrictionParameter$: StaticErrorSchema;
export declare var InvalidHeadersForS3Origin$: StaticErrorSchema;
export declare var InvalidIfMatchVersion$: StaticErrorSchema;
export declare var InvalidLambdaFunctionAssociation$: StaticErrorSchema;
export declare var InvalidLocationCode$: StaticErrorSchema;
export declare var InvalidMinimumProtocolVersion$: StaticErrorSchema;
export declare var InvalidOrigin$: StaticErrorSchema;
export declare var InvalidOriginAccessControl$: StaticErrorSchema;
export declare var InvalidOriginAccessIdentity$: StaticErrorSchema;
export declare var InvalidOriginKeepaliveTimeout$: StaticErrorSchema;
export declare var InvalidOriginReadTimeout$: StaticErrorSchema;
export declare var InvalidProtocolSettings$: StaticErrorSchema;
export declare var InvalidQueryStringParameters$: StaticErrorSchema;
export declare var InvalidRelativePath$: StaticErrorSchema;
export declare var InvalidRequiredProtocol$: StaticErrorSchema;
export declare var InvalidResponseCode$: StaticErrorSchema;
export declare var InvalidTagging$: StaticErrorSchema;
export declare var InvalidTTLOrder$: StaticErrorSchema;
export declare var InvalidViewerCertificate$: StaticErrorSchema;
export declare var InvalidWebACLId$: StaticErrorSchema;
export declare var KeyGroupAlreadyExists$: StaticErrorSchema;
export declare var MissingBody$: StaticErrorSchema;
export declare var MonitoringSubscriptionAlreadyExists$: StaticErrorSchema;
export declare var NoSuchCachePolicy$: StaticErrorSchema;
export declare var NoSuchCloudFrontOriginAccessIdentity$: StaticErrorSchema;
export declare var NoSuchContinuousDeploymentPolicy$: StaticErrorSchema;
export declare var NoSuchDistribution$: StaticErrorSchema;
export declare var NoSuchFieldLevelEncryptionConfig$: StaticErrorSchema;
export declare var NoSuchFieldLevelEncryptionProfile$: StaticErrorSchema;
export declare var NoSuchFunctionExists$: StaticErrorSchema;
export declare var NoSuchInvalidation$: StaticErrorSchema;
export declare var NoSuchMonitoringSubscription$: StaticErrorSchema;
export declare var NoSuchOrigin$: StaticErrorSchema;
export declare var NoSuchOriginAccessControl$: StaticErrorSchema;
export declare var NoSuchOriginRequestPolicy$: StaticErrorSchema;
export declare var NoSuchPublicKey$: StaticErrorSchema;
export declare var NoSuchRealtimeLogConfig$: StaticErrorSchema;
export declare var NoSuchResource$: StaticErrorSchema;
export declare var NoSuchResponseHeadersPolicy$: StaticErrorSchema;
export declare var NoSuchStreamingDistribution$: StaticErrorSchema;
export declare var OriginAccessControlAlreadyExists$: StaticErrorSchema;
export declare var OriginAccessControlInUse$: StaticErrorSchema;
export declare var OriginRequestPolicyAlreadyExists$: StaticErrorSchema;
export declare var OriginRequestPolicyInUse$: StaticErrorSchema;
export declare var PreconditionFailed$: StaticErrorSchema;
export declare var PublicKeyAlreadyExists$: StaticErrorSchema;
export declare var PublicKeyInUse$: StaticErrorSchema;
export declare var QueryArgProfileEmpty$: StaticErrorSchema;
export declare var RealtimeLogConfigAlreadyExists$: StaticErrorSchema;
export declare var RealtimeLogConfigInUse$: StaticErrorSchema;
export declare var RealtimeLogConfigOwnerMismatch$: StaticErrorSchema;
export declare var ResourceInUse$: StaticErrorSchema;
export declare var ResourceNotDisabled$: StaticErrorSchema;
export declare var ResponseHeadersPolicyAlreadyExists$: StaticErrorSchema;
export declare var ResponseHeadersPolicyInUse$: StaticErrorSchema;
export declare var StagingDistributionInUse$: StaticErrorSchema;
export declare var StreamingDistributionAlreadyExists$: StaticErrorSchema;
export declare var StreamingDistributionNotDisabled$: StaticErrorSchema;
export declare var TestFunctionFailed$: StaticErrorSchema;
export declare var TooLongCSPInResponseHeadersPolicy$: StaticErrorSchema;
export declare var TooManyCacheBehaviors$: StaticErrorSchema;
export declare var TooManyCachePolicies$: StaticErrorSchema;
export declare var TooManyCertificates$: StaticErrorSchema;
export declare var TooManyCloudFrontOriginAccessIdentities$: StaticErrorSchema;
export declare var TooManyContinuousDeploymentPolicies$: StaticErrorSchema;
export declare var TooManyCookieNamesInWhiteList$: StaticErrorSchema;
export declare var TooManyCookiesInCachePolicy$: StaticErrorSchema;
export declare var TooManyCookiesInOriginRequestPolicy$: StaticErrorSchema;
export declare var TooManyCustomHeadersInResponseHeadersPolicy$: StaticErrorSchema;
export declare var TooManyDistributionCNAMEs$: StaticErrorSchema;
export declare var TooManyDistributions$: StaticErrorSchema;
export declare var TooManyDistributionsAssociatedToCachePolicy$: StaticErrorSchema;
export declare var TooManyDistributionsAssociatedToFieldLevelEncryptionConfig$: StaticErrorSchema;
export declare var TooManyDistributionsAssociatedToKeyGroup$: StaticErrorSchema;
export declare var TooManyDistributionsAssociatedToOriginAccessControl$: StaticErrorSchema;
export declare var TooManyDistributionsAssociatedToOriginRequestPolicy$: StaticErrorSchema;
export declare var TooManyDistributionsAssociatedToResponseHeadersPolicy$: StaticErrorSchema;
export declare var TooManyDistributionsWithFunctionAssociations$: StaticErrorSchema;
export declare var TooManyDistributionsWithLambdaAssociations$: StaticErrorSchema;
export declare var TooManyDistributionsWithSingleFunctionARN$: StaticErrorSchema;
export declare var TooManyFieldLevelEncryptionConfigs$: StaticErrorSchema;
export declare var TooManyFieldLevelEncryptionContentTypeProfiles$: StaticErrorSchema;
export declare var TooManyFieldLevelEncryptionEncryptionEntities$: StaticErrorSchema;
export declare var TooManyFieldLevelEncryptionFieldPatterns$: StaticErrorSchema;
export declare var TooManyFieldLevelEncryptionProfiles$: StaticErrorSchema;
export declare var TooManyFieldLevelEncryptionQueryArgProfiles$: StaticErrorSchema;
export declare var TooManyFunctionAssociations$: StaticErrorSchema;
export declare var TooManyFunctions$: StaticErrorSchema;
export declare var TooManyHeadersInCachePolicy$: StaticErrorSchema;
export declare var TooManyHeadersInForwardedValues$: StaticErrorSchema;
export declare var TooManyHeadersInOriginRequestPolicy$: StaticErrorSchema;
export declare var TooManyInvalidationsInProgress$: StaticErrorSchema;
export declare var TooManyKeyGroups$: StaticErrorSchema;
export declare var TooManyKeyGroupsAssociatedToDistribution$: StaticErrorSchema;
export declare var TooManyLambdaFunctionAssociations$: StaticErrorSchema;
export declare var TooManyOriginAccessControls$: StaticErrorSchema;
export declare var TooManyOriginCustomHeaders$: StaticErrorSchema;
export declare var TooManyOriginGroupsPerDistribution$: StaticErrorSchema;
export declare var TooManyOriginRequestPolicies$: StaticErrorSchema;
export declare var TooManyOrigins$: StaticErrorSchema;
export declare var TooManyPublicKeys$: StaticErrorSchema;
export declare var TooManyPublicKeysInKeyGroup$: StaticErrorSchema;
export declare var TooManyQueryStringParameters$: StaticErrorSchema;
export declare var TooManyQueryStringsInCachePolicy$: StaticErrorSchema;
export declare var TooManyQueryStringsInOriginRequestPolicy$: StaticErrorSchema;
export declare var TooManyRealtimeLogConfigs$: StaticErrorSchema;
export declare var TooManyRemoveHeadersInResponseHeadersPolicy$: StaticErrorSchema;
export declare var TooManyResponseHeadersPolicies$: StaticErrorSchema;
export declare var TooManyStreamingDistributionCNAMEs$: StaticErrorSchema;
export declare var TooManyStreamingDistributions$: StaticErrorSchema;
export declare var TooManyTrustedSigners$: StaticErrorSchema;
export declare var TrustedKeyGroupDoesNotExist$: StaticErrorSchema;
export declare var TrustedSignerDoesNotExist$: StaticErrorSchema;
export declare var UnsupportedOperation$: StaticErrorSchema;
/**
 * TypeRegistry instances containing modeled errors.
 * @internal
 *
 */
export declare const errorTypeRegistries: TypeRegistry[];
export declare var ActiveTrustedKeyGroups$: StaticStructureSchema;
export declare var ActiveTrustedSigners$: StaticStructureSchema;
export declare var Aliases$: StaticStructureSchema;
export declare var AliasICPRecordal$: StaticStructureSchema;
export declare var AllowedMethods$: StaticStructureSchema;
export declare var AnycastIpList$: StaticStructureSchema;
export declare var AnycastIpListCollection$: StaticStructureSchema;
export declare var AnycastIpListSummary$: StaticStructureSchema;
export declare var AssociateAliasRequest$: StaticStructureSchema;
export declare var AssociateDistributionTenantWebACLRequest$: StaticStructureSchema;
export declare var AssociateDistributionTenantWebACLResult$: StaticStructureSchema;
export declare var AssociateDistributionWebACLRequest$: StaticStructureSchema;
export declare var AssociateDistributionWebACLResult$: StaticStructureSchema;
export declare var CaCertificatesBundleS3Location$: StaticStructureSchema;
export declare var CacheBehavior$: StaticStructureSchema;
export declare var CacheBehaviors$: StaticStructureSchema;
export declare var CachedMethods$: StaticStructureSchema;
export declare var CachePolicy$: StaticStructureSchema;
export declare var CachePolicyConfig$: StaticStructureSchema;
export declare var CachePolicyCookiesConfig$: StaticStructureSchema;
export declare var CachePolicyHeadersConfig$: StaticStructureSchema;
export declare var CachePolicyList$: StaticStructureSchema;
export declare var CachePolicyQueryStringsConfig$: StaticStructureSchema;
export declare var CachePolicySummary$: StaticStructureSchema;
export declare var Certificate$: StaticStructureSchema;
export declare var CloudFrontOriginAccessIdentity$: StaticStructureSchema;
export declare var CloudFrontOriginAccessIdentityConfig$: StaticStructureSchema;
export declare var CloudFrontOriginAccessIdentityList$: StaticStructureSchema;
export declare var CloudFrontOriginAccessIdentitySummary$: StaticStructureSchema;
export declare var ConflictingAlias$: StaticStructureSchema;
export declare var ConflictingAliasesList$: StaticStructureSchema;
export declare var ConnectionFunctionAssociation$: StaticStructureSchema;
export declare var ConnectionFunctionSummary$: StaticStructureSchema;
export declare var ConnectionFunctionTestResult$: StaticStructureSchema;
export declare var ConnectionGroup$: StaticStructureSchema;
export declare var ConnectionGroupAssociationFilter$: StaticStructureSchema;
export declare var ConnectionGroupSummary$: StaticStructureSchema;
export declare var ContentTypeProfile$: StaticStructureSchema;
export declare var ContentTypeProfileConfig$: StaticStructureSchema;
export declare var ContentTypeProfiles$: StaticStructureSchema;
export declare var ContinuousDeploymentPolicy$: StaticStructureSchema;
export declare var ContinuousDeploymentPolicyConfig$: StaticStructureSchema;
export declare var ContinuousDeploymentPolicyList$: StaticStructureSchema;
export declare var ContinuousDeploymentPolicySummary$: StaticStructureSchema;
export declare var ContinuousDeploymentSingleHeaderConfig$: StaticStructureSchema;
export declare var ContinuousDeploymentSingleWeightConfig$: StaticStructureSchema;
export declare var CookieNames$: StaticStructureSchema;
export declare var CookiePreference$: StaticStructureSchema;
export declare var CopyDistributionRequest$: StaticStructureSchema;
export declare var CopyDistributionResult$: StaticStructureSchema;
export declare var CreateAnycastIpListRequest$: StaticStructureSchema;
export declare var CreateAnycastIpListResult$: StaticStructureSchema;
export declare var CreateCachePolicyRequest$: StaticStructureSchema;
export declare var CreateCachePolicyResult$: StaticStructureSchema;
export declare var CreateCloudFrontOriginAccessIdentityRequest$: StaticStructureSchema;
export declare var CreateCloudFrontOriginAccessIdentityResult$: StaticStructureSchema;
export declare var CreateConnectionFunctionRequest$: StaticStructureSchema;
export declare var CreateConnectionFunctionResult$: StaticStructureSchema;
export declare var CreateConnectionGroupRequest$: StaticStructureSchema;
export declare var CreateConnectionGroupResult$: StaticStructureSchema;
export declare var CreateContinuousDeploymentPolicyRequest$: StaticStructureSchema;
export declare var CreateContinuousDeploymentPolicyResult$: StaticStructureSchema;
export declare var CreateDistributionRequest$: StaticStructureSchema;
export declare var CreateDistributionResult$: StaticStructureSchema;
export declare var CreateDistributionTenantRequest$: StaticStructureSchema;
export declare var CreateDistributionTenantResult$: StaticStructureSchema;
export declare var CreateDistributionWithTagsRequest$: StaticStructureSchema;
export declare var CreateDistributionWithTagsResult$: StaticStructureSchema;
export declare var CreateFieldLevelEncryptionConfigRequest$: StaticStructureSchema;
export declare var CreateFieldLevelEncryptionConfigResult$: StaticStructureSchema;
export declare var CreateFieldLevelEncryptionProfileRequest$: StaticStructureSchema;
export declare var CreateFieldLevelEncryptionProfileResult$: StaticStructureSchema;
export declare var CreateFunctionRequest$: StaticStructureSchema;
export declare var CreateFunctionResult$: StaticStructureSchema;
export declare var CreateInvalidationForDistributionTenantRequest$: StaticStructureSchema;
export declare var CreateInvalidationForDistributionTenantResult$: StaticStructureSchema;
export declare var CreateInvalidationRequest$: StaticStructureSchema;
export declare var CreateInvalidationResult$: StaticStructureSchema;
export declare var CreateKeyGroupRequest$: StaticStructureSchema;
export declare var CreateKeyGroupResult$: StaticStructureSchema;
export declare var CreateKeyValueStoreRequest$: StaticStructureSchema;
export declare var CreateKeyValueStoreResult$: StaticStructureSchema;
export declare var CreateMonitoringSubscriptionRequest$: StaticStructureSchema;
export declare var CreateMonitoringSubscriptionResult$: StaticStructureSchema;
export declare var CreateOriginAccessControlRequest$: StaticStructureSchema;
export declare var CreateOriginAccessControlResult$: StaticStructureSchema;
export declare var CreateOriginRequestPolicyRequest$: StaticStructureSchema;
export declare var CreateOriginRequestPolicyResult$: StaticStructureSchema;
export declare var CreatePublicKeyRequest$: StaticStructureSchema;
export declare var CreatePublicKeyResult$: StaticStructureSchema;
export declare var CreateRealtimeLogConfigRequest$: StaticStructureSchema;
export declare var CreateRealtimeLogConfigResult$: StaticStructureSchema;
export declare var CreateResponseHeadersPolicyRequest$: StaticStructureSchema;
export declare var CreateResponseHeadersPolicyResult$: StaticStructureSchema;
export declare var CreateStreamingDistributionRequest$: StaticStructureSchema;
export declare var CreateStreamingDistributionResult$: StaticStructureSchema;
export declare var CreateStreamingDistributionWithTagsRequest$: StaticStructureSchema;
export declare var CreateStreamingDistributionWithTagsResult$: StaticStructureSchema;
export declare var CreateTrustStoreRequest$: StaticStructureSchema;
export declare var CreateTrustStoreResult$: StaticStructureSchema;
export declare var CreateVpcOriginRequest$: StaticStructureSchema;
export declare var CreateVpcOriginResult$: StaticStructureSchema;
export declare var CustomErrorResponse$: StaticStructureSchema;
export declare var CustomErrorResponses$: StaticStructureSchema;
export declare var CustomHeaders$: StaticStructureSchema;
export declare var Customizations$: StaticStructureSchema;
export declare var CustomOriginConfig$: StaticStructureSchema;
export declare var DefaultCacheBehavior$: StaticStructureSchema;
export declare var DeleteAnycastIpListRequest$: StaticStructureSchema;
export declare var DeleteCachePolicyRequest$: StaticStructureSchema;
export declare var DeleteCloudFrontOriginAccessIdentityRequest$: StaticStructureSchema;
export declare var DeleteConnectionFunctionRequest$: StaticStructureSchema;
export declare var DeleteConnectionGroupRequest$: StaticStructureSchema;
export declare var DeleteContinuousDeploymentPolicyRequest$: StaticStructureSchema;
export declare var DeleteDistributionRequest$: StaticStructureSchema;
export declare var DeleteDistributionTenantRequest$: StaticStructureSchema;
export declare var DeleteFieldLevelEncryptionConfigRequest$: StaticStructureSchema;
export declare var DeleteFieldLevelEncryptionProfileRequest$: StaticStructureSchema;
export declare var DeleteFunctionRequest$: StaticStructureSchema;
export declare var DeleteKeyGroupRequest$: StaticStructureSchema;
export declare var DeleteKeyValueStoreRequest$: StaticStructureSchema;
export declare var DeleteMonitoringSubscriptionRequest$: StaticStructureSchema;
export declare var DeleteMonitoringSubscriptionResult$: StaticStructureSchema;
export declare var DeleteOriginAccessControlRequest$: StaticStructureSchema;
export declare var DeleteOriginRequestPolicyRequest$: StaticStructureSchema;
export declare var DeletePublicKeyRequest$: StaticStructureSchema;
export declare var DeleteRealtimeLogConfigRequest$: StaticStructureSchema;
export declare var DeleteResourcePolicyRequest$: StaticStructureSchema;
export declare var DeleteResponseHeadersPolicyRequest$: StaticStructureSchema;
export declare var DeleteStreamingDistributionRequest$: StaticStructureSchema;
export declare var DeleteTrustStoreRequest$: StaticStructureSchema;
export declare var DeleteVpcOriginRequest$: StaticStructureSchema;
export declare var DeleteVpcOriginResult$: StaticStructureSchema;
export declare var DescribeConnectionFunctionRequest$: StaticStructureSchema;
export declare var DescribeConnectionFunctionResult$: StaticStructureSchema;
export declare var DescribeFunctionRequest$: StaticStructureSchema;
export declare var DescribeFunctionResult$: StaticStructureSchema;
export declare var DescribeKeyValueStoreRequest$: StaticStructureSchema;
export declare var DescribeKeyValueStoreResult$: StaticStructureSchema;
export declare var DisassociateDistributionTenantWebACLRequest$: StaticStructureSchema;
export declare var DisassociateDistributionTenantWebACLResult$: StaticStructureSchema;
export declare var DisassociateDistributionWebACLRequest$: StaticStructureSchema;
export declare var DisassociateDistributionWebACLResult$: StaticStructureSchema;
export declare var Distribution$: StaticStructureSchema;
export declare var DistributionConfig$: StaticStructureSchema;
export declare var DistributionConfigWithTags$: StaticStructureSchema;
export declare var DistributionIdList$: StaticStructureSchema;
export declare var DistributionIdOwner$: StaticStructureSchema;
export declare var DistributionIdOwnerList$: StaticStructureSchema;
export declare var DistributionList$: StaticStructureSchema;
export declare var DistributionResourceId$: StaticStructureSchema;
export declare var DistributionSummary$: StaticStructureSchema;
export declare var DistributionTenant$: StaticStructureSchema;
export declare var DistributionTenantAssociationFilter$: StaticStructureSchema;
export declare var DistributionTenantSummary$: StaticStructureSchema;
export declare var DnsConfiguration$: StaticStructureSchema;
export declare var DomainConflict$: StaticStructureSchema;
export declare var DomainItem$: StaticStructureSchema;
export declare var DomainResult$: StaticStructureSchema;
export declare var EncryptionEntities$: StaticStructureSchema;
export declare var EncryptionEntity$: StaticStructureSchema;
export declare var EndPoint$: StaticStructureSchema;
export declare var FieldLevelEncryption$: StaticStructureSchema;
export declare var FieldLevelEncryptionConfig$: StaticStructureSchema;
export declare var FieldLevelEncryptionList$: StaticStructureSchema;
export declare var FieldLevelEncryptionProfile$: StaticStructureSchema;
export declare var FieldLevelEncryptionProfileConfig$: StaticStructureSchema;
export declare var FieldLevelEncryptionProfileList$: StaticStructureSchema;
export declare var FieldLevelEncryptionProfileSummary$: StaticStructureSchema;
export declare var FieldLevelEncryptionSummary$: StaticStructureSchema;
export declare var FieldPatterns$: StaticStructureSchema;
export declare var ForwardedValues$: StaticStructureSchema;
export declare var FunctionAssociation$: StaticStructureSchema;
export declare var FunctionAssociations$: StaticStructureSchema;
export declare var FunctionConfig$: StaticStructureSchema;
export declare var FunctionList$: StaticStructureSchema;
export declare var FunctionMetadata$: StaticStructureSchema;
export declare var FunctionSummary$: StaticStructureSchema;
export declare var GeoRestriction$: StaticStructureSchema;
export declare var GeoRestrictionCustomization$: StaticStructureSchema;
export declare var GetAnycastIpListRequest$: StaticStructureSchema;
export declare var GetAnycastIpListResult$: StaticStructureSchema;
export declare var GetCachePolicyConfigRequest$: StaticStructureSchema;
export declare var GetCachePolicyConfigResult$: StaticStructureSchema;
export declare var GetCachePolicyRequest$: StaticStructureSchema;
export declare var GetCachePolicyResult$: StaticStructureSchema;
export declare var GetCloudFrontOriginAccessIdentityConfigRequest$: StaticStructureSchema;
export declare var GetCloudFrontOriginAccessIdentityConfigResult$: StaticStructureSchema;
export declare var GetCloudFrontOriginAccessIdentityRequest$: StaticStructureSchema;
export declare var GetCloudFrontOriginAccessIdentityResult$: StaticStructureSchema;
export declare var GetConnectionFunctionRequest$: StaticStructureSchema;
export declare var GetConnectionFunctionResult$: StaticStructureSchema;
export declare var GetConnectionGroupByRoutingEndpointRequest$: StaticStructureSchema;
export declare var GetConnectionGroupByRoutingEndpointResult$: StaticStructureSchema;
export declare var GetConnectionGroupRequest$: StaticStructureSchema;
export declare var GetConnectionGroupResult$: StaticStructureSchema;
export declare var GetContinuousDeploymentPolicyConfigRequest$: StaticStructureSchema;
export declare var GetContinuousDeploymentPolicyConfigResult$: StaticStructureSchema;
export declare var GetContinuousDeploymentPolicyRequest$: StaticStructureSchema;
export declare var GetContinuousDeploymentPolicyResult$: StaticStructureSchema;
export declare var GetDistributionConfigRequest$: StaticStructureSchema;
export declare var GetDistributionConfigResult$: StaticStructureSchema;
export declare var GetDistributionRequest$: StaticStructureSchema;
export declare var GetDistributionResult$: StaticStructureSchema;
export declare var GetDistributionTenantByDomainRequest$: StaticStructureSchema;
export declare var GetDistributionTenantByDomainResult$: StaticStructureSchema;
export declare var GetDistributionTenantRequest$: StaticStructureSchema;
export declare var GetDistributionTenantResult$: StaticStructureSchema;
export declare var GetFieldLevelEncryptionConfigRequest$: StaticStructureSchema;
export declare var GetFieldLevelEncryptionConfigResult$: StaticStructureSchema;
export declare var GetFieldLevelEncryptionProfileConfigRequest$: StaticStructureSchema;
export declare var GetFieldLevelEncryptionProfileConfigResult$: StaticStructureSchema;
export declare var GetFieldLevelEncryptionProfileRequest$: StaticStructureSchema;
export declare var GetFieldLevelEncryptionProfileResult$: StaticStructureSchema;
export declare var GetFieldLevelEncryptionRequest$: StaticStructureSchema;
export declare var GetFieldLevelEncryptionResult$: StaticStructureSchema;
export declare var GetFunctionRequest$: StaticStructureSchema;
export declare var GetFunctionResult$: StaticStructureSchema;
export declare var GetInvalidationForDistributionTenantRequest$: StaticStructureSchema;
export declare var GetInvalidationForDistributionTenantResult$: StaticStructureSchema;
export declare var GetInvalidationRequest$: StaticStructureSchema;
export declare var GetInvalidationResult$: StaticStructureSchema;
export declare var GetKeyGroupConfigRequest$: StaticStructureSchema;
export declare var GetKeyGroupConfigResult$: StaticStructureSchema;
export declare var GetKeyGroupRequest$: StaticStructureSchema;
export declare var GetKeyGroupResult$: StaticStructureSchema;
export declare var GetManagedCertificateDetailsRequest$: StaticStructureSchema;
export declare var GetManagedCertificateDetailsResult$: StaticStructureSchema;
export declare var GetMonitoringSubscriptionRequest$: StaticStructureSchema;
export declare var GetMonitoringSubscriptionResult$: StaticStructureSchema;
export declare var GetOriginAccessControlConfigRequest$: StaticStructureSchema;
export declare var GetOriginAccessControlConfigResult$: StaticStructureSchema;
export declare var GetOriginAccessControlRequest$: StaticStructureSchema;
export declare var GetOriginAccessControlResult$: StaticStructureSchema;
export declare var GetOriginRequestPolicyConfigRequest$: StaticStructureSchema;
export declare var GetOriginRequestPolicyConfigResult$: StaticStructureSchema;
export declare var GetOriginRequestPolicyRequest$: StaticStructureSchema;
export declare var GetOriginRequestPolicyResult$: StaticStructureSchema;
export declare var GetPublicKeyConfigRequest$: StaticStructureSchema;
export declare var GetPublicKeyConfigResult$: StaticStructureSchema;
export declare var GetPublicKeyRequest$: StaticStructureSchema;
export declare var GetPublicKeyResult$: StaticStructureSchema;
export declare var GetRealtimeLogConfigRequest$: StaticStructureSchema;
export declare var GetRealtimeLogConfigResult$: StaticStructureSchema;
export declare var GetResourcePolicyRequest$: StaticStructureSchema;
export declare var GetResourcePolicyResult$: StaticStructureSchema;
export declare var GetResponseHeadersPolicyConfigRequest$: StaticStructureSchema;
export declare var GetResponseHeadersPolicyConfigResult$: StaticStructureSchema;
export declare var GetResponseHeadersPolicyRequest$: StaticStructureSchema;
export declare var GetResponseHeadersPolicyResult$: StaticStructureSchema;
export declare var GetStreamingDistributionConfigRequest$: StaticStructureSchema;
export declare var GetStreamingDistributionConfigResult$: StaticStructureSchema;
export declare var GetStreamingDistributionRequest$: StaticStructureSchema;
export declare var GetStreamingDistributionResult$: StaticStructureSchema;
export declare var GetTrustStoreRequest$: StaticStructureSchema;
export declare var GetTrustStoreResult$: StaticStructureSchema;
export declare var GetVpcOriginRequest$: StaticStructureSchema;
export declare var GetVpcOriginResult$: StaticStructureSchema;
export declare var GrpcConfig$: StaticStructureSchema;
export declare var Headers$: StaticStructureSchema;
export declare var ImportSource$: StaticStructureSchema;
export declare var Invalidation$: StaticStructureSchema;
export declare var InvalidationBatch$: StaticStructureSchema;
export declare var InvalidationList$: StaticStructureSchema;
export declare var InvalidationSummary$: StaticStructureSchema;
export declare var IpamCidrConfig$: StaticStructureSchema;
export declare var IpamConfig$: StaticStructureSchema;
export declare var KeyGroup$: StaticStructureSchema;
export declare var KeyGroupConfig$: StaticStructureSchema;
export declare var KeyGroupList$: StaticStructureSchema;
export declare var KeyGroupSummary$: StaticStructureSchema;
export declare var KeyPairIds$: StaticStructureSchema;
export declare var KeyValueStore$: StaticStructureSchema;
export declare var KeyValueStoreAssociation$: StaticStructureSchema;
export declare var KeyValueStoreAssociations$: StaticStructureSchema;
export declare var KeyValueStoreList$: StaticStructureSchema;
export declare var KGKeyPairIds$: StaticStructureSchema;
export declare var KinesisStreamConfig$: StaticStructureSchema;
export declare var LambdaFunctionAssociation$: StaticStructureSchema;
export declare var LambdaFunctionAssociations$: StaticStructureSchema;
export declare var ListAnycastIpListsRequest$: StaticStructureSchema;
export declare var ListAnycastIpListsResult$: StaticStructureSchema;
export declare var ListCachePoliciesRequest$: StaticStructureSchema;
export declare var ListCachePoliciesResult$: StaticStructureSchema;
export declare var ListCloudFrontOriginAccessIdentitiesRequest$: StaticStructureSchema;
export declare var ListCloudFrontOriginAccessIdentitiesResult$: StaticStructureSchema;
export declare var ListConflictingAliasesRequest$: StaticStructureSchema;
export declare var ListConflictingAliasesResult$: StaticStructureSchema;
export declare var ListConnectionFunctionsRequest$: StaticStructureSchema;
export declare var ListConnectionFunctionsResult$: StaticStructureSchema;
export declare var ListConnectionGroupsRequest$: StaticStructureSchema;
export declare var ListConnectionGroupsResult$: StaticStructureSchema;
export declare var ListContinuousDeploymentPoliciesRequest$: StaticStructureSchema;
export declare var ListContinuousDeploymentPoliciesResult$: StaticStructureSchema;
export declare var ListDistributionsByAnycastIpListIdRequest$: StaticStructureSchema;
export declare var ListDistributionsByAnycastIpListIdResult$: StaticStructureSchema;
export declare var ListDistributionsByCachePolicyIdRequest$: StaticStructureSchema;
export declare var ListDistributionsByCachePolicyIdResult$: StaticStructureSchema;
export declare var ListDistributionsByConnectionFunctionRequest$: StaticStructureSchema;
export declare var ListDistributionsByConnectionFunctionResult$: StaticStructureSchema;
export declare var ListDistributionsByConnectionModeRequest$: StaticStructureSchema;
export declare var ListDistributionsByConnectionModeResult$: StaticStructureSchema;
export declare var ListDistributionsByKeyGroupRequest$: StaticStructureSchema;
export declare var ListDistributionsByKeyGroupResult$: StaticStructureSchema;
export declare var ListDistributionsByOriginRequestPolicyIdRequest$: StaticStructureSchema;
export declare var ListDistributionsByOriginRequestPolicyIdResult$: StaticStructureSchema;
export declare var ListDistributionsByOwnedResourceRequest$: StaticStructureSchema;
export declare var ListDistributionsByOwnedResourceResult$: StaticStructureSchema;
export declare var ListDistributionsByRealtimeLogConfigRequest$: StaticStructureSchema;
export declare var ListDistributionsByRealtimeLogConfigResult$: StaticStructureSchema;
export declare var ListDistributionsByResponseHeadersPolicyIdRequest$: StaticStructureSchema;
export declare var ListDistributionsByResponseHeadersPolicyIdResult$: StaticStructureSchema;
export declare var ListDistributionsByTrustStoreRequest$: StaticStructureSchema;
export declare var ListDistributionsByTrustStoreResult$: StaticStructureSchema;
export declare var ListDistributionsByVpcOriginIdRequest$: StaticStructureSchema;
export declare var ListDistributionsByVpcOriginIdResult$: StaticStructureSchema;
export declare var ListDistributionsByWebACLIdRequest$: StaticStructureSchema;
export declare var ListDistributionsByWebACLIdResult$: StaticStructureSchema;
export declare var ListDistributionsRequest$: StaticStructureSchema;
export declare var ListDistributionsResult$: StaticStructureSchema;
export declare var ListDistributionTenantsByCustomizationRequest$: StaticStructureSchema;
export declare var ListDistributionTenantsByCustomizationResult$: StaticStructureSchema;
export declare var ListDistributionTenantsRequest$: StaticStructureSchema;
export declare var ListDistributionTenantsResult$: StaticStructureSchema;
export declare var ListDomainConflictsRequest$: StaticStructureSchema;
export declare var ListDomainConflictsResult$: StaticStructureSchema;
export declare var ListFieldLevelEncryptionConfigsRequest$: StaticStructureSchema;
export declare var ListFieldLevelEncryptionConfigsResult$: StaticStructureSchema;
export declare var ListFieldLevelEncryptionProfilesRequest$: StaticStructureSchema;
export declare var ListFieldLevelEncryptionProfilesResult$: StaticStructureSchema;
export declare var ListFunctionsRequest$: StaticStructureSchema;
export declare var ListFunctionsResult$: StaticStructureSchema;
export declare var ListInvalidationsForDistributionTenantRequest$: StaticStructureSchema;
export declare var ListInvalidationsForDistributionTenantResult$: StaticStructureSchema;
export declare var ListInvalidationsRequest$: StaticStructureSchema;
export declare var ListInvalidationsResult$: StaticStructureSchema;
export declare var ListKeyGroupsRequest$: StaticStructureSchema;
export declare var ListKeyGroupsResult$: StaticStructureSchema;
export declare var ListKeyValueStoresRequest$: StaticStructureSchema;
export declare var ListKeyValueStoresResult$: StaticStructureSchema;
export declare var ListOriginAccessControlsRequest$: StaticStructureSchema;
export declare var ListOriginAccessControlsResult$: StaticStructureSchema;
export declare var ListOriginRequestPoliciesRequest$: StaticStructureSchema;
export declare var ListOriginRequestPoliciesResult$: StaticStructureSchema;
export declare var ListPublicKeysRequest$: StaticStructureSchema;
export declare var ListPublicKeysResult$: StaticStructureSchema;
export declare var ListRealtimeLogConfigsRequest$: StaticStructureSchema;
export declare var ListRealtimeLogConfigsResult$: StaticStructureSchema;
export declare var ListResponseHeadersPoliciesRequest$: StaticStructureSchema;
export declare var ListResponseHeadersPoliciesResult$: StaticStructureSchema;
export declare var ListStreamingDistributionsRequest$: StaticStructureSchema;
export declare var ListStreamingDistributionsResult$: StaticStructureSchema;
export declare var ListTagsForResourceRequest$: StaticStructureSchema;
export declare var ListTagsForResourceResult$: StaticStructureSchema;
export declare var ListTrustStoresRequest$: StaticStructureSchema;
export declare var ListTrustStoresResult$: StaticStructureSchema;
export declare var ListVpcOriginsRequest$: StaticStructureSchema;
export declare var ListVpcOriginsResult$: StaticStructureSchema;
export declare var LoggingConfig$: StaticStructureSchema;
export declare var ManagedCertificateDetails$: StaticStructureSchema;
export declare var ManagedCertificateRequest$: StaticStructureSchema;
export declare var MonitoringSubscription$: StaticStructureSchema;
export declare var Origin$: StaticStructureSchema;
export declare var OriginAccessControl$: StaticStructureSchema;
export declare var OriginAccessControlConfig$: StaticStructureSchema;
export declare var OriginAccessControlList$: StaticStructureSchema;
export declare var OriginAccessControlSummary$: StaticStructureSchema;
export declare var OriginCustomHeader$: StaticStructureSchema;
export declare var OriginGroup$: StaticStructureSchema;
export declare var OriginGroupFailoverCriteria$: StaticStructureSchema;
export declare var OriginGroupMember$: StaticStructureSchema;
export declare var OriginGroupMembers$: StaticStructureSchema;
export declare var OriginGroups$: StaticStructureSchema;
export declare var OriginMtlsConfig$: StaticStructureSchema;
export declare var OriginRequestPolicy$: StaticStructureSchema;
export declare var OriginRequestPolicyConfig$: StaticStructureSchema;
export declare var OriginRequestPolicyCookiesConfig$: StaticStructureSchema;
export declare var OriginRequestPolicyHeadersConfig$: StaticStructureSchema;
export declare var OriginRequestPolicyList$: StaticStructureSchema;
export declare var OriginRequestPolicyQueryStringsConfig$: StaticStructureSchema;
export declare var OriginRequestPolicySummary$: StaticStructureSchema;
export declare var Origins$: StaticStructureSchema;
export declare var OriginShield$: StaticStructureSchema;
export declare var OriginSslProtocols$: StaticStructureSchema;
export declare var Parameter$: StaticStructureSchema;
export declare var ParameterDefinition$: StaticStructureSchema;
export declare var ParameterDefinitionSchema$: StaticStructureSchema;
export declare var ParametersInCacheKeyAndForwardedToOrigin$: StaticStructureSchema;
export declare var Paths$: StaticStructureSchema;
export declare var PublicKey$: StaticStructureSchema;
export declare var PublicKeyConfig$: StaticStructureSchema;
export declare var PublicKeyList$: StaticStructureSchema;
export declare var PublicKeySummary$: StaticStructureSchema;
export declare var PublishConnectionFunctionRequest$: StaticStructureSchema;
export declare var PublishConnectionFunctionResult$: StaticStructureSchema;
export declare var PublishFunctionRequest$: StaticStructureSchema;
export declare var PublishFunctionResult$: StaticStructureSchema;
export declare var PutResourcePolicyRequest$: StaticStructureSchema;
export declare var PutResourcePolicyResult$: StaticStructureSchema;
export declare var QueryArgProfile$: StaticStructureSchema;
export declare var QueryArgProfileConfig$: StaticStructureSchema;
export declare var QueryArgProfiles$: StaticStructureSchema;
export declare var QueryStringCacheKeys$: StaticStructureSchema;
export declare var QueryStringNames$: StaticStructureSchema;
export declare var RealtimeLogConfig$: StaticStructureSchema;
export declare var RealtimeLogConfigs$: StaticStructureSchema;
export declare var RealtimeMetricsSubscriptionConfig$: StaticStructureSchema;
export declare var ResponseHeadersPolicy$: StaticStructureSchema;
export declare var ResponseHeadersPolicyAccessControlAllowHeaders$: StaticStructureSchema;
export declare var ResponseHeadersPolicyAccessControlAllowMethods$: StaticStructureSchema;
export declare var ResponseHeadersPolicyAccessControlAllowOrigins$: StaticStructureSchema;
export declare var ResponseHeadersPolicyAccessControlExposeHeaders$: StaticStructureSchema;
export declare var ResponseHeadersPolicyConfig$: StaticStructureSchema;
export declare var ResponseHeadersPolicyContentSecurityPolicy$: StaticStructureSchema;
export declare var ResponseHeadersPolicyContentTypeOptions$: StaticStructureSchema;
export declare var ResponseHeadersPolicyCorsConfig$: StaticStructureSchema;
export declare var ResponseHeadersPolicyCustomHeader$: StaticStructureSchema;
export declare var ResponseHeadersPolicyCustomHeadersConfig$: StaticStructureSchema;
export declare var ResponseHeadersPolicyFrameOptions$: StaticStructureSchema;
export declare var ResponseHeadersPolicyList$: StaticStructureSchema;
export declare var ResponseHeadersPolicyReferrerPolicy$: StaticStructureSchema;
export declare var ResponseHeadersPolicyRemoveHeader$: StaticStructureSchema;
export declare var ResponseHeadersPolicyRemoveHeadersConfig$: StaticStructureSchema;
export declare var ResponseHeadersPolicySecurityHeadersConfig$: StaticStructureSchema;
export declare var ResponseHeadersPolicyServerTimingHeadersConfig$: StaticStructureSchema;
export declare var ResponseHeadersPolicyStrictTransportSecurity$: StaticStructureSchema;
export declare var ResponseHeadersPolicySummary$: StaticStructureSchema;
export declare var ResponseHeadersPolicyXSSProtection$: StaticStructureSchema;
export declare var Restrictions$: StaticStructureSchema;
export declare var S3Origin$: StaticStructureSchema;
export declare var S3OriginConfig$: StaticStructureSchema;
export declare var SessionStickinessConfig$: StaticStructureSchema;
export declare var Signer$: StaticStructureSchema;
export declare var StagingDistributionDnsNames$: StaticStructureSchema;
export declare var StatusCodes$: StaticStructureSchema;
export declare var StreamingDistribution$: StaticStructureSchema;
export declare var StreamingDistributionConfig$: StaticStructureSchema;
export declare var StreamingDistributionConfigWithTags$: StaticStructureSchema;
export declare var StreamingDistributionList$: StaticStructureSchema;
export declare var StreamingDistributionSummary$: StaticStructureSchema;
export declare var StreamingLoggingConfig$: StaticStructureSchema;
export declare var StringSchemaConfig$: StaticStructureSchema;
export declare var Tag$: StaticStructureSchema;
export declare var TagKeys$: StaticStructureSchema;
export declare var TagResourceRequest$: StaticStructureSchema;
export declare var Tags$: StaticStructureSchema;
export declare var TenantConfig$: StaticStructureSchema;
export declare var TestConnectionFunctionRequest$: StaticStructureSchema;
export declare var TestConnectionFunctionResult$: StaticStructureSchema;
export declare var TestFunctionRequest$: StaticStructureSchema;
export declare var TestFunctionResult$: StaticStructureSchema;
export declare var TestResult$: StaticStructureSchema;
export declare var TrafficConfig$: StaticStructureSchema;
export declare var TrustedKeyGroups$: StaticStructureSchema;
export declare var TrustedSigners$: StaticStructureSchema;
export declare var TrustStore$: StaticStructureSchema;
export declare var TrustStoreConfig$: StaticStructureSchema;
export declare var TrustStoreSummary$: StaticStructureSchema;
export declare var UntagResourceRequest$: StaticStructureSchema;
export declare var UpdateAnycastIpListRequest$: StaticStructureSchema;
export declare var UpdateAnycastIpListResult$: StaticStructureSchema;
export declare var UpdateCachePolicyRequest$: StaticStructureSchema;
export declare var UpdateCachePolicyResult$: StaticStructureSchema;
export declare var UpdateCloudFrontOriginAccessIdentityRequest$: StaticStructureSchema;
export declare var UpdateCloudFrontOriginAccessIdentityResult$: StaticStructureSchema;
export declare var UpdateConnectionFunctionRequest$: StaticStructureSchema;
export declare var UpdateConnectionFunctionResult$: StaticStructureSchema;
export declare var UpdateConnectionGroupRequest$: StaticStructureSchema;
export declare var UpdateConnectionGroupResult$: StaticStructureSchema;
export declare var UpdateContinuousDeploymentPolicyRequest$: StaticStructureSchema;
export declare var UpdateContinuousDeploymentPolicyResult$: StaticStructureSchema;
export declare var UpdateDistributionRequest$: StaticStructureSchema;
export declare var UpdateDistributionResult$: StaticStructureSchema;
export declare var UpdateDistributionTenantRequest$: StaticStructureSchema;
export declare var UpdateDistributionTenantResult$: StaticStructureSchema;
export declare var UpdateDistributionWithStagingConfigRequest$: StaticStructureSchema;
export declare var UpdateDistributionWithStagingConfigResult$: StaticStructureSchema;
export declare var UpdateDomainAssociationRequest$: StaticStructureSchema;
export declare var UpdateDomainAssociationResult$: StaticStructureSchema;
export declare var UpdateFieldLevelEncryptionConfigRequest$: StaticStructureSchema;
export declare var UpdateFieldLevelEncryptionConfigResult$: StaticStructureSchema;
export declare var UpdateFieldLevelEncryptionProfileRequest$: StaticStructureSchema;
export declare var UpdateFieldLevelEncryptionProfileResult$: StaticStructureSchema;
export declare var UpdateFunctionRequest$: StaticStructureSchema;
export declare var UpdateFunctionResult$: StaticStructureSchema;
export declare var UpdateKeyGroupRequest$: StaticStructureSchema;
export declare var UpdateKeyGroupResult$: StaticStructureSchema;
export declare var UpdateKeyValueStoreRequest$: StaticStructureSchema;
export declare var UpdateKeyValueStoreResult$: StaticStructureSchema;
export declare var UpdateOriginAccessControlRequest$: StaticStructureSchema;
export declare var UpdateOriginAccessControlResult$: StaticStructureSchema;
export declare var UpdateOriginRequestPolicyRequest$: StaticStructureSchema;
export declare var UpdateOriginRequestPolicyResult$: StaticStructureSchema;
export declare var UpdatePublicKeyRequest$: StaticStructureSchema;
export declare var UpdatePublicKeyResult$: StaticStructureSchema;
export declare var UpdateRealtimeLogConfigRequest$: StaticStructureSchema;
export declare var UpdateRealtimeLogConfigResult$: StaticStructureSchema;
export declare var UpdateResponseHeadersPolicyRequest$: StaticStructureSchema;
export declare var UpdateResponseHeadersPolicyResult$: StaticStructureSchema;
export declare var UpdateStreamingDistributionRequest$: StaticStructureSchema;
export declare var UpdateStreamingDistributionResult$: StaticStructureSchema;
export declare var UpdateTrustStoreRequest$: StaticStructureSchema;
export declare var UpdateTrustStoreResult$: StaticStructureSchema;
export declare var UpdateVpcOriginRequest$: StaticStructureSchema;
export declare var UpdateVpcOriginResult$: StaticStructureSchema;
export declare var ValidationTokenDetail$: StaticStructureSchema;
export declare var VerifyDnsConfigurationRequest$: StaticStructureSchema;
export declare var VerifyDnsConfigurationResult$: StaticStructureSchema;
export declare var ViewerCertificate$: StaticStructureSchema;
export declare var ViewerMtlsConfig$: StaticStructureSchema;
export declare var VpcOrigin$: StaticStructureSchema;
export declare var VpcOriginConfig$: StaticStructureSchema;
export declare var VpcOriginEndpointConfig$: StaticStructureSchema;
export declare var VpcOriginList$: StaticStructureSchema;
export declare var VpcOriginSummary$: StaticStructureSchema;
export declare var WebAclCustomization$: StaticStructureSchema;
export declare var CaCertificatesBundleSource$: StaticUnionSchema;
export declare var AssociateAlias$: StaticOperationSchema;
export declare var AssociateDistributionTenantWebACL$: StaticOperationSchema;
export declare var AssociateDistributionWebACL$: StaticOperationSchema;
export declare var CopyDistribution$: StaticOperationSchema;
export declare var CreateAnycastIpList$: StaticOperationSchema;
export declare var CreateCachePolicy$: StaticOperationSchema;
export declare var CreateCloudFrontOriginAccessIdentity$: StaticOperationSchema;
export declare var CreateConnectionFunction$: StaticOperationSchema;
export declare var CreateConnectionGroup$: StaticOperationSchema;
export declare var CreateContinuousDeploymentPolicy$: StaticOperationSchema;
export declare var CreateDistribution$: StaticOperationSchema;
export declare var CreateDistributionTenant$: StaticOperationSchema;
export declare var CreateDistributionWithTags$: StaticOperationSchema;
export declare var CreateFieldLevelEncryptionConfig$: StaticOperationSchema;
export declare var CreateFieldLevelEncryptionProfile$: StaticOperationSchema;
export declare var CreateFunction$: StaticOperationSchema;
export declare var CreateInvalidation$: StaticOperationSchema;
export declare var CreateInvalidationForDistributionTenant$: StaticOperationSchema;
export declare var CreateKeyGroup$: StaticOperationSchema;
export declare var CreateKeyValueStore$: StaticOperationSchema;
export declare var CreateMonitoringSubscription$: StaticOperationSchema;
export declare var CreateOriginAccessControl$: StaticOperationSchema;
export declare var CreateOriginRequestPolicy$: StaticOperationSchema;
export declare var CreatePublicKey$: StaticOperationSchema;
export declare var CreateRealtimeLogConfig$: StaticOperationSchema;
export declare var CreateResponseHeadersPolicy$: StaticOperationSchema;
export declare var CreateStreamingDistribution$: StaticOperationSchema;
export declare var CreateStreamingDistributionWithTags$: StaticOperationSchema;
export declare var CreateTrustStore$: StaticOperationSchema;
export declare var CreateVpcOrigin$: StaticOperationSchema;
export declare var DeleteAnycastIpList$: StaticOperationSchema;
export declare var DeleteCachePolicy$: StaticOperationSchema;
export declare var DeleteCloudFrontOriginAccessIdentity$: StaticOperationSchema;
export declare var DeleteConnectionFunction$: StaticOperationSchema;
export declare var DeleteConnectionGroup$: StaticOperationSchema;
export declare var DeleteContinuousDeploymentPolicy$: StaticOperationSchema;
export declare var DeleteDistribution$: StaticOperationSchema;
export declare var DeleteDistributionTenant$: StaticOperationSchema;
export declare var DeleteFieldLevelEncryptionConfig$: StaticOperationSchema;
export declare var DeleteFieldLevelEncryptionProfile$: StaticOperationSchema;
export declare var DeleteFunction$: StaticOperationSchema;
export declare var DeleteKeyGroup$: StaticOperationSchema;
export declare var DeleteKeyValueStore$: StaticOperationSchema;
export declare var DeleteMonitoringSubscription$: StaticOperationSchema;
export declare var DeleteOriginAccessControl$: StaticOperationSchema;
export declare var DeleteOriginRequestPolicy$: StaticOperationSchema;
export declare var DeletePublicKey$: StaticOperationSchema;
export declare var DeleteRealtimeLogConfig$: StaticOperationSchema;
export declare var DeleteResourcePolicy$: StaticOperationSchema;
export declare var DeleteResponseHeadersPolicy$: StaticOperationSchema;
export declare var DeleteStreamingDistribution$: StaticOperationSchema;
export declare var DeleteTrustStore$: StaticOperationSchema;
export declare var DeleteVpcOrigin$: StaticOperationSchema;
export declare var DescribeConnectionFunction$: StaticOperationSchema;
export declare var DescribeFunction$: StaticOperationSchema;
export declare var DescribeKeyValueStore$: StaticOperationSchema;
export declare var DisassociateDistributionTenantWebACL$: StaticOperationSchema;
export declare var DisassociateDistributionWebACL$: StaticOperationSchema;
export declare var GetAnycastIpList$: StaticOperationSchema;
export declare var GetCachePolicy$: StaticOperationSchema;
export declare var GetCachePolicyConfig$: StaticOperationSchema;
export declare var GetCloudFrontOriginAccessIdentity$: StaticOperationSchema;
export declare var GetCloudFrontOriginAccessIdentityConfig$: StaticOperationSchema;
export declare var GetConnectionFunction$: StaticOperationSchema;
export declare var GetConnectionGroup$: StaticOperationSchema;
export declare var GetConnectionGroupByRoutingEndpoint$: StaticOperationSchema;
export declare var GetContinuousDeploymentPolicy$: StaticOperationSchema;
export declare var GetContinuousDeploymentPolicyConfig$: StaticOperationSchema;
export declare var GetDistribution$: StaticOperationSchema;
export declare var GetDistributionConfig$: StaticOperationSchema;
export declare var GetDistributionTenant$: StaticOperationSchema;
export declare var GetDistributionTenantByDomain$: StaticOperationSchema;
export declare var GetFieldLevelEncryption$: StaticOperationSchema;
export declare var GetFieldLevelEncryptionConfig$: StaticOperationSchema;
export declare var GetFieldLevelEncryptionProfile$: StaticOperationSchema;
export declare var GetFieldLevelEncryptionProfileConfig$: StaticOperationSchema;
export declare var GetFunction$: StaticOperationSchema;
export declare var GetInvalidation$: StaticOperationSchema;
export declare var GetInvalidationForDistributionTenant$: StaticOperationSchema;
export declare var GetKeyGroup$: StaticOperationSchema;
export declare var GetKeyGroupConfig$: StaticOperationSchema;
export declare var GetManagedCertificateDetails$: StaticOperationSchema;
export declare var GetMonitoringSubscription$: StaticOperationSchema;
export declare var GetOriginAccessControl$: StaticOperationSchema;
export declare var GetOriginAccessControlConfig$: StaticOperationSchema;
export declare var GetOriginRequestPolicy$: StaticOperationSchema;
export declare var GetOriginRequestPolicyConfig$: StaticOperationSchema;
export declare var GetPublicKey$: StaticOperationSchema;
export declare var GetPublicKeyConfig$: StaticOperationSchema;
export declare var GetRealtimeLogConfig$: StaticOperationSchema;
export declare var GetResourcePolicy$: StaticOperationSchema;
export declare var GetResponseHeadersPolicy$: StaticOperationSchema;
export declare var GetResponseHeadersPolicyConfig$: StaticOperationSchema;
export declare var GetStreamingDistribution$: StaticOperationSchema;
export declare var GetStreamingDistributionConfig$: StaticOperationSchema;
export declare var GetTrustStore$: StaticOperationSchema;
export declare var GetVpcOrigin$: StaticOperationSchema;
export declare var ListAnycastIpLists$: StaticOperationSchema;
export declare var ListCachePolicies$: StaticOperationSchema;
export declare var ListCloudFrontOriginAccessIdentities$: StaticOperationSchema;
export declare var ListConflictingAliases$: StaticOperationSchema;
export declare var ListConnectionFunctions$: StaticOperationSchema;
export declare var ListConnectionGroups$: StaticOperationSchema;
export declare var ListContinuousDeploymentPolicies$: StaticOperationSchema;
export declare var ListDistributions$: StaticOperationSchema;
export declare var ListDistributionsByAnycastIpListId$: StaticOperationSchema;
export declare var ListDistributionsByCachePolicyId$: StaticOperationSchema;
export declare var ListDistributionsByConnectionFunction$: StaticOperationSchema;
export declare var ListDistributionsByConnectionMode$: StaticOperationSchema;
export declare var ListDistributionsByKeyGroup$: StaticOperationSchema;
export declare var ListDistributionsByOriginRequestPolicyId$: StaticOperationSchema;
export declare var ListDistributionsByOwnedResource$: StaticOperationSchema;
export declare var ListDistributionsByRealtimeLogConfig$: StaticOperationSchema;
export declare var ListDistributionsByResponseHeadersPolicyId$: StaticOperationSchema;
export declare var ListDistributionsByTrustStore$: StaticOperationSchema;
export declare var ListDistributionsByVpcOriginId$: StaticOperationSchema;
export declare var ListDistributionsByWebACLId$: StaticOperationSchema;
export declare var ListDistributionTenants$: StaticOperationSchema;
export declare var ListDistributionTenantsByCustomization$: StaticOperationSchema;
export declare var ListDomainConflicts$: StaticOperationSchema;
export declare var ListFieldLevelEncryptionConfigs$: StaticOperationSchema;
export declare var ListFieldLevelEncryptionProfiles$: StaticOperationSchema;
export declare var ListFunctions$: StaticOperationSchema;
export declare var ListInvalidations$: StaticOperationSchema;
export declare var ListInvalidationsForDistributionTenant$: StaticOperationSchema;
export declare var ListKeyGroups$: StaticOperationSchema;
export declare var ListKeyValueStores$: StaticOperationSchema;
export declare var ListOriginAccessControls$: StaticOperationSchema;
export declare var ListOriginRequestPolicies$: StaticOperationSchema;
export declare var ListPublicKeys$: StaticOperationSchema;
export declare var ListRealtimeLogConfigs$: StaticOperationSchema;
export declare var ListResponseHeadersPolicies$: StaticOperationSchema;
export declare var ListStreamingDistributions$: StaticOperationSchema;
export declare var ListTagsForResource$: StaticOperationSchema;
export declare var ListTrustStores$: StaticOperationSchema;
export declare var ListVpcOrigins$: StaticOperationSchema;
export declare var PublishConnectionFunction$: StaticOperationSchema;
export declare var PublishFunction$: StaticOperationSchema;
export declare var PutResourcePolicy$: StaticOperationSchema;
export declare var TagResource$: StaticOperationSchema;
export declare var TestConnectionFunction$: StaticOperationSchema;
export declare var TestFunction$: StaticOperationSchema;
export declare var UntagResource$: StaticOperationSchema;
export declare var UpdateAnycastIpList$: StaticOperationSchema;
export declare var UpdateCachePolicy$: StaticOperationSchema;
export declare var UpdateCloudFrontOriginAccessIdentity$: StaticOperationSchema;
export declare var UpdateConnectionFunction$: StaticOperationSchema;
export declare var UpdateConnectionGroup$: StaticOperationSchema;
export declare var UpdateContinuousDeploymentPolicy$: StaticOperationSchema;
export declare var UpdateDistribution$: StaticOperationSchema;
export declare var UpdateDistributionTenant$: StaticOperationSchema;
export declare var UpdateDistributionWithStagingConfig$: StaticOperationSchema;
export declare var UpdateDomainAssociation$: StaticOperationSchema;
export declare var UpdateFieldLevelEncryptionConfig$: StaticOperationSchema;
export declare var UpdateFieldLevelEncryptionProfile$: StaticOperationSchema;
export declare var UpdateFunction$: StaticOperationSchema;
export declare var UpdateKeyGroup$: StaticOperationSchema;
export declare var UpdateKeyValueStore$: StaticOperationSchema;
export declare var UpdateOriginAccessControl$: StaticOperationSchema;
export declare var UpdateOriginRequestPolicy$: StaticOperationSchema;
export declare var UpdatePublicKey$: StaticOperationSchema;
export declare var UpdateRealtimeLogConfig$: StaticOperationSchema;
export declare var UpdateResponseHeadersPolicy$: StaticOperationSchema;
export declare var UpdateStreamingDistribution$: StaticOperationSchema;
export declare var UpdateTrustStore$: StaticOperationSchema;
export declare var UpdateVpcOrigin$: StaticOperationSchema;
export declare var VerifyDnsConfiguration$: StaticOperationSchema;
