/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RouteServerPersistRoutesAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyRouteServerRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyRouteServerRequest> {
    private static final SdkField<String> ROUTE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerId").getter(ModifyRouteServerRequest.getter(ModifyRouteServerRequest::routeServerId)).setter(ModifyRouteServerRequest.setter(Builder::routeServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerId").unmarshallLocationName("RouteServerId").build()}).build();
    private static final SdkField<String> PERSIST_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersistRoutes").getter(ModifyRouteServerRequest.getter(ModifyRouteServerRequest::persistRoutesAsString)).setter(ModifyRouteServerRequest.setter(Builder::persistRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutes").unmarshallLocationName("PersistRoutes").build()}).build();
    private static final SdkField<Long> PERSIST_ROUTES_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PersistRoutesDuration").getter(ModifyRouteServerRequest.getter(ModifyRouteServerRequest::persistRoutesDuration)).setter(ModifyRouteServerRequest.setter(Builder::persistRoutesDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutesDuration").unmarshallLocationName("PersistRoutesDuration").build()}).build();
    private static final SdkField<Boolean> SNS_NOTIFICATIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SnsNotificationsEnabled").getter(ModifyRouteServerRequest.getter(ModifyRouteServerRequest::snsNotificationsEnabled)).setter(ModifyRouteServerRequest.setter(Builder::snsNotificationsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsNotificationsEnabled").unmarshallLocationName("SnsNotificationsEnabled").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyRouteServerRequest.getter(ModifyRouteServerRequest::dryRun)).setter(ModifyRouteServerRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ID_FIELD, PERSIST_ROUTES_FIELD, PERSIST_ROUTES_DURATION_FIELD, SNS_NOTIFICATIONS_ENABLED_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyRouteServerRequest.memberNameToFieldInitializer();
    private final String routeServerId;
    private final String persistRoutes;
    private final Long persistRoutesDuration;
    private final Boolean snsNotificationsEnabled;
    private final Boolean dryRun;

    private ModifyRouteServerRequest(BuilderImpl builder) {
        super(builder);
        this.routeServerId = builder.routeServerId;
        this.persistRoutes = builder.persistRoutes;
        this.persistRoutesDuration = builder.persistRoutesDuration;
        this.snsNotificationsEnabled = builder.snsNotificationsEnabled;
        this.dryRun = builder.dryRun;
    }

    public final String routeServerId() {
        return this.routeServerId;
    }

    public final RouteServerPersistRoutesAction persistRoutes() {
        return RouteServerPersistRoutesAction.fromValue(this.persistRoutes);
    }

    public final String persistRoutesAsString() {
        return this.persistRoutes;
    }

    public final Long persistRoutesDuration() {
        return this.persistRoutesDuration;
    }

    public final Boolean snsNotificationsEnabled() {
        return this.snsNotificationsEnabled;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistRoutesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistRoutesDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRouteServerRequest)) {
            return false;
        }
        ModifyRouteServerRequest other = (ModifyRouteServerRequest)((Object)obj);
        return Objects.equals(this.routeServerId(), other.routeServerId()) && Objects.equals(this.persistRoutesAsString(), other.persistRoutesAsString()) && Objects.equals(this.persistRoutesDuration(), other.persistRoutesDuration()) && Objects.equals(this.snsNotificationsEnabled(), other.snsNotificationsEnabled()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyRouteServerRequest").add("RouteServerId", (Object)this.routeServerId()).add("PersistRoutes", (Object)this.persistRoutesAsString()).add("PersistRoutesDuration", (Object)this.persistRoutesDuration()).add("SnsNotificationsEnabled", (Object)this.snsNotificationsEnabled()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServerId": {
                return Optional.ofNullable(clazz.cast(this.routeServerId()));
            }
            case "PersistRoutes": {
                return Optional.ofNullable(clazz.cast(this.persistRoutesAsString()));
            }
            case "PersistRoutesDuration": {
                return Optional.ofNullable(clazz.cast(this.persistRoutesDuration()));
            }
            case "SnsNotificationsEnabled": {
                return Optional.ofNullable(clazz.cast(this.snsNotificationsEnabled()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteServerId", ROUTE_SERVER_ID_FIELD);
        map.put("PersistRoutes", PERSIST_ROUTES_FIELD);
        map.put("PersistRoutesDuration", PERSIST_ROUTES_DURATION_FIELD);
        map.put("SnsNotificationsEnabled", SNS_NOTIFICATIONS_ENABLED_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyRouteServerRequest, T> g) {
        return obj -> g.apply((ModifyRouteServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String routeServerId;
        private String persistRoutes;
        private Long persistRoutesDuration;
        private Boolean snsNotificationsEnabled;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRouteServerRequest model) {
            super(model);
            this.routeServerId(model.routeServerId);
            this.persistRoutes(model.persistRoutes);
            this.persistRoutesDuration(model.persistRoutesDuration);
            this.snsNotificationsEnabled(model.snsNotificationsEnabled);
            this.dryRun(model.dryRun);
        }

        public final String getRouteServerId() {
            return this.routeServerId;
        }

        public final void setRouteServerId(String routeServerId) {
            this.routeServerId = routeServerId;
        }

        @Override
        public final Builder routeServerId(String routeServerId) {
            this.routeServerId = routeServerId;
            return this;
        }

        public final String getPersistRoutes() {
            return this.persistRoutes;
        }

        public final void setPersistRoutes(String persistRoutes) {
            this.persistRoutes = persistRoutes;
        }

        @Override
        public final Builder persistRoutes(String persistRoutes) {
            this.persistRoutes = persistRoutes;
            return this;
        }

        @Override
        public final Builder persistRoutes(RouteServerPersistRoutesAction persistRoutes) {
            this.persistRoutes(persistRoutes == null ? null : persistRoutes.toString());
            return this;
        }

        public final Long getPersistRoutesDuration() {
            return this.persistRoutesDuration;
        }

        public final void setPersistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
        }

        @Override
        public final Builder persistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
            return this;
        }

        public final Boolean getSnsNotificationsEnabled() {
            return this.snsNotificationsEnabled;
        }

        public final void setSnsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
        }

        @Override
        public final Builder snsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyRouteServerRequest build() {
            return new ModifyRouteServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyRouteServerRequest> {
        public Builder routeServerId(String var1);

        public Builder persistRoutes(String var1);

        public Builder persistRoutes(RouteServerPersistRoutesAction var1);

        public Builder persistRoutesDuration(Long var1);

        public Builder snsNotificationsEnabled(Boolean var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

