/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.delete;

import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.admin.indices.delete.DeleteIndexClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.DestructiveOperations;
import org.opensearch.action.support.TransportIndicesResolvingAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MetadataDeleteIndexService;
import org.opensearch.cluster.metadata.ResolvedIndices;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.Index;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportDeleteIndexAction
extends TransportClusterManagerNodeAction<DeleteIndexRequest, AcknowledgedResponse>
implements TransportIndicesResolvingAction<DeleteIndexRequest> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteIndexAction.class);
    private final MetadataDeleteIndexService deleteIndexService;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportDeleteIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataDeleteIndexService deleteIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super("indices:admin/delete", transportService, clusterService, threadPool, actionFilters, DeleteIndexRequest::new, indexNameExpressionResolver);
        this.deleteIndexService = deleteIndexService;
        this.destructiveOperations = destructiveOperations;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void doExecute(Task task, DeleteIndexRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteIndexRequest request, ClusterState state) {
        return state.blocks().indicesAllowReleaseResources(this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void clusterManagerOperation(DeleteIndexRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        final Index[] concreteIndices = this.resolveIndices(request, state).concreteIndicesAsArray();
        if (concreteIndices.length == 0) {
            listener.onResponse((Object)new AcknowledgedResponse(true));
            return;
        }
        DeleteIndexClusterStateUpdateRequest deleteRequest = (DeleteIndexClusterStateUpdateRequest)((DeleteIndexClusterStateUpdateRequest)((DeleteIndexClusterStateUpdateRequest)new DeleteIndexClusterStateUpdateRequest().ackTimeout(request.timeout())).clusterManagerNodeTimeout(request.clusterManagerNodeTimeout())).indices(concreteIndices);
        this.deleteIndexService.deleteIndices(deleteRequest, new ActionListener<ClusterStateUpdateResponse>(){

            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()));
            }

            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to delete indices [{}]", Arrays.asList(concreteIndices)), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    public ResolvedIndices resolveIndices(DeleteIndexRequest request) {
        return ResolvedIndices.of(this.resolveIndices(request, this.clusterService.state()));
    }

    private ResolvedIndices.Local.Concrete resolveIndices(DeleteIndexRequest request, ClusterState clusterState) {
        return this.indexNameExpressionResolver.concreteResolvedIndices(clusterState, request);
    }
}

