/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.cache.request;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Accountable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.cache.request.RequestCacheStats;

@PublicApi(since="1.0.0")
public final class ShardRequestCache {
    private static final Logger logger = LogManager.getLogger(ShardRequestCache.class);
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final CounterMetric hitCount = new CounterMetric();
    final CounterMetric missCount = new CounterMetric();

    public RequestCacheStats stats() {
        return new RequestCacheStats.Builder().memorySize(Math.max(0L, this.totalMetric.count())).evictions(this.evictionsMetric.count()).hitCount(this.hitCount.count()).missCount(this.missCount.count()).build();
    }

    public void onHit() {
        this.hitCount.inc();
    }

    public void onMiss() {
        this.missCount.inc();
    }

    public void onCached(long keyRamBytesUsed, BytesReference value) {
        this.totalMetric.inc(keyRamBytesUsed + value.ramBytesUsed());
    }

    public void onRemoval(long keyRamBytesUsed, BytesReference value, boolean evicted) {
        if (evicted) {
            this.evictionsMetric.inc();
        }
        long dec = keyRamBytesUsed;
        if (value != null) {
            dec += value.ramBytesUsed();
        }
        this.totalMetric.dec(dec);
        if (this.totalMetric.count() < 0L) {
            this.totalMetric.inc(dec);
            logger.warn("Ignoring the operation to deduct memory: {} from RequestStats memory_size metric as it will go negative. Current memory: {}. This is a bug.", (Object)dec, (Object)this.totalMetric.count());
        }
    }

    public void onCached(Accountable key, BytesReference value) {
        this.totalMetric.inc(key.ramBytesUsed() + value.ramBytesUsed());
    }

    public void onRemoval(Accountable key, BytesReference value, boolean evicted) {
        this.onRemoval(key.ramBytesUsed(), value, evicted);
    }
}

