/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.other.ConnectionProxy;
import oracle.ucp.jdbc.proxy.other.StatementProxy;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.util.UCPErrorHandler;

@ProxyFor(value={ResultSet.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ResultSetProxy
implements LogicalObject {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;

    @GetDelegate
    protected abstract ResultSet getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    private UniversalPooledConnection getUPC() {
        StatementProxy c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = (StatementProxy)this.getCreator())) {
            upc = this.proxiedPooledConnection = c.getUPC();
        }
        return upc;
    }

    private UniversalConnectionPool getUCP() {
        StatementProxy c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = (StatementProxy)this.getCreator())) {
            ucp = this.proxiedPool = c.getUCP();
        }
        return ucp;
    }

    private void throwIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(43);
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return (Statement)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(columnIndex);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex, Class<?> type) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(columnIndex, type);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(columnIndex, map);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(columnName);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName, Class<?> type) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(columnName, type);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(columnName, map);
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed.set(true);
        this.getDelegate().close();
    }

    public boolean isClosed() throws SQLException {
        return this.closed.get() || ((Statement)this.getCreator()).isClosed();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(43);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        StatementProxy stmtProxy = (StatementProxy)this.getCreator();
        if (stmtProxy.isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        ConnectionProxy connProxy = (ConnectionProxy)stmtProxy.getCreator();
        if (connProxy.isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @OnError(value=SQLException.class)
    protected void onSQLEXceptionErrorvoid(Method m, SQLException e) throws SQLException {
        this.onSQLExceptionError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onSQLExceptionError(Method m, SQLException e) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        StatementProxy stmtProxy = (StatementProxy)this.getCreator();
        ConnectionProxy connProxy = (ConnectionProxy)stmtProxy.getCreator();
        connProxy.handleSQLRecoverableException(e);
        throw e;
    }

    @OnError(value=RuntimeException.class)
    protected void onRuntimeExceptionErrorvoid(Method m, RuntimeException e) throws RuntimeException {
        this.onRuntimeExceptionError(m, e);
    }

    @OnError(value=RuntimeException.class)
    protected Object onRuntimeExceptionError(Method m, RuntimeException e) throws RuntimeException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        StatementProxy stmtProxy = (StatementProxy)this.getCreator();
        ConnectionProxy connProxy = (ConnectionProxy)stmtProxy.getCreator();
        connProxy.handleRuntimeException(e);
        throw e;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                ResultSet t = this.getDelegate();
                return (T)t;
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ResultSetProxy ? ((ResultSetProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

