/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.tableeditors;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DateTableEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private boolean autoAdjustMinimumTableRowHeight = true;
    public int clickCountToEdit = 1;
    private boolean matchTableBackgroundColor = true;
    private boolean matchTableSelectionBackgroundColor = true;
    private Border borderFocusedCell;
    private Border borderUnfocusedCell;
    private DatePicker datePicker;
    private int minimumRowHeightInPixels;

    public DateTableEditor() {
        this(true, true, true);
    }

    public DateTableEditor(boolean autoAdjustMinimumTableRowHeight, boolean matchTableBackgroundColor, boolean matchTableSelectionBackgroundColor) {
        this.autoAdjustMinimumTableRowHeight = autoAdjustMinimumTableRowHeight;
        this.matchTableBackgroundColor = matchTableBackgroundColor;
        this.matchTableSelectionBackgroundColor = matchTableSelectionBackgroundColor;
        JLabel exampleDefaultRenderer = (JLabel)new DefaultTableCellRenderer().getTableCellRendererComponent(new JTable(), "", true, true, 0, 0);
        this.borderFocusedCell = exampleDefaultRenderer.getBorder();
        this.borderUnfocusedCell = new EmptyBorder(1, 1, 1, 1);
        this.datePicker = new DatePicker();
        this.datePicker.setBorder(this.borderUnfocusedCell);
        this.datePicker.getComponentDateTextField().setBorder(null);
        DatePickerSettings settings = this.datePicker.getSettings();
        settings.setGapBeforeButtonPixels(0);
        settings.setSizeTextFieldMinimumWidthDefaultOverride(false);
        settings.setSizeTextFieldMinimumWidth(20);
        this.minimumRowHeightInPixels = this.datePicker.getPreferredSize().height + 1;
    }

    @Override
    public Object getCellEditorValue() {
        return this.datePicker.getDate();
    }

    public DatePicker getDatePicker() {
        return this.datePicker;
    }

    public DatePickerSettings getDatePickerSettings() {
        return this.datePicker.getSettings();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCellEditorValue(value);
        this.zAdjustTableRowHeightIfNeeded(table);
        this.datePicker.getComponentDateTextField().setScrollOffset(0);
        return this.datePicker;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setCellEditorValue(value);
        if (isSelected) {
            if (this.matchTableSelectionBackgroundColor) {
                this.datePicker.getComponentDateTextField().setBackground(table.getSelectionBackground());
                this.datePicker.setBackground(table.getSelectionBackground());
            } else {
                this.datePicker.zDrawTextFieldIndicators();
            }
        }
        if (!isSelected) {
            if (this.matchTableBackgroundColor) {
                this.datePicker.getComponentDateTextField().setBackground(table.getBackground());
                this.datePicker.setBackground(table.getBackground());
            } else {
                this.datePicker.zDrawTextFieldIndicators();
            }
        }
        if (hasFocus) {
            this.datePicker.setBorder(this.borderFocusedCell);
        } else {
            this.datePicker.setBorder(this.borderUnfocusedCell);
        }
        this.zAdjustTableRowHeightIfNeeded(table);
        this.datePicker.getComponentDateTextField().setScrollOffset(0);
        return this.datePicker;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToEdit;
        }
        return true;
    }

    public void setCellEditorValue(Object value) {
        this.datePicker.clear();
        if (value == null) {
            return;
        }
        if (value instanceof LocalDate) {
            LocalDate nativeValue = (LocalDate)value;
            this.datePicker.setDate(nativeValue);
        } else {
            String text = value.toString();
            String shorterText = InternalUtilities.safeSubstring(text, 0, 100);
            this.datePicker.setText(shorterText);
        }
    }

    private void zAdjustTableRowHeightIfNeeded(JTable table) {
        if (!this.autoAdjustMinimumTableRowHeight) {
            return;
        }
        if (table.getRowHeight() < this.minimumRowHeightInPixels) {
            table.setRowHeight(this.minimumRowHeightInPixels);
        }
    }
}

