/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.authentication.authenticators.broker;

import java.util.stream.Stream;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.utils.Organizations;

public class IdpAddOrganizationMemberAuthenticator
extends AbstractIdpAuthenticator {
    @Override
    protected void actionImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
    }

    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        KeycloakSession session = context.getSession();
        OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        UserModel user = context.getUser();
        OrganizationModel organization = Organizations.resolveOrganization(session);
        if (organization == null) {
            context.attempted();
            return;
        }
        Stream expectedBrokers = organization.getIdentityProviders();
        IdentityProviderModel broker = brokerContext.getIdpConfig();
        if (expectedBrokers.noneMatch(arg_0 -> ((IdentityProviderModel)broker).equals(arg_0))) {
            context.failure(AuthenticationFlowError.ACCESS_DENIED);
            return;
        }
        provider.addManagedMember(organization, user);
        context.success();
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        if (!Organizations.isEnabledAndOrganizationsPresent(provider)) {
            return false;
        }
        OrganizationModel organization = Organizations.resolveOrganization(session);
        if (organization == null || !organization.isEnabled()) {
            return false;
        }
        return provider.getIdentityProviders(organization).findAny().isPresent();
    }
}

