/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.memory.ChatMemory;
import java.util.List;
import java.util.function.Consumer;
import org.freeplane.plugin.ai.chat.AssistantProfile;
import org.freeplane.plugin.ai.chat.AssistantProfileChatMemory;
import org.freeplane.plugin.ai.chat.AssistantProfileInstructionMessage;
import org.freeplane.plugin.ai.chat.AssistantProfileSelectionModel;
import org.freeplane.plugin.ai.chat.AssistantProfileSwitchMessage;
import org.freeplane.plugin.ai.chat.LiveChatController;
import org.freeplane.plugin.ai.chat.history.AssistantProfileTranscriptEntry;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptEntry;

class AssistantProfileSelectionSync {
    private final AssistantProfileSelectionModel selectionModel;
    private final LiveChatController liveChatController;
    private ChatMemory chatMemory;
    private Consumer<String> profileMessageConsumer;
    private AssistantProfile pendingProfile;
    private String pendingProfileId;
    private String lastInjectedProfileId;

    AssistantProfileSelectionSync(AssistantProfileSelectionModel selectionModel, LiveChatController liveChatController) {
        this.selectionModel = selectionModel;
        this.liveChatController = liveChatController;
    }

    void setChatMemory(ChatMemory chatMemory) {
        this.chatMemory = chatMemory;
        if (chatMemory instanceof AssistantProfileChatMemory) {
            AssistantProfileChatMemory assistantProfileChatMemory = (AssistantProfileChatMemory)chatMemory;
            assistantProfileChatMemory.setProfileInstructionFactory(profileSwitchMessage -> {
                if (profileSwitchMessage == null) {
                    return null;
                }
                AssistantProfile selectedProfile = this.selectionModel.getSelectedProfile();
                AssistantProfile resolvedProfile = this.selectionModel.findProfileById(profileSwitchMessage.getProfileId());
                if (resolvedProfile == null) {
                    resolvedProfile = selectedProfile == null ? AssistantProfile.defaultProfile() : selectedProfile;
                }
                return new AssistantProfileInstructionMessage(resolvedProfile.getId(), resolvedProfile.getName(), resolvedProfile.getPrompt());
            });
        }
    }

    void setProfileMessageConsumer(Consumer<String> profileMessageConsumer) {
        this.profileMessageConsumer = profileMessageConsumer;
    }

    void applyAssistantProfileSelection(AssistantProfile profile) {
        if (profile == null) {
            return;
        }
        AssistantProfileSwitchMessage message = new AssistantProfileSwitchMessage(profile.getId(), profile.getName());
        if (message.getProfileId().isEmpty() && message.getProfileName().isEmpty()) {
            return;
        }
        if (this.chatMemory != null) {
            this.chatMemory.add((ChatMessage)message);
        }
        this.liveChatController.recordAssistantProfileMessage(message);
        if (this.profileMessageConsumer != null) {
            this.profileMessageConsumer.accept(profile.getName());
        }
        this.lastInjectedProfileId = this.profileId(profile);
    }

    void handleUserSelection(AssistantProfile profile) {
        if (profile == null) {
            return;
        }
        this.selectionModel.setSelectedProfile(profile, true);
        this.pendingProfile = profile;
        this.pendingProfileId = this.profileId(profile);
    }

    AssistantProfile selectForActivation(boolean fromTranscriptRestore) {
        AssistantProfile transcriptProfile;
        List<ChatTranscriptEntry> entries = this.liveChatController.snapshotTranscriptEntries();
        AssistantProfileTranscriptEntry profileEntry = this.findLastAssistantProfileEntry(entries);
        AssistantProfile selected = this.selectionModel.getSelectedProfile();
        if (profileEntry == null && !fromTranscriptRestore) {
            this.lastInjectedProfileId = null;
            this.pendingProfile = selected;
            this.pendingProfileId = this.profileId(selected);
            return selected;
        }
        String transcriptProfileId = profileEntry == null ? "" : this.normalize(profileEntry.getProfileId());
        boolean transcriptProfileExists = false;
        if (!transcriptProfileId.isEmpty() && (transcriptProfile = this.selectionModel.findProfileById(transcriptProfileId)) != null) {
            this.selectionModel.setSelectedProfile(transcriptProfile, false);
            selected = transcriptProfile;
            transcriptProfileExists = true;
        }
        if (fromTranscriptRestore) {
            this.lastInjectedProfileId = profileEntry != null && transcriptProfileExists ? this.profileId(selected) : null;
            this.pendingProfile = selected;
            this.pendingProfileId = this.profileId(selected);
            return selected;
        }
        if (profileEntry != null && !transcriptProfileId.isEmpty() && !transcriptProfileExists) {
            this.lastInjectedProfileId = null;
            this.pendingProfile = selected;
            this.pendingProfileId = this.profileId(selected);
            return selected;
        }
        this.lastInjectedProfileId = this.profileId(selected);
        this.pendingProfile = selected;
        this.pendingProfileId = this.lastInjectedProfileId;
        return selected;
    }

    void maybeInjectBeforeUserMessage() {
        if (this.pendingProfile == null || this.pendingProfileId == null || this.pendingProfileId.trim().isEmpty()) {
            return;
        }
        if (this.pendingProfileId.equals(this.lastInjectedProfileId)) {
            this.pendingProfile = null;
            this.pendingProfileId = null;
            return;
        }
        this.applyAssistantProfileSelection(this.pendingProfile);
        this.pendingProfile = null;
        this.pendingProfileId = null;
    }

    private AssistantProfileTranscriptEntry findLastAssistantProfileEntry(List<ChatTranscriptEntry> entries) {
        for (int index = entries.size() - 1; index >= 0; --index) {
            ChatTranscriptEntry entry = entries.get(index);
            if (!(entry instanceof AssistantProfileTranscriptEntry)) continue;
            return (AssistantProfileTranscriptEntry)entry;
        }
        return null;
    }

    private String profileId(AssistantProfile profile) {
        if (profile == null) {
            return "";
        }
        return this.normalize(profile.getId());
    }

    private String normalize(String text) {
        return text == null ? "" : text.trim();
    }
}

