/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;

public class ExtendedClassLoader
extends ClassLoader
implements AutoCloseable {
    private final URLClassLoader urlClassLoader;
    private final ProtectionDomain protectionDomain;

    public ExtendedClassLoader(URL[] extensionUrls, Class<?> prototype) {
        this(extensionUrls, prototype.getClassLoader(), prototype.getProtectionDomain());
    }

    protected ExtendedClassLoader(URL[] extensionUrls, ClassLoader parent, ProtectionDomain protectionDomain) {
        super(parent);
        this.protectionDomain = protectionDomain;
        this.urlClassLoader = new URLClassLoader(extensionUrls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> preload(String name) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            return this.findClassFromAdditionalLoader(this.getParent(), name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.findClassFromAdditionalLoader(this.urlClassLoader, name);
        if (cls != null) {
            return cls;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        URL urlResource = this.urlClassLoader.findResource(name);
        return urlResource != null ? urlResource : super.findResource(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> findClassFromAdditionalLoader(ClassLoader cl, String name) {
        String resourceName = name.replace('.', '/').concat(".class");
        try (InputStream is = cl.getResourceAsStream(resourceName);){
            if (is == null) return null;
            byte[] classBytes = this.readAllBytes(is);
            Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length, this.protectionDomain);
            return clazz;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private byte[] readAllBytes(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] dataChunk = new byte[16384];
        while ((bytesRead = is.read(dataChunk, 0, dataChunk.length)) != -1) {
            buffer.write(dataChunk, 0, bytesRead);
        }
        return buffer.toByteArray();
    }

    @Override
    public void close() throws IOException {
        this.urlClassLoader.close();
    }
}

