/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gaussdb.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GaussDBProcedure
extends PostgreProcedure {
    public long propackageid;
    public String prokind;
    public String procSrc;
    public String body = this.getBody();

    public long getPropackageid() {
        return this.propackageid;
    }

    public GaussDBProcedure(PostgreSchema schema) {
        super(schema);
    }

    public GaussDBProcedure(DBRProgressMonitor monitor, PostgreSchema schema, ResultSet dbResult) {
        super(monitor, schema, dbResult);
        this.propackageid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"propackageid");
        this.procSrc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prosrc");
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        boolean omitHeader = CommonUtils.getOption(options, (String)"debugger.source");
        Object procDDL = omitHeader || CommonUtils.getOption(options, (String)"ddl.skipDrops") ? "" : "-- DROP " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + ";\n\n";
        procDDL = this.isPersisted() && (!((PostgreDataSource)this.getDataSource()).getServerType().supportsFunctionDefRead() || omitHeader) && !this.isAggregate() ? this.getObjectDefinitionTextWhenPersisted(monitor, omitHeader, (String)procDDL) : this.getObjectDefinitionTextWhenBodyNull(monitor, (String)procDDL);
        if (this.isPersisted() && !omitHeader) {
            procDDL = (String)procDDL + ";\n";
            if (CommonUtils.getOption(options, (String)"ddl.includeComments") && !CommonUtils.isEmpty((String)this.getDescription())) {
                procDDL = (String)procDDL + "\nCOMMENT ON " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)this, (String)this.getDescription()) + ";\n";
            }
            if (CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
                ArrayList actions = new ArrayList();
                PostgreUtils.getObjectGrantPermissionActions((DBRProgressMonitor)monitor, (PostgrePrivilegeOwner)this, actions, options);
                procDDL = (String)procDDL + "\n" + SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false);
            }
        }
        return procDDL;
    }

    private String getObjectDefinitionTextWhenPersisted(DBRProgressMonitor monitor, boolean omitHeader, String procDDL) throws DBCException, DBException {
        PostgreDataType returnType;
        if (this.procSrc == null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read procedure body");){
                    this.procSrc = JDBCUtils.queryString((Connection)session, (String)"SELECT prosrc FROM pg_proc where oid = ?", (Object[])new Object[]{this.getObjectId()});
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error reading procedure body", (Throwable)e);
            }
        }
        String returnTypeName = (returnType = this.getReturnType()) == null ? null : returnType.getFullTypeName();
        return procDDL + (omitHeader ? this.procSrc : this.generateFunctionDeclaration(this.getLanguage(monitor), returnTypeName, this.procSrc));
    }

    private String getObjectDefinitionTextWhenBodyNull(DBRProgressMonitor monitor, String procDDL) throws DBException, DBCException {
        if (this.body == null) {
            if (!this.isPersisted()) {
                PostgreDataType returnType = this.getReturnType();
                String returnTypeName = returnType == null ? null : returnType.getFullTypeName();
                this.body = this.generateFunctionDeclaration(this.getLanguage(monitor), returnTypeName, "\n\t-- Enter function body here\n");
            } else if (this.getObjectId() == 0L) {
                this.body = this.procSrc;
            } else {
                try {
                    Throwable returnType = null;
                    Object var4_8 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read procedure body");){
                        String res = JDBCUtils.queryString((Connection)session, (String)("SELECT pg_get_functiondef(" + this.getObjectId() + ")"), (Object[])new Object[0]);
                        this.body = res == null ? this.procSrc : res.substring(4, res.length() - 2);
                    }
                    catch (Throwable throwable) {
                        if (returnType == null) {
                            returnType = throwable;
                        } else if (returnType != throwable) {
                            returnType.addSuppressed(throwable);
                        }
                        throw returnType;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Error reading procedure body", (Throwable)e);
                }
            }
        }
        return procDDL + this.body;
    }
}

