/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import org.apache.solr.cloud.DistributedLock;
import org.apache.solr.cloud.ZkDistributedLock;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

abstract class ZkDistributedLockFactory {
    private final SolrZkClient zkClient;
    private final String rootPath;

    ZkDistributedLockFactory(SolrZkClient zkClient, String rootPath) {
        this.zkClient = zkClient;
        this.rootPath = rootPath;
    }

    protected DistributedLock doCreateLock(boolean isWriteLock, String lockPath) {
        try {
            this.makeLockPath(lockPath);
            return isWriteLock ? new ZkDistributedLock.Write(this.zkClient, lockPath) : new ZkDistributedLock.Read(this.zkClient, lockPath);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    protected StringBuilder getPathPrefix() {
        StringBuilder path = new StringBuilder(100);
        path.append(this.rootPath).append("/");
        return path;
    }

    private void makeLockPath(String lockNodePath) throws KeeperException, InterruptedException {
        try {
            if (!this.zkClient.exists(lockNodePath, true).booleanValue()) {
                this.zkClient.makePath(lockNodePath, new byte[0], CreateMode.PERSISTENT, true);
            }
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }
}

