/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.BytesRefIteratorTokenStream;
import org.apache.lucene.spatial.prefix.CellToBytesRefIterator;
import org.apache.lucene.spatial.prefix.HeatmapFacetCounter;
import org.apache.lucene.spatial.prefix.PointPrefixTreeFieldCacheProvider;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.util.ShapeFieldCacheDistanceValueSource;
import org.apache.lucene.util.Bits;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public abstract class PrefixTreeStrategy
extends SpatialStrategy {
    protected final SpatialPrefixTree grid;
    private final Map<String, PointPrefixTreeFieldCacheProvider> provider = new ConcurrentHashMap<String, PointPrefixTreeFieldCacheProvider>();
    protected int defaultFieldValuesArrayLen = 2;
    protected double distErrPct = 0.025;
    protected boolean pointsOnly = false;
    public static final FieldType FIELD_TYPE = new FieldType();

    public PrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid.getSpatialContext(), fieldName);
        this.grid = grid;
    }

    public SpatialPrefixTree getGrid() {
        return this.grid;
    }

    public void setDefaultFieldValuesArrayLen(int defaultFieldValuesArrayLen) {
        this.defaultFieldValuesArrayLen = defaultFieldValuesArrayLen;
    }

    public double getDistErrPct() {
        return this.distErrPct;
    }

    public void setDistErrPct(double distErrPct) {
        this.distErrPct = distErrPct;
    }

    public boolean isPointsOnly() {
        return this.pointsOnly;
    }

    public void setPointsOnly(boolean pointsOnly) {
        this.pointsOnly = pointsOnly;
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        double distErr = SpatialArgs.calcDistanceFromErrPct(shape, this.distErrPct, this.ctx);
        return this.createIndexableFields(shape, distErr);
    }

    public Field[] createIndexableFields(Shape shape, double distErr) {
        int detailLevel = this.grid.getLevelForDistance(distErr);
        return this.createIndexableFields(shape, detailLevel);
    }

    public Field[] createIndexableFields(Shape shape, int detailLevel) {
        Iterator<Cell> cells = this.createCellIteratorToIndex(shape, detailLevel, null);
        CellToBytesRefIterator cellToBytesRefIterator = this.newCellToBytesRefIterator();
        cellToBytesRefIterator.reset(cells);
        BytesRefIteratorTokenStream tokenStream = new BytesRefIteratorTokenStream();
        tokenStream.setBytesRefIterator(cellToBytesRefIterator);
        Field field = new Field(this.getFieldName(), (TokenStream)tokenStream, (IndexableFieldType)FIELD_TYPE);
        return new Field[]{field};
    }

    public ShapeTokenStream tokenStream() {
        return new ShapeTokenStream();
    }

    protected CellToBytesRefIterator newCellToBytesRefIterator() {
        return new CellToBytesRefIterator();
    }

    protected Iterator<Cell> createCellIteratorToIndex(Shape shape, int detailLevel, Iterator<Cell> reuse) {
        if (this.pointsOnly && !this.isPointShape(shape)) {
            throw new IllegalArgumentException("pointsOnly is true yet a " + String.valueOf(shape.getClass()) + " is given for indexing");
        }
        return this.grid.getTreeCellIterator(shape, detailLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleValuesSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        PointPrefixTreeFieldCacheProvider p = this.provider.get(this.getFieldName());
        if (p == null) {
            PrefixTreeStrategy prefixTreeStrategy = this;
            synchronized (prefixTreeStrategy) {
                p = this.provider.get(this.getFieldName());
                if (p == null) {
                    p = new PointPrefixTreeFieldCacheProvider(this.grid, this.getFieldName(), this.defaultFieldValuesArrayLen);
                    this.provider.put(this.getFieldName(), p);
                }
            }
        }
        return new ShapeFieldCacheDistanceValueSource(this.ctx, p, queryPoint, multiplier);
    }

    public HeatmapFacetCounter.Heatmap calcFacets(IndexReaderContext context, Bits topAcceptDocs, Shape inputShape, int facetLevel, int maxCells) throws IOException {
        return HeatmapFacetCounter.calcFacets(this, context, topAcceptDocs, inputShape, facetLevel, maxCells);
    }

    protected boolean isPointShape(Shape shape) {
        return shape instanceof Point;
    }

    static {
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.freeze();
    }

    public class ShapeTokenStream
    extends BytesRefIteratorTokenStream {
        public void setShape(Shape shape) {
            double distErr = SpatialArgs.calcDistanceFromErrPct(shape, PrefixTreeStrategy.this.distErrPct, PrefixTreeStrategy.this.ctx);
            int detailLevel = PrefixTreeStrategy.this.grid.getLevelForDistance(distErr);
            Iterator<Cell> cells = PrefixTreeStrategy.this.createCellIteratorToIndex(shape, detailLevel, null);
            CellToBytesRefIterator cellToBytesRefIterator = PrefixTreeStrategy.this.newCellToBytesRefIterator();
            cellToBytesRefIterator.reset(cells);
            this.setBytesRefIterator(cellToBytesRefIterator);
        }
    }
}

