/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalDataManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalSavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositorySetupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.SizeDoesNotMatchException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.ConnectionManager;
import com.ibm.db2.cmx.runtime.internal.repository.util.StreamUtils;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.DefaultActionProcessor;
import com.ibm.db2.cmx.tools.internal.repository.ManageRepositoryUtility;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeleteActionProcessor
extends DefaultActionProcessor {
    @Override
    public PureQueryUtility.UtilityResult processAction(PossibleArgs possibleArgs, ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, RepositoryVersion repositoryVersion, PrintWriter printWriter) throws MetadataException, IOException, Exception {
        PureQueryUtility.UtilityResult utilityResult = null;
        PossibleArgs.PredefinedOptionValues predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DELETE);
        if (predefinedOptionValues != null) {
            if (PossibleArgs.PredefinedOptionValues.REPOSITORY == predefinedOptionValues) {
                utilityResult = this.deleteRepository(artifactOptionsSet, connection, string, repositoryVersion, printWriter);
            } else if (PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP == predefinedOptionValues) {
                utilityResult = this.deleteRuntimeGroup(artifactOptionsSet, connection, string);
            } else if (PossibleArgs.PredefinedOptionValues.INCREMENTAL == predefinedOptionValues) {
                utilityResult = this.deleteIncrementalCaptureData(artifactOptionsSet, connection, string, printWriter);
            }
        }
        return utilityResult;
    }

    private PureQueryUtility.UtilityResult deleteRepository(ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, RepositoryVersion repositoryVersion, PrintWriter printWriter) throws MetadataException, IOException, Exception {
        PureQueryUtility.UtilityResult utilityResult = null;
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GENERATE_SCRIPT_ONLY);
        RepositorySetupManager repositorySetupManager = ManagerFactory.getRepositorySetupManager(connection);
        if (!artifactOptionsSet.getOptionValueBoolean(PossibleArgs.FORCE) && string2 == null && !this.isDeleteConfirmedByUser("repository", artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DELETE))) {
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
            utilityResult.reason = Messages.getText("MSG_DELETE_CANCELED", new Object[0]);
            return utilityResult;
        }
        if (repositoryVersion == null) {
            String string3 = connection.getMetaData().getURL();
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
            utilityResult.reason = Messages.getText("ERR_REPOSITORY_DOES_NOT_EXIST", new Object[]{string3, string, PossibleArgs.REPOSITORY_SCHEMA});
            return utilityResult;
        }
        ConnectionManager.ConnectionType connectionType = ConnectionManager.getConnectionType(connection);
        String string4 = connection.getMetaData().getDatabaseProductVersion().toUpperCase();
        if (string2 != null) {
            FileWriter fileWriter = new FileWriter(string2);
            List<String> list = repositorySetupManager.getDropScript(true, string, repositoryVersion);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ManageRepositoryUtility.writeCommandScript(list, fileWriter, databaseMetaData);
        } else {
            repositorySetupManager.removeRepository(string, printWriter, repositoryVersion);
        }
        utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
        if (connectionType.equals((Object)ConnectionManager.ConnectionType.DB2) && string4.startsWith("SQL")) {
            utilityResult.reason = Messages.getText("MSG_DELETE_REPOSITORY", new Object[0]);
        }
        return utilityResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    private PureQueryUtility.UtilityResult deleteRuntimeGroup(ArtifactOptionsSet artifactOptionsSet, Connection connection, String string) throws MetadataException, IOException, SQLException {
        PureQueryUtility.UtilityResult utilityResult = null;
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
        String string3 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_VERSION);
        String string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.FORCE);
        RuntimeGroupManager runtimeGroupManager = ManagerFactory.getRuntimeGroupManager(connection, string);
        if (string4.equalsIgnoreCase("false") && !this.isDeleteConfirmedByUser(string2, artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DELETE))) {
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
            utilityResult.reason = Messages.getText("MSG_DELETE_CANCELED", string2);
            return utilityResult;
        }
        if (string3 != null) {
            if (!ManageRepositoryUtility.runtimeGroupVersionExists(string2, string3, runtimeGroupManager)) {
                utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.MR_SKIP);
                utilityResult.reason = Messages.getText("MSG_ERROR_RUNTIMEGROUP_VERSION_NOT_FOUND", string2, string3);
                return utilityResult;
            }
            runtimeGroupManager.delete(string2, string3);
        } else {
            if (!ManageRepositoryUtility.runtimeGroupExists(string2, runtimeGroupManager)) {
                utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.MR_SKIP);
                utilityResult.reason = Messages.getText("MSG_ERROR_RUNTIMEGROUP_NOT_FOUND", string2);
                return utilityResult;
            }
            runtimeGroupManager.deleteAllVersions(string2);
        }
        connection.commit();
        connection.rollback();
        return new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
    }

    private boolean isDeleteConfirmedByUser(String string, PossibleArgs.PredefinedOptionValues predefinedOptionValues) throws IOException {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        if (predefinedOptionValues == PossibleArgs.PredefinedOptionValues.REPOSITORY) {
            printWriter.println(Messages.getText("MSG_CONFIRMING_DELETE_REPOSITORY", new Object[0]).replace("\\n", ""));
        } else if (predefinedOptionValues == PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP) {
            printWriter.println(Messages.getText("MSG_CONFIRMING_DELETE_RUNTIMEGROUP", string).replace("\\n", ""));
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string2 = bufferedReader.readLine();
        if (string2.equalsIgnoreCase("Y") || string2.equalsIgnoreCase("YES")) {
            return true;
        }
        if (string2.equalsIgnoreCase("N") || string2.equalsIgnoreCase("NO")) {
            return false;
        }
        return false;
    }

    private PureQueryUtility.UtilityResult deleteIncrementalCaptureData(ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, PrintWriter printWriter) throws MetadataException {
        PureQueryUtility.UtilityResult utilityResult = null;
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
        String string3 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.INCREMENTAL_CAPTURE);
        String string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.INPUT_DIRECTORY);
        if (string4 != null && !string4.endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        IncrementalDataManager incrementalDataManager = ManagerFactory.getIncrementalDataManager(connection, string);
        String string5 = "";
        string5 = string3 + "_";
        List<Object> list = new ArrayList();
        if (string4 != null) {
            list = this.getExtractedCaptureFiles(string4, string5);
        }
        List<IncrementalSavedDataInfo> list2 = incrementalDataManager.list(string2);
        if (list.size() > 0 && list2.size() > 0) {
            HashMap<File, Exception> hashMap = new HashMap<File, Exception>();
            Map<File, IncrementalSavedDataInfo> map = this.mapFilesToRepository(list, list2, incrementalDataManager, hashMap);
            int n2 = 0;
            for (File file : list) {
                String string6;
                IncrementalSavedDataInfo incrementalSavedDataInfo = map.get(file);
                if (incrementalSavedDataInfo != null) {
                    String string7;
                    int n3 = (int)file.length();
                    try {
                        incrementalDataManager.delete(incrementalSavedDataInfo.getKey(), n3);
                        ++n2;
                        string6 = Messages.getText("MSG_DELETE_INCREMENTAL_FILE_SUCCEED", file.getName());
                        printWriter.println(string6);
                    }
                    catch (SizeDoesNotMatchException sizeDoesNotMatchException) {
                        string7 = Messages.getText("ERR_INC_DELETE_CANNOT_MATCH_FILE", file.getName());
                        printWriter.println(string7);
                    }
                    catch (MetadataException metadataException) {
                        string7 = Messages.getText("ERR_INC_DELETE_CANNOT_PROCESS_FILE", file.getName(), metadataException.getMessage());
                        printWriter.println(string7);
                    }
                    continue;
                }
                Exception exception = (Exception)hashMap.get(file);
                if (exception != null) {
                    string6 = Messages.getText("ERR_INC_DELETE_CANNOT_PROCESS_FILE", file.getName(), exception.getMessage());
                    printWriter.println(string6);
                    continue;
                }
                string6 = Messages.getText("ERR_INC_DELETE_CANNOT_MATCH_FILE", file.getName());
                printWriter.println(string6);
            }
            utilityResult = n2 > 0 ? new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS) : new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
        } else if (list.size() == 0) {
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
            utilityResult.reason = Messages.getText("MSG_ERROR_EXTRACTED_INCREMENTAL_CAPTURES_NOT_FOUND", new Object[0]);
        } else if (list2.size() == 0) {
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
            utilityResult.reason = Messages.getText("MSG_ERROR_INCREMENTAL_CAPTURES_NOT_FOUND", new Object[0]);
        }
        return utilityResult;
    }

    private List<File> getExtractedCaptureFiles(String string, String string2) {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isFile() || !file2.getName().startsWith(string2)) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContents(File file) throws IOException {
        FileInputStream fileInputStream = null;
        String string = null;
        try {
            fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.copyStream(fileInputStream, byteArrayOutputStream);
            byteArrayOutputStream.close();
            string = new String(byteArrayOutputStream.toByteArray());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private Map<File, IncrementalSavedDataInfo> mapFilesToRepository(List<File> list, List<IncrementalSavedDataInfo> list2, IncrementalDataManager incrementalDataManager, Map<File, Exception> map) {
        HashMap<File, IncrementalSavedDataInfo> hashMap = new HashMap<File, IncrementalSavedDataInfo>();
        HashMap<IncrementalSavedDataInfo, Integer> hashMap2 = new HashMap<IncrementalSavedDataInfo, Integer>();
        ArrayList<IncrementalSavedDataInfo> arrayList = new ArrayList<IncrementalSavedDataInfo>();
        arrayList.addAll(list2);
        ArrayList<IncrementalSavedDataInfo> arrayList2 = new ArrayList<IncrementalSavedDataInfo>();
        for (File file : list) {
            arrayList2.clear();
            try {
                Object object;
                long l2 = file.length();
                for (IncrementalSavedDataInfo incrementalSavedDataInfo : arrayList) {
                    if (l2 != incrementalSavedDataInfo.getLength()) continue;
                    arrayList2.add(incrementalSavedDataInfo);
                }
                if (arrayList2.size() > 0) {
                    object = this.calculateHash(file);
                    for (int i10 = arrayList2.size() - 1; i10 >= 0; --i10) {
                        IncrementalSavedDataInfo incrementalSavedDataInfo = (IncrementalSavedDataInfo)arrayList2.get(i10);
                        Integer n2 = (Integer)hashMap2.get(incrementalSavedDataInfo);
                        if (n2 == null && (n2 = this.calcuateHash(incrementalDataManager, incrementalSavedDataInfo)) != null) {
                            hashMap2.put(incrementalSavedDataInfo, n2);
                        }
                        if (n2 != null && n2.equals(object)) continue;
                        arrayList2.remove(i10);
                    }
                }
                object = null;
                if (arrayList2.size() > 0) {
                    int n3 = 0;
                    long l3 = ((IncrementalSavedDataInfo)arrayList2.get(0)).getUpdateTime();
                    for (int i11 = 1; i11 < arrayList2.size(); ++i11) {
                        IncrementalSavedDataInfo incrementalSavedDataInfo = (IncrementalSavedDataInfo)arrayList2.get(i11);
                        if (incrementalSavedDataInfo.getUpdateTime() >= l3) continue;
                        l3 = incrementalSavedDataInfo.getUpdateTime();
                        n3 = i11;
                    }
                    object = (IncrementalSavedDataInfo)arrayList2.get(n3);
                }
                if (object == null) continue;
                arrayList.remove(object);
                hashMap.put(file, (IncrementalSavedDataInfo)object);
            }
            catch (IOException iOException) {
                map.put(file, iOException);
            }
            catch (MetadataException metadataException) {
                map.put(file, metadataException);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer calcuateHash(IncrementalDataManager incrementalDataManager, IncrementalSavedDataInfo incrementalSavedDataInfo) throws MetadataException, IOException {
        InputStream inputStream = null;
        Integer n2 = null;
        try {
            inputStream = incrementalDataManager.getContent(incrementalSavedDataInfo.getKey());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.copyStream(inputStream, byteArrayOutputStream);
            byteArrayOutputStream.close();
            String string = new String(byteArrayOutputStream.toByteArray());
            n2 = string.hashCode();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return n2;
    }

    private Integer calculateHash(File file) throws IOException {
        String string = this.getFileContents(file);
        return string.hashCode();
    }
}

