/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.tools.lint.LintObjectType;
import schemacrawler.tools.lint.LintSeverity;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.Utility;

public final class Lint<V extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -8627082144974643415L;
    private final String lintId = UUID.randomUUID().toString();
    private final String linterId;
    private final String linterInstanceId;
    private final String message;
    private final NamedObjectKey objectKey;
    private final String objectName;
    private final LintObjectType objectType;
    private final LintSeverity severity;
    private final V value;

    <N extends NamedObject> Lint(String linterId, String linterInstanceId, LintObjectType objectType, N namedObject, LintSeverity severity, String message, V value) {
        this.linterId = Utility.requireNotBlank((String)linterId, (String)"Linter id not provided");
        this.linterInstanceId = Utility.requireNotBlank((String)linterInstanceId, (String)"Linter instance id not provided");
        this.objectType = Objects.requireNonNull(objectType, "Named object type not provided");
        Objects.requireNonNull(namedObject, "Named object not provided");
        this.objectKey = namedObject.key();
        this.objectName = namedObject.getFullName();
        this.severity = severity == null ? LintSeverity.critical : severity;
        if (Utility.isBlank((CharSequence)message)) {
            throw new IllegalArgumentException("Lint message not provided");
        }
        this.message = message;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Lint)) {
            return false;
        }
        Lint lint = (Lint)o;
        return Objects.equals(this.linterId, lint.linterId) && this.objectType == lint.objectType && Objects.equals(this.objectKey, lint.objectKey) && this.severity == lint.severity && Objects.equals(this.message, lint.message) && Objects.equals(this.value, lint.value);
    }

    public String getLinterId() {
        return this.linterId;
    }

    public String getLinterInstanceId() {
        return this.linterInstanceId;
    }

    public String getLintId() {
        return this.lintId;
    }

    public String getMessage() {
        return this.message;
    }

    public NamedObjectKey getObjectKey() {
        return this.objectKey;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public LintObjectType getObjectType() {
        return this.objectType;
    }

    public LintSeverity getSeverity() {
        return this.severity;
    }

    public V getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.hasValue()) {
            return ObjectToString.listOrObjectToString(this.value);
        }
        return "";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linterId, this.objectType, this.objectKey, this.severity, this.message, this.value});
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String toString() {
        String valueString = this.hasValue() ? ": " + this.value : "";
        return String.format("[%s] %s%s", this.objectName, this.message, valueString);
    }
}

