/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaSetter;
import schemacrawler.schema.CheckOptionType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import us.fatehi.utility.string.StringFormat;

final class ViewExtRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(ViewExtRetriever.class.getName());

    ViewExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveViewInformation() throws SQLException {
        if (this.catalog.getTables().isEmpty()) {
            LOGGER.log(Level.FINE, "No tables found");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.VIEWS)) {
            LOGGER.log(Level.INFO, "Not retrieving additional view information, since this was not requested");
            LOGGER.log(Level.FINE, "Views SQL statement was not provided");
            return;
        }
        Query viewInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.VIEWS);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.viewInformationRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving additional view information, using fast data dictionary retrieval over schemas");
                this.retrieveViewInformationOverSchemas(viewInformationSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving additional view information, using fast data dictionary retrieval");
                this.retrieveViewInformationFromDataDictionary(viewInformationSql);
            }
        }
    }

    void retrieveViewTableUsage() throws SQLException {
        if (this.catalog.getTables().isEmpty()) {
            LOGGER.log(Level.FINE, "No tables found");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.VIEW_TABLE_USAGE)) {
            LOGGER.log(Level.INFO, "Not retrieving additional view table usage, since this was not requested");
            LOGGER.log(Level.FINE, "View table usage SQL statement was not provided");
            return;
        }
        Query viewTableUsageSql = informationSchemaViews.getQuery(InformationSchemaKey.VIEW_TABLE_USAGE);
        LOGGER.log(Level.INFO, "Retrieving view table usage");
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.viewTableUsageRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving view table usage, using fast data dictionary retrieval over schemas");
                this.retrieveViewTableUsageOverSchemas(viewTableUsageSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving view table usage, using fast data dictionary retrieval");
                this.retrieveViewTableUsageFromDataDictionary(viewTableUsageSql);
            }
        }
    }

    private boolean addViewInformation(MetadataResultSet results) {
        String viewName;
        String schemaName;
        String definition = results.getString("VIEW_DEFINITION");
        String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
        Optional<MutableTable> viewOptional = this.lookupTable(catalogName, schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA")), viewName = results.getString("TABLE_NAME"));
        if (!viewOptional.isPresent()) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, viewName}));
            return false;
        }
        MutableView view = (MutableView)viewOptional.get();
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving additional view information <%s>", new Object[]{viewName}));
        CheckOptionType checkOption = results.getEnum("CHECK_OPTION", CheckOptionType.unknown);
        boolean updatable = results.getBoolean("IS_UPDATABLE");
        view.setDefinition(definition);
        view.setCheckOption(checkOption);
        view.setUpdatable(updatable);
        view.addAttributes(results.getAttributes());
        return true;
    }

    private boolean addViewTableUsage(MetadataResultSet results) {
        String viewName;
        String schemaName;
        String catalogName = this.normalizeCatalogName(results.getString("VIEW_CATALOG"));
        Optional<MutableTable> viewOptional = this.lookupTable(catalogName, schemaName = this.normalizeSchemaName(results.getString("VIEW_SCHEMA")), viewName = results.getString("VIEW_NAME"));
        if (!viewOptional.isPresent()) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find view <%s.%s.%s>", new Object[]{catalogName, schemaName, viewName}));
            return false;
        }
        MutableView view = (MutableView)viewOptional.get();
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving view information <%s>", new Object[]{viewName}));
        String tableCatalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
        String tableSchemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
        String tableName = results.getString("TABLE_NAME");
        Optional<MutableTable> tableOptional = this.lookupTable(tableCatalogName, tableSchemaName, tableName);
        if (!tableOptional.isPresent()) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{tableCatalogName, tableSchemaName, tableName}));
            return false;
        }
        MutableTable table = tableOptional.get();
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving table information <%s>", new Object[]{tableName}));
        view.addTableUsage(table);
        return true;
    }

    private void retrieveViewInformationFromDataDictionary(Query viewInformationSql) throws SQLException {
        String name = "additional view information";
        RetrievalCounts retrievalCounts = new RetrievalCounts("additional view information");
        try (Connection connection = this.getRetrieverConnection().getConnection("additional view information");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(viewInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean addedViewInformation = this.addViewInformation(results);
                retrievalCounts.countIfIncluded(addedViewInformation);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional view information", e);
        }
        retrievalCounts.log();
    }

    private void retrieveViewInformationOverSchemas(Query viewInformationSql) throws SQLException {
        String name = "additional view information";
        RetrievalCounts retrievalCounts = new RetrievalCounts("additional view information");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("additional view information");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(viewInformationSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean addedViewInformation = this.addViewInformation(results);
                    retrievalCounts.countIfIncluded(schema.key(), addedViewInformation);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve additional view information for schema <%s>", new Object[]{schema}));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }

    private void retrieveViewTableUsageFromDataDictionary(Query viewTableUsageSql) throws SQLException {
        String name = "views for table usage";
        RetrievalCounts retrievalCounts = new RetrievalCounts("views for table usage");
        try (Connection connection = this.getRetrieverConnection().getConnection("views for table usage");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(viewTableUsageSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean addedTableUsage = this.addViewTableUsage(results);
                retrievalCounts.countIfIncluded(addedTableUsage);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table usage for views", e);
        }
        retrievalCounts.log();
    }

    private void retrieveViewTableUsageOverSchemas(Query viewTableUsageSql) throws SQLException {
        String name = "views for table usage";
        RetrievalCounts retrievalCounts = new RetrievalCounts("views for table usage");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("views for table usage");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(viewTableUsageSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean addedTableUsage = this.addViewTableUsage(results);
                    retrievalCounts.countIfIncluded(schema.key(), addedTableUsage);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve table usage for views for schema <%s>", new Object[]{schema}));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

