/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraint;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaSetter;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import us.fatehi.utility.string.StringFormat;

final class TableConstraintRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableConstraintRetriever.class.getName());
    private final Map<NamedObjectKey, MutableTableConstraint> tableConstraintsMap = new HashMap<NamedObjectKey, MutableTableConstraint>();

    TableConstraintRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveTableConstraintColumns() throws SQLException {
        if (this.tableConstraintsMap.isEmpty()) {
            LOGGER.log(Level.FINE, "No table constraints found");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.CONSTRAINT_COLUMN_USAGE)) {
            LOGGER.log(Level.FINE, "Table constraints columns usage SQL statement was not provided");
            return;
        }
        Query tableConstraintsColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.CONSTRAINT_COLUMN_USAGE);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tableConstraintColumnsRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving table constraint columns, using fast data dictionary retrieval over schemas");
                this.retrieveTableConstraintColumnsOverSchemas(tableConstraintsColumnsSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving table constraint columns, using fast data dictionary retrieval");
                this.retrieveTableConstraintColumnsFromDataDictionary(tableConstraintsColumnsSql);
            }
        }
    }

    void retrieveTableConstraintDefinitions() throws SQLException {
        if (this.tableConstraintsMap.isEmpty()) {
            LOGGER.log(Level.FINE, "No table constraints found");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.CHECK_CONSTRAINTS)) {
            LOGGER.log(Level.FINE, "Extended table check constraints SQL statement was not provided");
            return;
        }
        Query checkConstraintSql = informationSchemaViews.getQuery(InformationSchemaKey.CHECK_CONSTRAINTS);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tableCheckConstraintsRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving check constraint definitions, using fast data dictionary retrieval over schemas");
                this.retrieveTableConstraintDefinitionsOverSchemas(checkConstraintSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving check constraint definitions, using fast data dictionary retrieval");
                this.retrieveTableConstraintDefinitionsFromDataDictionary(checkConstraintSql);
            }
        }
    }

    void retrieveTableConstraintInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_TABLE_CONSTRAINTS)) {
            LOGGER.log(Level.INFO, "Not retrieving additional table constraint information, since this was not requested");
            LOGGER.log(Level.FINE, "Additional table constraints information SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional table constraint information");
        Query extTableConstraintsSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_TABLE_CONSTRAINTS);
        String name = "table constraint information";
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraint information");
        try (Connection connection = this.getRetrieverConnection().getConnection("table constraint information");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(extTableConstraintsSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                String tableConstraintName = results.getString("CONSTRAINT_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableConstraintName}));
                    continue;
                }
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving additional table constraint information <%s>", new Object[]{tableConstraintName}));
                MutableTable table = tableOptional.get();
                Optional<TableConstraint> tableConstraintOptional = table.lookupTableConstraint(tableConstraintName);
                if (!tableConstraintOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table constraint <%s.%s.%s.%s>", new Object[]{catalogName, schemaName, tableName, tableConstraintName}));
                    continue;
                }
                TableConstraint tableConstraint = tableConstraintOptional.get();
                String remarks = results.getString("REMARKS");
                tableConstraint.setRemarks(remarks);
                Map<String, Object> attributes = results.getAttributes();
                Set<Map.Entry<String, Object>> entrySet = attributes.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    tableConstraint.setAttribute(entry.getKey(), entry.getValue());
                }
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table constraint information", e);
        }
        retrievalCounts.log();
    }

    void retrieveTableConstraints() throws SQLException {
        if (this.catalog.getTables().isEmpty()) {
            LOGGER.log(Level.FINE, "No tables found");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TABLE_CONSTRAINTS)) {
            LOGGER.log(Level.FINE, "Table constraints SQL statement was not provided");
            return;
        }
        Query tableConstraintsSql = informationSchemaViews.getQuery(InformationSchemaKey.TABLE_CONSTRAINTS);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tableConstraintsRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving table constraints, using fast data dictionary retrieval over schemas");
                this.retrieveTableConstraintsOverSchemas(tableConstraintsSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving table constraints, using fast data dictionary retrieval");
                this.retrieveTableConstraintsFromDataDictionary(tableConstraintsSql);
            }
        }
    }

    private boolean addTableConstraintDefinition(MetadataResultSet results) {
        String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
        String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
        String constraintName = results.getString("CONSTRAINT_NAME");
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving definition for constraint <%s>", new Object[]{constraintName}));
        String definition = results.getString("CHECK_CLAUSE");
        MutableTableConstraint tableConstraint = this.tableConstraintsMap.get(new NamedObjectKey(catalogName, schemaName, constraintName));
        if (tableConstraint == null) {
            LOGGER.log(Level.FINEST, (Supplier<String>)new StringFormat("Could not add table constraint <%s>", new Object[]{constraintName}));
            return false;
        }
        tableConstraint.setDefinition(definition);
        tableConstraint.addAttributes(results.getAttributes());
        return true;
    }

    private boolean createTableConstraint(MetadataResultSet results) {
        String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
        String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
        String constraintName = results.getString("CONSTRAINT_NAME");
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving constraint <%s>", new Object[]{constraintName}));
        String tableName = results.getString("TABLE_NAME");
        Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
        if (!tableOptional.isPresent()) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
            return false;
        }
        MutableTable table = tableOptional.get();
        String constraintType = results.getString("CONSTRAINT_TYPE");
        boolean deferrable = results.getBoolean("IS_DEFERRABLE");
        boolean initiallyDeferred = results.getBoolean("INITIALLY_DEFERRED");
        MutableTableConstraint tableConstraint = new MutableTableConstraint(table, constraintName);
        tableConstraint.setTableConstraintType(TableConstraintType.valueOfFromValue(constraintType));
        tableConstraint.setDeferrable(deferrable);
        tableConstraint.setInitiallyDeferred(initiallyDeferred);
        tableConstraint.addAttributes(results.getAttributes());
        table.addTableConstraint(tableConstraint);
        this.tableConstraintsMap.put(table.getSchema().key().with(constraintName), tableConstraint);
        return true;
    }

    private boolean createTableConstraintColumn(MetadataResultSet results) {
        String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
        String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
        String constraintName = results.getString("CONSTRAINT_NAME");
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving table constraint column for <%s.%s.%s>", new Object[]{catalogName, schemaName, constraintName}));
        MutableTableConstraint tableConstraint = this.tableConstraintsMap.get(new NamedObjectKey(catalogName, schemaName, constraintName));
        if (tableConstraint == null) {
            LOGGER.log(Level.FINEST, (Supplier<String>)new StringFormat("Could not add column constraint <%s>", new Object[]{constraintName}));
            return false;
        }
        String tableName = results.getString("TABLE_NAME");
        Table table = (Table)tableConstraint.getParent();
        if (!table.getName().equals(tableName)) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
            return false;
        }
        String columnName = results.getString("COLUMN_NAME");
        Optional columnOptional = table.lookupColumn(columnName);
        if (!columnOptional.isPresent()) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find column <%s.%s.%s.%s>", new Object[]{catalogName, schemaName, tableName, columnName}));
            return false;
        }
        MutableColumn column = (MutableColumn)columnOptional.get();
        int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
        MutableTableConstraintColumn constraintColumn = new MutableTableConstraintColumn(tableConstraint, column);
        constraintColumn.setKeyOrdinalPosition(ordinalPosition);
        tableConstraint.addColumn(constraintColumn);
        return true;
    }

    private void retrieveTableConstraintColumnsFromDataDictionary(Query tableConstraintsColumnsSql) {
        String name = "table constraints columns";
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraints columns");
        try (Connection connection = this.getRetrieverConnection().getConnection("table constraints columns");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableConstraintsColumnsSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.createTableConstraintColumn(results);
                retrievalCounts.countIfIncluded(added);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table constraint columns", e);
        }
        retrievalCounts.log();
    }

    private void retrieveTableConstraintColumnsOverSchemas(Query tableConstraintsColumnsSql) throws SQLException {
        String name = "table constraints columns";
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraints columns");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("table constraints columns");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(tableConstraintsColumnsSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean added = this.createTableConstraintColumn(results);
                    retrievalCounts.countIfIncluded(schema.key(), added);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve table constraint columns for schema <%s>", new Object[]{schema}));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }

    private void retrieveTableConstraintDefinitionsFromDataDictionary(Query checkConstraintSql) {
        String name = "check constraint definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("check constraint definitions");
        try (Connection connection = this.getRetrieverConnection().getConnection("check constraint definitions");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(checkConstraintSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.addTableConstraintDefinition(results);
                retrievalCounts.countIfIncluded(added);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", e);
        }
        retrievalCounts.log();
    }

    private void retrieveTableConstraintDefinitionsOverSchemas(Query checkConstraintSql) throws SQLException {
        String name = "check constraint definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("check constraint definitions");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("check constraint definitions");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(checkConstraintSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count();
                    boolean added = this.addTableConstraintDefinition(results);
                    retrievalCounts.countIfIncluded(added);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve check constraint definitions for schema <%s>", new Object[]{schema}));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }

    private void retrieveTableConstraintsFromDataDictionary(Query tableConstraintsSql) {
        String name = "table constraints";
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraints");
        try (Connection connection = this.getRetrieverConnection().getConnection("table constraints");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableConstraintsSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.createTableConstraint(results);
                retrievalCounts.countIfIncluded(added);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table constraint information", e);
            return;
        }
        retrievalCounts.log();
    }

    private void retrieveTableConstraintsOverSchemas(Query tableConstraintsSql) throws SQLException {
        String name = "table constraints";
        RetrievalCounts retrievalCounts = new RetrievalCounts("table constraints");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("table constraints");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(tableConstraintsSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean added = this.createTableConstraint(results);
                    retrievalCounts.countIfIncluded(schema.key(), added);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve table constraints for schema <%s>", new Object[]{schema}));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

