/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder;

import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.FileLoader;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.proxy.db2.ProxiedDB2ConnectionInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlPackage;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementSet;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.runtime.statement.StatementDescriptor;
import com.ibm.db2.cmx.tools.DataVersion;
import com.ibm.db2.cmx.tools.internal.PDQDB2Types;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.binder.BindLexer;
import com.ibm.db2.cmx.tools.internal.binder.SRInfoAboutStatementSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.jcc.DB2Connection;
import com.ibm.db2.jcc.DB2Driver;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.w3c.dom.Element;

public class BindMetaDataInfo {
    private byte[] consistencyToken_;
    private String rootPkgName_;
    private String collectionNameFromPdqxmlOrImpl_;
    private StatementDescriptorImpl[] statementDescriptorArray_;
    private String encodingForDBRM_ = null;
    private String[] bindStatementsIncludesReservedSections_;
    private int[] bindSectionNum_;
    private SQLJColumnMetaData[] hostVariableInfo_;
    private DatabaseMetaData databaseMetaData_ = null;
    protected StaticProfileConstants.DBInfo dbInfo_ = StaticProfileConstants.DBInfo.dummyDBInfo_;
    protected boolean isDB2ForZOS_ = false;
    protected boolean isDB2ForLUW_ = false;
    private boolean databaseSupportsBinaryTypes_;
    private boolean supportsCommentOnPackage_ = true;
    private boolean staticReadOnlySet_ = false;
    private boolean bindObjectExistenceSet_ = false;
    private boolean dbprotocolSet_ = false;
    private boolean queryBlockProtocolSet_ = false;
    private String packageVersion_ = null;
    private int collectionNameMaxLength_;
    private int pkgNameMaxLength_;
    private String grantOption_ = null;
    private boolean isDDLPackage_ = false;
    private String[] originalSQLStmtArray_;
    private String[] sqlIdArray_;
    private ArrayList<Element> stmtElementList_;
    private boolean modifiedDom_ = false;
    private PossibleArgs.PredefinedOptionValues invalidSqlAction_ = PossibleArgs.PredefinedOptionValues.CONTINUE;
    private boolean forceSingleBindIsolation_ = false;
    private SRInfoAboutStatementSet srInfoAboutStatementSet_ = null;
    private boolean detectSingleton_ = false;
    private String bindOptionsStringFromPureQueryXml_ = null;
    private String xmlFileName_ = null;
    private boolean isFileInputNotResource_ = false;
    private String isolationFromPackage_ = null;
    private Timestamp pkgCreationTime_ = null;
    private List<String> skippedPackages_ = new ArrayList<String>();
    private String collectionNameFromBindOptionsString_ = null;
    private String qualifierFromBindOptionsString_ = null;
    private boolean isolationSet_ = false;
    private boolean verifyIfPackageExists_ = false;
    private int countForPackagesThatExist_ = 0;
    private int countForPackagesThatDoNotExist_ = 0;
    public int programSetVersion_ = 0;
    private final PureQueryUtility.UtilityResult utilityResult_ = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
    private int numberOfBindableTrueStatementsToBind_ = 0;
    private int numBindableFalseStatements_ = 0;
    private List<String> bindableTrueStatementsNotBound_ = null;
    private int numInputStatements_ = 0;
    private int numDDLStatements_ = 0;
    private List<String> bindableFalseStatementSetsList_ = new ArrayList<String>();
    private List<String> bindableStatementSetsWithNoBindableStatementsList_ = new ArrayList<String>();
    private int numStatementSets_ = 0;
    private List<String> bindableStatementSetsWithBindableStatementsList_ = new ArrayList<String>();
    private boolean foundRequestedBasePackageName_ = false;
    private boolean isImpl_ = false;
    protected final List<String> configureWarningValues_;
    private boolean thisCallHasReturnValue_;
    protected boolean userCaresAboutSpecialRegistersInThisFile_ = true;
    private final DB2Connection connectionFromODSTooling_;
    private final boolean binderShouldCommitOrRollback_;
    protected static final boolean autoCommitValueNeeded = false;

    public BindMetaDataInfo(DB2Connection dB2Connection, boolean bl2, ArtifactOptionsSet artifactOptionsSet) {
        this.connectionFromODSTooling_ = dB2Connection;
        this.binderShouldCommitOrRollback_ = bl2;
        if (null != artifactOptionsSet) {
            this.configureWarningValues_ = artifactOptionsSet.getOptionOrArtifactMultipleValues(PossibleArgs.CONFIGURE_WARNING, true);
            if (null != this.configureWarningValues_ && 0 < this.configureWarningValues_.size()) {
                this.setUtilityResultType(PureQueryUtility.UtilityResultType.COMPLETED_WITH_WARNINGS, BindMetaDataInfo.getWarningMessagesForConfigureWarnings(this.configureWarningValues_));
            }
        } else {
            this.configureWarningValues_ = null;
        }
    }

    public void setMetaData(String string, Connection connection, String string2) throws SQLException, IllegalAccessException {
        this.setInformationFromImplAndCheckVersion(string, string2);
        this.setBindMetaData(connection);
        this.validateCollectionAndPackageNameLength(this.collectionNameFromPdqxmlOrImpl_, this.rootPkgName_);
    }

    public void setMetaData(PDQXmlStatementSet pDQXmlStatementSet, Connection connection) throws SQLException {
        this.setInformationFromXML(pDQXmlStatementSet);
        this.setBindMetaData(connection);
        this.checkVersion();
    }

    private void setBindMetaData(Connection connection) throws SQLException {
        this.setDatabaseMetaData(connection);
        if (0 == this.statementDescriptorArray_.length) {
            ToolsLogger.getLogger().log(Level.WARNING, "Statement list is empty. Skipping.");
        } else {
            SQLInfoArray sQLInfoArray = new SQLInfoArray(this.statementDescriptorArray_.length);
            this.bindSectionNum_ = new int[this.statementDescriptorArray_.length];
            this.bindStatementsIncludesReservedSections_ = new String[this.statementDescriptorArray_.length];
            this.hostVariableInfo_ = new SQLJColumnMetaData[this.statementDescriptorArray_.length];
            StatementDescriptorImpl statementDescriptorImpl = null;
            for (int i10 = 0; i10 < this.statementDescriptorArray_.length; ++i10) {
                statementDescriptorImpl = this.statementDescriptorArray_[i10];
                if (SqlStatementType.isDDL(statementDescriptorImpl.getSqlStatementType())) {
                    ++this.numDDLStatements_;
                }
                this.bindSectionNum_[i10] = statementDescriptorImpl.getSection();
                ((SQLInfoArray)sQLInfoArray).sqlStmtArray[i10] = BindLexer.removeFinalSemicolon(statementDescriptorImpl.getProcessedSql());
                if (statementDescriptorImpl.isParameterMetaDataPresent()) {
                    ((SQLInfoArray)sQLInfoArray).sqlInputParamTypeArray[i10] = statementDescriptorImpl.getParameterMetaDataType(true);
                    ((SQLInfoArray)sQLInfoArray).sqlInputParamPrecisionArray[i10] = statementDescriptorImpl.getParameterMetaDataPrecision();
                    ((SQLInfoArray)sQLInfoArray).sqlInputParamScalesArray[i10] = statementDescriptorImpl.getParameterMetaDataScale();
                    ((SQLInfoArray)sQLInfoArray).sqlInputParamModeArray[i10] = statementDescriptorImpl.getParameterMetaDataMode();
                }
                this.forceSingleBindIsolation_ = statementDescriptorImpl.isForceSingleBindIsolation();
                if (statementDescriptorImpl.hasSingleRowResult() && statementDescriptorImpl.isResultSetMetaDataPresent()) {
                    ((SQLInfoArray)sQLInfoArray).sqlResultParamTypeArray[i10] = statementDescriptorImpl.getResultSetMetaDataType(true);
                    ((SQLInfoArray)sQLInfoArray).sqlResultParamPrecisionArray[i10] = statementDescriptorImpl.getResultSetMetaDataPrecision();
                    ((SQLInfoArray)sQLInfoArray).sqlResultParamScalesArray[i10] = statementDescriptorImpl.getResultSetMetaDataScale();
                }
                int[] nArray = new int[]{0};
                if (this.statementDescriptorArray_[i10].isSELECTorVALUESorXQUERYorSINGLEROWQUERY()) {
                    this.buildCursorEntry(i10, sQLInfoArray, nArray);
                } else if (this.statementDescriptorArray_[i10].getColumnNames() != null) {
                    this.buildAutoGeneratedKeyEntry(i10, sQLInfoArray);
                } else {
                    this.buildNonCursorEntry(i10, sQLInfoArray);
                }
                this.hostVariableInfo_[i10] = this.processHostVars(sQLInfoArray, i10, nArray[0]);
            }
        }
    }

    public boolean packageContainsStatementsToBind() {
        return null != this.statementDescriptorArray_ && 0 < this.statementDescriptorArray_.length;
    }

    public void setDatabaseMetaData(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData;
        this.databaseMetaData_ = databaseMetaData = connection.getMetaData();
        this.dbInfo_ = new StaticProfileConstants.DBInfo(databaseMetaData);
        this.isDB2ForZOS_ = StaticProfileConstants.DatabaseType.DB2forZOS == this.dbInfo_.databaseType_;
        this.isDB2ForLUW_ = StaticProfileConstants.DatabaseType.DB2forLUW == this.dbInfo_.databaseType_;
        this.databaseSupportsBinaryTypes_ = true;
        if (this.isDB2ForLUW_ || this.isDB2ForZOS_ && StaticProfileConstants.isDatabaseProductLevelLessThan(this.dbInfo_, 9, 1, Character.valueOf('5'))) {
            this.databaseSupportsBinaryTypes_ = false;
        }
        if (this.isDB2ForLUW_ && !StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 8, 1, Character.valueOf('0')) || this.isDB2ForZOS_ && StaticProfileConstants.isDatabaseProductLevelLessThan(this.dbInfo_, 8, 1, Character.valueOf('5'))) {
            this.supportsCommentOnPackage_ = false;
        }
        this.encodingForDBRM_ = this.isDB2ForZOS_ && StaticProfileConstants.isDatabaseProductLevelLessThan(this.dbInfo_, 8, 1, Character.valueOf('5')) ? "Cp037" : "UTF-8";
        if (this.isDB2ForLUW_) {
            if (StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 9, 5, Character.valueOf('0'))) {
                this.collectionNameMaxLength_ = 128;
                this.pkgNameMaxLength_ = 128;
            } else {
                this.collectionNameMaxLength_ = 30;
                this.pkgNameMaxLength_ = 8;
            }
        }
        if (this.isDB2ForZOS_) {
            if (StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 8, 1, Character.valueOf('5'))) {
                this.collectionNameMaxLength_ = 128;
                this.pkgNameMaxLength_ = 128;
            } else {
                this.collectionNameMaxLength_ = 18;
                this.pkgNameMaxLength_ = 8;
            }
        }
    }

    public DatabaseMetaData getDatabaseMetaData() {
        return this.databaseMetaData_;
    }

    public int getCollectionNameMaxLength() {
        return this.collectionNameMaxLength_;
    }

    public int getPkgNameMaxLength() {
        return this.pkgNameMaxLength_;
    }

    private String getCursorName(StatementDescriptorImpl statementDescriptorImpl, int n2) {
        if (statementDescriptorImpl.getCursorName() != null) {
            return "\"" + statementDescriptorImpl.getCursorName() + "\"";
        }
        return "DB2JCCCURSOR" + n2;
    }

    private void buildAutoGeneratedKeyEntry(int n2, SQLInfoArray sQLInfoArray) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = this.statementDescriptorArray_[n2].getConcurrency();
        int n4 = this.statementDescriptorArray_[n2].getHoldability();
        String string = this.getCursorName(this.statementDescriptorArray_[n2], this.bindSectionNum_[n2]);
        int n5 = this.statementDescriptorArray_[n2].getType();
        boolean bl2 = this.statementDescriptorArray_[n2].isAllowStaticRowsetCursors();
        boolean bl3 = StatementUtilities.checkIfShouldUseRowsetCursorInBindAndStaticExecution(bl2, StatementUtilities.doesDatabaseSupportRowsetCursors(this.databaseMetaData_), true);
        stringBuffer.append("DECLARE " + string);
        if (n5 == 1005) {
            if (this.isDB2ForLUW_ || this.isDB2ForZOS_) {
                stringBuffer.append(" SENSITIVE STATIC SCROLL");
            } else {
                stringBuffer.append(" SENSITIVE SCROLL");
            }
        } else if (n5 == 1004) {
            stringBuffer.append(" INSENSITIVE SCROLL");
        }
        stringBuffer.append(" CURSOR");
        if (1 == n4) {
            stringBuffer.append(" WITH HOLD");
        }
        if (bl3) {
            stringBuffer.append(" WITH ROWSET POSITIONING ");
        }
        stringBuffer.append(" FOR ");
        stringBuffer2.append("SELECT ");
        for (int i10 = 0; i10 < this.statementDescriptorArray_[n2].getColumnNames().length; ++i10) {
            stringBuffer2.append(" " + this.statementDescriptorArray_[n2].getColumnNames()[i10]);
            if (i10 >= this.statementDescriptorArray_[n2].getColumnNames().length - 1) continue;
            stringBuffer2.append(", ");
        }
        stringBuffer2.append(" FROM FINAL TABLE( ");
        String string2 = sQLInfoArray.sqlStmtArray[n2];
        if (sQLInfoArray.sqlInputParamTypeArray[n2] != null) {
            string2 = this.parseSQLForStaticExecution(sQLInfoArray.sqlStmtArray[n2]);
        }
        stringBuffer2.append(string2);
        stringBuffer2.append(") ");
        string2 = stringBuffer2.toString();
        string2 = n3 == 1008 ? BindLexer.getQueryWithUpdateClause(string2) : BindLexer.getQueryWithReadOnlyClause(string2);
        stringBuffer.append(string2);
        this.bindStatementsIncludesReservedSections_[n2] = stringBuffer.toString();
        ToolsLogger.getLogger().log(Level.FINER, this.bindStatementsIncludesReservedSections_[n2]);
    }

    private String parseSQLForStaticExecution(String string) {
        this.thisCallHasReturnValue_ = false;
        if (string.toUpperCase().indexOf("CALL") != -1 && string.indexOf("{") != -1) {
            string = this.parseCall(string);
        }
        EscapeLexer escapeLexer = new EscapeLexer(string);
        try {
            string = escapeLexer.parseSQLTextForStaticExecution();
        }
        catch (DataSQLException dataSQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_PARSE_SQL", string), dataSQLException, 10056);
        }
        return string;
    }

    private void buildNonCursorEntry(int n2, SQLInfoArray sQLInfoArray) {
        String string = sQLInfoArray.sqlStmtArray[n2];
        if (sQLInfoArray.sqlInputParamTypeArray[n2] != null) {
            string = this.parseSQLForStaticExecution(sQLInfoArray.sqlStmtArray[n2]);
        }
        SqlStatementType sqlStatementType = this.statementDescriptorArray_[n2].getSqlStatementType();
        if (this.dbInfo_.supportsMRI_ && this.statementDescriptorArray_[n2].hasMutiRowParameters() && (sqlStatementType == SqlStatementType.INSERT || sqlStatementType == SqlStatementType.MERGE)) {
            String string2 = " FOR :H ROWS ";
            String string3 = " NOT ATOMIC CONTINUE ON SQLEXCEPTION ";
            if (this.statementDescriptorArray_[n2].getSqlStatementType() == SqlStatementType.INSERT) {
                Matcher matcher = StaticProfileConstants.notAtomicCont.matcher(string = string + string2);
                if (!matcher.find()) {
                    string = string + string3;
                }
                ((SQLInfoArray)sQLInfoArray).multiRowIndicatorArray[n2] = true;
            } else if (this.statementDescriptorArray_[n2].getSqlStatementType() == SqlStatementType.MERGE) {
                string = BindLexer.getMergeWithMultiRowClause(string);
                ((SQLInfoArray)sQLInfoArray).multiRowIndicatorArray[n2] = true;
            }
        }
        this.bindStatementsIncludesReservedSections_[n2] = string;
        ToolsLogger.getLogger().log(Level.FINER, this.bindStatementsIncludesReservedSections_[n2]);
    }

    private void buildCursorEntry(int n2, SQLInfoArray sQLInfoArray, int[] nArray) {
        String string = sQLInfoArray.sqlStmtArray[n2];
        int n3 = this.statementDescriptorArray_[n2].getConcurrency();
        int n4 = this.statementDescriptorArray_[n2].getHoldability();
        String string2 = this.getCursorName(this.statementDescriptorArray_[n2], this.bindSectionNum_[n2]);
        int n5 = this.statementDescriptorArray_[n2].getType();
        boolean bl2 = this.statementDescriptorArray_[n2].isAllowStaticRowsetCursors();
        boolean bl3 = StatementUtilities.checkIfShouldUseRowsetCursorInBindAndStaticExecution(bl2, StatementUtilities.doesDatabaseSupportRowsetCursors(this.databaseMetaData_), true);
        String string3 = "DECLARE " + string2;
        if (n5 == 1005) {
            string3 = this.isDB2ForLUW_ || this.isDB2ForZOS_ ? string3 + " SENSITIVE STATIC SCROLL" : string3 + " SENSITIVE SCROLL";
        } else if (n5 == 1004) {
            string3 = string3 + " INSENSITIVE SCROLL";
        }
        string3 = string3 + " CURSOR";
        if (1 == n4) {
            string3 = string3 + " WITH HOLD";
        }
        if (bl3) {
            string3 = string3 + " WITH ROWSET POSITIONING ";
        }
        string3 = string3 + " FOR ";
        String string4 = string;
        if (n3 == 1008) {
            string4 = BindLexer.getQueryWithUpdateClause(string4);
        } else if (this.statementDescriptorArray_[n2].hasSingleRowResult()) {
            int n6 = sQLInfoArray.sqlResultParamTypeArray[n2].length;
            string4 = BindLexer.getSingleRowQuery(string4, this.statementDescriptorArray_[n2].getSqlStatementType(), n6, nArray);
            string3 = "";
        } else {
            string4 = BindLexer.getQueryWithReadOnlyClause(string4);
        }
        string4 = this.parseSQLForStaticExecution(string4);
        this.bindStatementsIncludesReservedSections_[n2] = string3 = string3 + string4;
        ToolsLogger.getLogger().log(Level.FINER, this.bindStatementsIncludesReservedSections_[n2]);
    }

    private SQLJColumnMetaData processHostVars(SQLInfoArray sQLInfoArray, int n2, int n3) {
        int n4;
        int n5;
        SQLJColumnMetaData sQLJColumnMetaData = null;
        int n6 = this.thisCallHasReturnValue_ ? 1 : 0;
        int n7 = 0;
        if (sQLInfoArray.sqlInputParamTypeArray[n2] != null) {
            n7 = sQLInfoArray.sqlInputParamTypeArray[n2].length - n6;
        }
        int n8 = 0;
        if (sQLInfoArray.sqlResultParamTypeArray[n2] != null) {
            n8 = sQLInfoArray.sqlResultParamTypeArray[n2].length;
        }
        int n9 = n7 + n8;
        sQLJColumnMetaData = true == sQLInfoArray.multiRowIndicatorArray[n2] ? new SQLJColumnMetaData(n9 * 2 + 1) : new SQLJColumnMetaData(n9 * 2);
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = (n5 + n3) * 2;
            sQLJColumnMetaData.sqlNames[n4] = "dynamic@" + n4;
            Short s2 = null == sQLInfoArray.sqlResultParamModeArray || null == sQLInfoArray.sqlResultParamModeArray[n2] ? null : Short.valueOf((short)sQLInfoArray.sqlResultParamModeArray[n2][n5]);
            this.setTypeInfoForDB2(sQLJColumnMetaData, n4, s2, sQLInfoArray.sqlResultParamTypeArray[n2][n5], sQLInfoArray.sqlResultParamScalesArray[n2][n5], sQLInfoArray.sqlResultParamPrecisionArray[n2][n5]);
        }
        n5 = n6;
        for (n4 = 0; n4 < n9; ++n4) {
            if (n4 >= n3 && n4 < n3 + n8) continue;
            int n10 = n4 * 2;
            sQLJColumnMetaData.sqlNames[n10] = "p" + n10;
            this.setTypeInfoForDB2(sQLJColumnMetaData, n10, (short)sQLInfoArray.sqlInputParamModeArray[n2][n5], sQLInfoArray.sqlInputParamTypeArray[n2][n5], sQLInfoArray.sqlInputParamScalesArray[n2][n5], sQLInfoArray.sqlInputParamPrecisionArray[n2][n5]);
            ++n5;
        }
        for (n5 = 0; n5 < n9; ++n5) {
            n4 = n5 * 2 + 1;
            sQLJColumnMetaData.nullables[n4] = false;
            sQLJColumnMetaData.sqlLengths[n4] = 2L;
            sQLJColumnMetaData.sqlPrecisions[n4] = 0;
            sQLJColumnMetaData.sqlScales[n4] = 0;
            sQLJColumnMetaData.sqlTypes[n4] = 501;
            sQLJColumnMetaData.sqlNames[n4] = new String("ind@" + n4);
            sQLJColumnMetaData.sqlxParmmodes[n4] = sQLJColumnMetaData.sqlxParmmodes[n4 - 1];
        }
        if (sQLInfoArray.multiRowIndicatorArray[n2]) {
            n5 = sQLJColumnMetaData.columns - 1;
            sQLJColumnMetaData.nullables[n5] = false;
            sQLJColumnMetaData.sqlLengths[n5] = 4L;
            sQLJColumnMetaData.sqlPrecisions[n5] = 0;
            sQLJColumnMetaData.sqlScales[n5] = 0;
            sQLJColumnMetaData.sqlTypes[n5] = 496;
            sQLJColumnMetaData.sqlNames[n5] = "numRows";
        }
        return sQLJColumnMetaData;
    }

    private void setTypeInfoForDB2(SQLJColumnMetaData sQLJColumnMetaData, int n2, Short s2, int n3, int n4, int n5) {
        if (null != s2) {
            sQLJColumnMetaData.sqlxParmmodes[n2] = s2;
        }
        PDQDB2Types.mapDriverTypeToDB2TypeInfo(sQLJColumnMetaData, n3, n2, this.databaseSupportsBinaryTypes_, n4, n5);
        if (sQLJColumnMetaData.sqlTypes[n2] == 484 || sQLJColumnMetaData.sqlTypes[n2] == 485) {
            sQLJColumnMetaData.sqlPrecisions[n2] = n5;
            sQLJColumnMetaData.sqlScales[n2] = n4;
            sQLJColumnMetaData.sqlLengths[n2] = 0L;
        }
        if (sQLJColumnMetaData.sqlTypes[n2] == 996 || sQLJColumnMetaData.sqlTypes[n2] == 997) {
            sQLJColumnMetaData.sqlPrecisions[n2] = 0;
            sQLJColumnMetaData.sqlScales[n2] = 0;
        }
    }

    public String parseCall(String string) {
        if (!string.substring(0, string.indexOf("{")).trim().equals("")) {
            return string;
        }
        if (!string.substring(string.lastIndexOf("}") + 1).trim().equals("")) {
            return string;
        }
        String string2 = string.substring(string.indexOf("{") + 1, string.lastIndexOf("}"));
        if ((string2 = string2.trim()).startsWith("?")) {
            this.thisCallHasReturnValue_ = true;
            string2 = string2.substring(1);
            if ((string2 = string2.trim()).startsWith("=")) {
                string2 = string2.substring(1);
                string2 = string2.trim();
            }
        }
        return string2;
    }

    protected int checkIsolationLevelOptionReturnNumericLevel(String string) {
        PossibleArgs.PredefinedOptionValues predefinedOptionValues = PossibleArgs.ISOLATION_LEVEL.getOptionValueFromString(string);
        if (null == predefinedOptionValues) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_OPT_ISO", string.toString()), null, 10687);
        }
        return this.checkIsolationLevelOptionReturnNumericLevel(predefinedOptionValues);
    }

    protected int checkIsolationLevelOptionReturnNumericLevel(PossibleArgs.PredefinedOptionValues predefinedOptionValues) {
        switch (predefinedOptionValues) {
            case CS: {
                return 2;
            }
            case NC: {
                return 0;
            }
            case RS: {
                return 3;
            }
            case RR: {
                return 4;
            }
            case UR: {
                return 1;
            }
        }
        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_OPT_ISO", predefinedOptionValues.toString()), null, 10287);
    }

    protected PossibleArgs.PredefinedOptionValues checkNumericLevelAndReturnIsolation(int n2) {
        switch (n2) {
            case 2: {
                return PossibleArgs.PredefinedOptionValues.CS;
            }
            case 0: {
                return PossibleArgs.PredefinedOptionValues.NC;
            }
            case 3: {
                return PossibleArgs.PredefinedOptionValues.RS;
            }
            case 4: {
                return PossibleArgs.PredefinedOptionValues.RR;
            }
            case 1: {
                return PossibleArgs.PredefinedOptionValues.UR;
            }
        }
        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_OPT_ISO", n2), null, 10486);
    }

    public void setCollectionNameFromPdqxmlOrImpl(String string) {
        this.collectionNameFromPdqxmlOrImpl_ = string;
    }

    public boolean isStaticReadOnlySet() {
        return this.staticReadOnlySet_;
    }

    public void setStaticReadOnly(boolean bl2) {
        this.staticReadOnlySet_ = bl2;
    }

    public boolean isDbprotocolSet() {
        return this.dbprotocolSet_;
    }

    public void setDbprotocol(boolean bl2) {
        this.dbprotocolSet_ = bl2;
    }

    public boolean isQueryBlockProtocolSet() {
        return this.queryBlockProtocolSet_;
    }

    public void setQueryBlockProtocolSet(boolean bl2) {
        this.queryBlockProtocolSet_ = bl2;
    }

    public boolean isBindObjectExistenceSet() {
        return this.bindObjectExistenceSet_;
    }

    public void setBindObjectExistence(boolean bl2) {
        this.bindObjectExistenceSet_ = bl2;
    }

    public byte[] getConsistencyToken() {
        return this.consistencyToken_;
    }

    public String getRootPkgName() {
        return this.rootPkgName_;
    }

    public void setRootPkgName(String string) {
        this.rootPkgName_ = string;
    }

    public StatementDescriptor[] getStatementDescriptorArray() {
        return this.statementDescriptorArray_;
    }

    public void setStatementDescriptorArray_(StatementDescriptorImpl[] statementDescriptorImplArray) {
        this.statementDescriptorArray_ = statementDescriptorImplArray;
    }

    protected String[] getBindStatementsIncludesReservedSections() {
        return this.bindStatementsIncludesReservedSections_;
    }

    public int[] getBindSectionNum() {
        return this.bindSectionNum_;
    }

    public SQLJColumnMetaData[] getHostVariableInfo() {
        return this.hostVariableInfo_;
    }

    public StaticProfileConstants.DBInfo getDBInfo() {
        return this.dbInfo_;
    }

    public boolean databaseSupportsBinaryTypes() {
        return this.databaseSupportsBinaryTypes_;
    }

    public boolean supportsCommentOnPackage() {
        return this.supportsCommentOnPackage_;
    }

    public String getEncodingForDBRM() {
        return this.encodingForDBRM_;
    }

    public String getPackageVersion() {
        return this.packageVersion_;
    }

    public void setGrantOptionsList(String string) {
        this.grantOption_ = string;
    }

    public String getGrantOptionsList() {
        return this.grantOption_;
    }

    public void setOriginalSQLStmtArray_(String[] stringArray) {
        this.originalSQLStmtArray_ = stringArray;
    }

    public String[] getOriginalSQLStmtArray() {
        return this.originalSQLStmtArray_;
    }

    public void setSqlIdArray(String[] stringArray) {
        this.sqlIdArray_ = stringArray;
    }

    public String[] getSqlIdArray() {
        return this.sqlIdArray_;
    }

    private void setInformationFromXML(PDQXmlStatementSet pDQXmlStatementSet) {
        PDQXmlPackage pDQXmlPackage = pDQXmlStatementSet.getPackage();
        this.numInputStatements_ = pDQXmlStatementSet.getStatements().size();
        this.statementDescriptorArray_ = pDQXmlStatementSet.getStatementDescriptorsForBinder().toArray(new StatementDescriptorImpl[0]);
        if (null != this.statementDescriptorArray_) {
            this.numBindableFalseStatements_ = this.numInputStatements_ - this.statementDescriptorArray_.length;
        }
        Arrays.sort(this.statementDescriptorArray_, new Comparator<StatementDescriptorImpl>(){

            @Override
            public int compare(StatementDescriptorImpl statementDescriptorImpl, StatementDescriptorImpl statementDescriptorImpl2) {
                return statementDescriptorImpl.getSection() - statementDescriptorImpl2.getSection();
            }
        });
        this.packageVersion_ = pDQXmlPackage.getPackageVersion();
        this.rootPkgName_ = pDQXmlPackage.getPackageName();
        this.collectionNameFromPdqxmlOrImpl_ = pDQXmlPackage.getCollectionName();
        if (null != this.statementDescriptorArray_ && 0 < this.statementDescriptorArray_.length && null != this.statementDescriptorArray_[0]) {
            this.consistencyToken_ = this.statementDescriptorArray_[0].getConsistencyToken();
            this.sqlIdArray_ = new String[this.statementDescriptorArray_.length];
            for (int i10 = 0; i10 < this.statementDescriptorArray_.length; ++i10) {
                this.sqlIdArray_[i10] = this.statementDescriptorArray_[i10].getId();
            }
        }
    }

    private void checkVersion() {
        if (this.isDB2ForLUW_ || this.isDB2ForZOS_) {
            if (this.collectionNameFromPdqxmlOrImpl_.length() > this.collectionNameMaxLength_) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_COLLECTION_NAME_TOO_LARGE", this.collectionNameFromPdqxmlOrImpl_), null, 10487);
            }
            int n2 = this.pkgNameMaxLength_ - 1;
            if (this.rootPkgName_.length() > n2) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_ROOTPKG_NAME_TOO_LARGE", this.rootPkgName_), null, 10488);
            }
        }
    }

    public void setInformationFromImplAndCheckVersion(String string, String string2) throws IllegalAccessException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, FileLoader.binderClassLoader.get() != null ? FileLoader.binderClassLoader.get() : BindMetaDataInfo.getClassloader(BindMetaDataInfo.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_LD_IMPL", string, string.substring(0, string.length() - "Impl".length())), classNotFoundException, 10388);
        }
        String string3 = null;
        ArrayList<StatementDescriptorImpl> arrayList = new ArrayList<StatementDescriptorImpl>();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (Field field : fieldArray) {
            if (StatementDescriptor.class.isAssignableFrom(field.getType())) {
                StatementDescriptorImpl statementDescriptorImpl = (StatementDescriptorImpl)field.get(clazz);
                arrayList.add(statementDescriptorImpl);
                continue;
            }
            if ("generatorVersion".equals(field.getName())) {
                string3 = (String)field.get(String.class);
                continue;
            }
            if ("packageVersion".equals(field.getName())) {
                this.packageVersion_ = (String)field.get(String.class);
                continue;
            }
            if ("identifier".equals(field.getName())) {
                this.rootPkgName_ = (String)field.get(String.class);
                continue;
            }
            if (!"collection".equals(field.getName())) continue;
            this.collectionNameFromPdqxmlOrImpl_ = (String)field.get(String.class);
        }
        this.numInputStatements_ = arrayList.size();
        if (null == string3) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_BIND_FAIL_FIELD_NOT_FOUND", "generatorVersion", clazz.getCanonicalName()), null, 10326);
        }
        Object object = new DataVersion();
        ((DataVersion)object).checkCompatibleGeneratorVersion(string2, string3);
        this.statementDescriptorArray_ = arrayList.toArray(new StatementDescriptorImpl[0]);
        Arrays.sort(this.statementDescriptorArray_, new Comparator<StatementDescriptorImpl>(){

            @Override
            public int compare(StatementDescriptorImpl statementDescriptorImpl, StatementDescriptorImpl statementDescriptorImpl2) {
                return statementDescriptorImpl.getSection() - statementDescriptorImpl2.getSection();
            }
        });
        if (0 < this.statementDescriptorArray_.length && null != this.statementDescriptorArray_[0]) {
            object = this.statementDescriptorArray_[0];
            this.consistencyToken_ = ((StatementDescriptorImpl)object).getConsistencyToken();
            this.sqlIdArray_ = new String[this.statementDescriptorArray_.length];
            for (int i10 = 0; i10 < this.statementDescriptorArray_.length; ++i10) {
                this.sqlIdArray_[i10] = this.statementDescriptorArray_[i10].getMethodNameAndParameterTypesString();
            }
        }
    }

    protected DB2Connection getDB2ConnectionForBindAndUnsetAutoCommit(ArtifactOptionsSet artifactOptionsSet) {
        DB2Connection dB2Connection = this.connectionFromODSTooling_;
        try {
            if (null != this.connectionFromODSTooling_) {
                if (this.connectionFromODSTooling_.getAutoCommit()) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_CONNECTION_AUTOCOMMIT_WRONG", this.connectionFromODSTooling_.getAutoCommit(), false), null, 10839);
                }
                dB2Connection = this.connectionFromODSTooling_;
            } else {
                DB2Driver dB2Driver = new DB2Driver();
                ClassLoader classLoader = null;
                classLoader = BindMetaDataInfo.getObjectClassLoaderNonPriv(dB2Driver);
                Configuration.setConfigurationCapabilities(classLoader);
                String string = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.URL);
                String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.USERNAME);
                String string3 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.PASSWORD);
                if (!(null != string2 && 1 <= string2.length() && null != string3 && 1 <= string3.length() && null != string && 1 <= string.length() || string != null && (string.contains("kerberosServerPrincipal") || string.contains("securityMechanism")))) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_DATABASE_CONNECTION_PROP", new Object[0]), null, 10336);
                }
                Properties properties = new Properties();
                if (string2 != null && string2.length() > 0) {
                    properties.put("user", string2);
                }
                if (string3 != null && string3.length() > 0) {
                    properties.put("password", string3);
                }
                if (string != null && !string.contains("retrieveMessagesFromServerOnGetMessage")) {
                    properties.put("retrieveMessagesFromServerOnGetMessage", "true");
                }
                if (string != null && !string.contains("monitorEnabled")) {
                    properties.put("monitorEnabled", "2");
                }
                ToolsLogger.getLogger().log(Level.FINEST, "connecting to database " + string);
                dB2Connection = BindMetaDataInfo.getConnectionWithoutProxy((DB2Connection)dB2Driver.connect(string, properties));
                if (null != dB2Connection) {
                    dB2Connection.setAutoCommit(false);
                }
            }
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_BIND_NOCONN", new Object[0]), sQLException, 10338);
        }
        if (null == dB2Connection) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_BIND_NOCONN", new Object[0]), null, 10390);
        }
        return dB2Connection;
    }

    protected static DB2Connection getConnectionWithoutProxy(DB2Connection dB2Connection) {
        DB2Connection dB2Connection2;
        if (null == dB2Connection) {
            dB2Connection2 = dB2Connection;
        } else if (dB2Connection instanceof Proxy) {
            Connection connection = null;
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(dB2Connection);
            if (invocationHandler instanceof ConnectionExecutionHandler) {
                connection = ((DB2ConnectionExecutionHandler)((Object)invocationHandler)).getPhysicalConnection();
            } else if (invocationHandler instanceof ProxiedDB2ConnectionInvocationHandler && (connection = ((ProxiedDB2ConnectionInvocationHandler)invocationHandler).getWrappedConnection()) instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(connection)) instanceof DB2ConnectionExecutionHandler) {
                connection = ((DB2ConnectionExecutionHandler)((Object)invocationHandler)).getPhysicalConnection();
            }
            dB2Connection2 = null != connection ? (DB2Connection)connection : dB2Connection;
        } else {
            dB2Connection2 = dB2Connection;
        }
        return dB2Connection2;
    }

    protected void cleanupDB2Connection(DB2Connection dB2Connection) {
        try {
            if (null != dB2Connection && null == this.connectionFromODSTooling_ && !dB2Connection.isClosed()) {
                dB2Connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void setAutoCommitIfUserAllowsCommits(DB2Connection dB2Connection, boolean bl2) throws SQLException {
        if (this.binderShouldCommitOrRollback_) {
            dB2Connection.setAutoCommit(bl2);
        }
    }

    protected void commitIfUserAllowsCommits(DB2Connection dB2Connection) throws SQLException {
        if (this.binderShouldCommitOrRollback_) {
            dB2Connection.commit();
        }
    }

    protected void rollbackIfUserAllowsRollbacks(DB2Connection dB2Connection) throws SQLException {
        if (this.binderShouldCommitOrRollback_ && null != dB2Connection && !dB2Connection.isClosed()) {
            dB2Connection.rollback();
        }
    }

    protected void setBindStatementsIncludesReservedSections(String[] stringArray) {
        this.bindStatementsIncludesReservedSections_ = stringArray;
    }

    public void setPkgVersion(String string) {
        this.packageVersion_ = string;
    }

    public void setConsistencyToken(byte[] byArray) {
        this.consistencyToken_ = byArray;
    }

    public void setSRInfoAboutStatementSet(SRInfoAboutStatementSet sRInfoAboutStatementSet) {
        this.srInfoAboutStatementSet_ = sRInfoAboutStatementSet;
    }

    public SRInfoAboutStatementSet getSRInfoAboutStatementSet() {
        return this.srInfoAboutStatementSet_;
    }

    private static String getWarningMessagesForConfigureWarnings(List<String> list) {
        if (null != list && 0 < list.size()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : list) {
                String string2;
                PossibleArgs.PredefinedOptionValues predefinedOptionValues = PossibleArgs.CONFIGURE_WARNING.getOptionValueFromString(string);
                if (null == predefinedOptionValues) {
                    string2 = Messages.getText("WARN_CONFIGUREWARNING_VALUENOTRECOGNIZED", string, PossibleArgs.CONFIGURE_WARNING.externalOptionName());
                } else {
                    switch (predefinedOptionValues) {
                        case INCREMENTAL_SPECIAL_REGISTER_VALUES_PRESENT: {
                            string2 = Messages.getText("WARN_CONFIGUREWARNING_INCREMENTALSPECIALREGISTERVALUESPRESENT", predefinedOptionValues.getOptionValue(), PossibleArgs.CONFIGURE_WARNING.externalOptionName());
                            break;
                        }
                        case SPECIAL_REGISTER_VALUES_SET_MISSING: {
                            string2 = Messages.getText("WARN_CONFIGUREWARNING_SPECIALREGISTERVALUESSETMISSING", predefinedOptionValues.getOptionValue(), PossibleArgs.CONFIGURE_WARNING.externalOptionName());
                            break;
                        }
                        case SPECIAL_REGISTER_GROUPING_INCONSISTENT: {
                            string2 = Messages.getText("WARN_CONFIGUREWARNING_SPECIALREGISTERGROUPINGINCONSISTENT", predefinedOptionValues.getOptionValue(), PossibleArgs.CONFIGURE_WARNING.externalOptionName());
                            break;
                        }
                        case MULTIPLE_SPECIAL_REGISTER_VALUES_SETS: {
                            string2 = Messages.getText("WARN_CONFIGUREWARNING_MULTIPLESPECIALREGISTERVALUESSETS", predefinedOptionValues.getOptionValue(), PossibleArgs.CONFIGURE_WARNING.externalOptionName());
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11076);
                        }
                    }
                }
                if (0 < stringBuilder.length()) {
                    stringBuilder.append(XmlTags.CRLF).append(XmlTags.CRLF);
                }
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public void setSectionNumber(int[] nArray) {
        this.bindSectionNum_ = nArray;
    }

    public void setHostVariableInfo(SQLJColumnMetaData[] sQLJColumnMetaDataArray) {
        this.hostVariableInfo_ = sQLJColumnMetaDataArray;
    }

    public void setIsDDLPackage(boolean bl2) {
        this.isDDLPackage_ = bl2;
    }

    public boolean getIsDDLPackage() {
        return this.isDDLPackage_;
    }

    protected void validateCollectionAndPackageNameLength(String string, String string2) {
        if (this.isDB2ForLUW_ || this.isDB2ForZOS_) {
            if (string.length() > this.getCollectionNameMaxLength()) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_COLLECTION_NAME_TOO_LARGE", string), null, 10497);
            }
            int n2 = this.getPkgNameMaxLength() - 1;
            if (string2.length() > n2) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_ROOTPKG_NAME_TOO_LARGE", string2), null, 10498);
            }
        }
    }

    public String getOriginalSQLText(int n2) {
        String string = null;
        if (this.getOriginalSQLStmtArray() != null && this.getOriginalSQLStmtArray().length > 0) {
            if (n2 <= this.getOriginalSQLStmtArray().length) {
                string = this.getOriginalSQLStmtArray()[n2 - 1];
            }
        } else if (this.getStatementDescriptorArray() != null && this.getStatementDescriptorArray().length > 0 && n2 <= this.getStatementDescriptorArray().length) {
            string = this.getStatementDescriptorArray()[n2 - 1].getProcessedSql();
        }
        return string;
    }

    public String getSQLIDInformation(int n2) {
        String string = null;
        if (this.getSqlIdArray() != null && this.getSqlIdArray().length > 0 && n2 <= this.getSqlIdArray().length) {
            string = this.getSqlIdArray()[n2 - 1];
        }
        return string;
    }

    public boolean isForceSingleBindIsolation() {
        return this.forceSingleBindIsolation_;
    }

    public void setForceSingleBindIsolation(boolean bl2) {
        this.forceSingleBindIsolation_ = bl2;
    }

    public void setXmlFileName(String string) {
        this.xmlFileName_ = string;
    }

    public String getXmlFileName() {
        return this.xmlFileName_;
    }

    public void setIsolationFromPackage(String string) {
        this.isolationFromPackage_ = string;
    }

    public String getIsolationFromPackage() {
        return this.isolationFromPackage_;
    }

    public Timestamp getPkgCreationTime() {
        return this.pkgCreationTime_;
    }

    public void setPkgCreationTime(Timestamp timestamp) {
        this.pkgCreationTime_ = timestamp;
    }

    public List<String> getSkippedPackages() {
        return this.skippedPackages_;
    }

    public void addSkippedPackages(String string) {
        this.skippedPackages_.add(string);
    }

    public String getCollectionNameToUse() {
        if (null != this.collectionNameFromBindOptionsString_) {
            return this.collectionNameFromBindOptionsString_;
        }
        return this.collectionNameFromPdqxmlOrImpl_;
    }

    public void setCollectionNameFromBindOptionsString(String string) {
        this.collectionNameFromBindOptionsString_ = string;
    }

    public String getQualifierFromBindOptionsString() {
        return this.qualifierFromBindOptionsString_;
    }

    public void setQualifierFromBindOptionsString(String string) {
        this.qualifierFromBindOptionsString_ = string;
    }

    public boolean isIsolationSet() {
        return this.isolationSet_;
    }

    public void setIsolation(boolean bl2) {
        this.isolationSet_ = bl2;
    }

    public boolean isVerifyIfPackageExists() {
        return this.verifyIfPackageExists_;
    }

    public void setVerifyIfPackageExists(boolean bl2) {
        this.verifyIfPackageExists_ = bl2;
    }

    public int getCountForPackagesThatExist() {
        return this.countForPackagesThatExist_;
    }

    public void incrementCountForPackagesThatExist() {
        ++this.countForPackagesThatExist_;
    }

    public int getCountForPackagesThatDoNotExist() {
        return this.countForPackagesThatDoNotExist_;
    }

    public void incrementCountForPackagesThatDoNotExist() {
        ++this.countForPackagesThatDoNotExist_;
    }

    public void setUtilityResultType(PureQueryUtility.UtilityResultType utilityResultType, String string) {
        this.utilityResult_.downgradeUtilityResultType(utilityResultType, string);
    }

    public PureQueryUtility.UtilityResult getUtilityResult() {
        return this.utilityResult_;
    }

    public String getBindOptionsStringToUse(ArtifactOptionsSet artifactOptionsSet) {
        String string = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.BIND_OPTIONS);
        return null != string ? string : this.bindOptionsStringFromPureQueryXml_;
    }

    protected void setBindOptionsStringFromPureQueryXml(String string) {
        this.bindOptionsStringFromPureQueryXml_ = string;
    }

    public int getNumBindableFalseStatements() {
        return this.numBindableFalseStatements_;
    }

    public void incrementNumBindableFalseStatements() {
        ++this.numBindableFalseStatements_;
    }

    public int getNumBindableTrueStatementsNotBound() {
        return null == this.bindableTrueStatementsNotBound_ ? 0 : this.bindableTrueStatementsNotBound_.size();
    }

    public List<String> getBindableTrueStatementsNotBound() {
        return this.bindableTrueStatementsNotBound_;
    }

    public void addBindableTrueStatementsNotBound(String string) {
        if (null == this.bindableTrueStatementsNotBound_) {
            this.bindableTrueStatementsNotBound_ = new ArrayList<String>();
        }
        this.bindableTrueStatementsNotBound_.add(string);
        this.setUtilityResultType(PureQueryUtility.UtilityResultType.COMPLETED_WITH_WARNINGS, Messages.getText("WARN_ISBINDABLE_TRUE_NOT_BOUND", "isBindable", "true"));
    }

    public int getNumInputStatements() {
        return this.numInputStatements_;
    }

    public void setNumInputStatements(int n2) {
        this.numInputStatements_ = n2;
    }

    public void incrementNumDDLStatements() {
        ++this.numDDLStatements_;
    }

    public int getNumDDLStatements() {
        return this.numDDLStatements_;
    }

    public void setNumDDLStatements(int n2) {
        this.numDDLStatements_ = n2;
    }

    public void setNumberOfBindableTrueStatementsToBind(int n2) {
        this.numberOfBindableTrueStatementsToBind_ = n2;
    }

    public int getNumberOfBindableTrueStatementsToBind() {
        return this.numberOfBindableTrueStatementsToBind_;
    }

    public void addBindableFalseStatementSet(String string) {
        this.bindableFalseStatementSetsList_.add(string);
    }

    public List<String> getBindableFalseStatementSetsList() {
        return this.bindableFalseStatementSetsList_;
    }

    public void addBindableStatementSetWithNoBindableStatements(String string) {
        this.bindableStatementSetsWithNoBindableStatementsList_.add(string);
    }

    public List<String> getBindableStatementSetsWithNoBindableStatementsList() {
        return this.bindableStatementSetsWithNoBindableStatementsList_;
    }

    public void setNumStatementSets(int n2) {
        this.numStatementSets_ = n2;
    }

    public int getNumStatementSets() {
        return this.numStatementSets_;
    }

    public void addBindableStatementSetWithBindableStatements(String string) {
        this.bindableStatementSetsWithBindableStatementsList_.add(string);
    }

    public List<String> getBindableStatementSetsWithBindableStatementsList() {
        return this.bindableStatementSetsWithBindableStatementsList_;
    }

    public void foundRequestedBasePackageName(boolean bl2) {
        this.foundRequestedBasePackageName_ = bl2;
    }

    public boolean isRequestedBasePackageNameFound() {
        return this.foundRequestedBasePackageName_;
    }

    public void setIsImpl(boolean bl2) {
        this.isImpl_ = bl2;
    }

    public boolean isImpl() {
        return this.isImpl_;
    }

    public boolean isWritableFile(String string) {
        File file = new File(string);
        boolean bl2 = file.exists();
        return bl2 && (bl2 = Boolean.valueOf(file.canWrite()).booleanValue());
    }

    public boolean isFileInputNotResource() {
        return this.isFileInputNotResource_;
    }

    public void setFileInputNotResource(boolean bl2) {
        this.isFileInputNotResource_ = bl2;
    }

    public ArrayList<Element> getStmtElementList() {
        return this.stmtElementList_;
    }

    public void setStmtElementList(ArrayList<Element> arrayList) {
        this.stmtElementList_ = arrayList;
    }

    public boolean isModifiedDom() {
        return this.modifiedDom_;
    }

    public void setModifiedDom(boolean bl2) {
        this.modifiedDom_ = bl2;
    }

    public PossibleArgs.PredefinedOptionValues getInvalidSqlAction() {
        return this.invalidSqlAction_;
    }

    public void setInvalidSqlAction(PossibleArgs.PredefinedOptionValues predefinedOptionValues) {
        this.invalidSqlAction_ = predefinedOptionValues;
    }

    public boolean isInvalidSqlAction() {
        return this.invalidSqlAction_.equals((Object)PossibleArgs.PredefinedOptionValues.MARK_INVALID) || this.invalidSqlAction_.equals((Object)PossibleArgs.PredefinedOptionValues.REMOVE);
    }

    private static ClassLoader getClassloader(Class<?> clazz) {
        return clazz.getClassLoader();
    }

    public boolean isDetectSingleton() {
        return this.detectSingleton_;
    }

    public void setDetectSingleton(boolean bl2) {
        this.detectSingleton_ = bl2;
    }

    private static ClassLoader getObjectClassLoaderNonPriv(Object object) {
        return object.getClass().getClassLoader();
    }

    class SQLInfoArray {
        private String[] sqlStmtArray;
        private int[][] sqlInputParamTypeArray;
        private int[][] sqlInputParamPrecisionArray;
        private int[][] sqlInputParamScalesArray;
        private int[][] sqlInputParamModeArray;
        private int[][] sqlResultParamTypeArray;
        private int[][] sqlResultParamPrecisionArray;
        private int[][] sqlResultParamScalesArray;
        private int[][] sqlResultParamModeArray;
        private boolean[] multiRowIndicatorArray;

        SQLInfoArray(int n2) {
            this.sqlInputParamTypeArray = new int[n2][];
            this.sqlInputParamPrecisionArray = new int[n2][];
            this.sqlInputParamScalesArray = new int[n2][];
            this.sqlInputParamModeArray = new int[n2][];
            this.sqlStmtArray = new String[n2];
            this.sqlResultParamTypeArray = new int[n2][];
            this.sqlResultParamPrecisionArray = new int[n2][];
            this.sqlResultParamScalesArray = new int[n2][];
            this.sqlResultParamModeArray = new int[n2][];
            this.multiRowIndicatorArray = new boolean[n2];
            for (int i10 = 0; i10 < n2; ++i10) {
                this.multiRowIndicatorArray[i10] = false;
            }
        }
    }
}

