/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import morfologik.stemming.BufferUtils;
import morfologik.stemming.Dictionary;
import morfologik.stemming.ISequenceEncoder;
import morfologik.stemming.WordData;

public final class DictionaryIterator
implements Iterator<WordData> {
    private final CharsetDecoder decoder;
    private final Iterator<ByteBuffer> entriesIter;
    private final WordData entry;
    private final byte separator;
    private final boolean decodeStems;
    private ByteBuffer inflectedBuffer = ByteBuffer.allocate(0);
    private CharBuffer inflectedCharBuffer = CharBuffer.allocate(0);
    private ByteBuffer temp = ByteBuffer.allocate(0);
    private final ISequenceEncoder sequenceEncoder;

    public DictionaryIterator(Dictionary dictionary, CharsetDecoder decoder, boolean decodeStems) {
        this.entriesIter = dictionary.fsa.iterator();
        this.separator = dictionary.metadata.getSeparator();
        this.sequenceEncoder = dictionary.metadata.getSequenceEncoderType().get();
        this.decoder = decoder;
        this.entry = new WordData(decoder);
        this.decodeStems = decodeStems;
    }

    @Override
    public boolean hasNext() {
        return this.entriesIter.hasNext();
    }

    @Override
    public WordData next() {
        int sepPos;
        ByteBuffer entryBuffer = this.entriesIter.next();
        byte[] ba = entryBuffer.array();
        int bbSize = entryBuffer.remaining();
        for (sepPos = 0; sepPos < bbSize && ba[sepPos] != this.separator; ++sepPos) {
        }
        if (sepPos == bbSize) {
            throw new RuntimeException("Invalid dictionary entry format (missing separator).");
        }
        this.inflectedBuffer = BufferUtils.clearAndEnsureCapacity(this.inflectedBuffer, sepPos);
        this.inflectedBuffer.put(ba, 0, sepPos);
        this.inflectedBuffer.flip();
        this.inflectedCharBuffer = BufferUtils.bytesToChars(this.decoder, this.inflectedBuffer, this.inflectedCharBuffer);
        this.entry.update(this.inflectedBuffer, this.inflectedCharBuffer);
        this.temp = BufferUtils.clearAndEnsureCapacity(this.temp, bbSize - sepPos);
        this.temp.put(ba, ++sepPos, bbSize - sepPos);
        this.temp.flip();
        ba = this.temp.array();
        bbSize = this.temp.remaining();
        assert (this.sequenceEncoder.prefixBytes() <= bbSize) : this.sequenceEncoder.getClass() + " >? " + bbSize;
        for (sepPos = this.sequenceEncoder.prefixBytes(); sepPos < bbSize && ba[sepPos] != this.separator; ++sepPos) {
        }
        if (this.decodeStems) {
            this.entry.stemBuffer = this.sequenceEncoder.decode(this.entry.stemBuffer, this.inflectedBuffer, ByteBuffer.wrap(ba, 0, sepPos));
        } else {
            this.entry.stemBuffer = BufferUtils.clearAndEnsureCapacity(this.entry.stemBuffer, sepPos);
            this.entry.stemBuffer.put(ba, 0, sepPos);
            this.entry.stemBuffer.flip();
        }
        if (sepPos + 1 <= bbSize) {
            ++sepPos;
        }
        this.entry.tagBuffer = BufferUtils.clearAndEnsureCapacity(this.entry.tagBuffer, bbSize - sepPos);
        this.entry.tagBuffer.put(ba, sepPos, bbSize - sepPos);
        this.entry.tagBuffer.flip();
        return this.entry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

