/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.util.EventDispatcher;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchesTreeModel;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H\u0004J\b\u0010\u0018\u001a\u00020\u0015H\u0004J\b\u0010\u0019\u001a\u00020\u0015H\u0004J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeModelBase;", "Lgit4idea/ui/branch/dashboard/BranchesTreeModel;", "<init>", "()V", "_root", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor$Root;", "root", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "getRoot", "()Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/ui/branch/dashboard/BranchesTreeModel$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "loadingCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "isLoading", "", "()Z", "setTree", "", "nodes", "", "startLoading", "finishLoading", "addListener", "listener", "removeListener", "onTreeDataChange", "intellij.vcs.git"})
@ApiStatus.Internal
public abstract class BranchesTreeModelBase
implements BranchesTreeModel {
    @NotNull
    private final BranchNodeDescriptor.Root _root = new BranchNodeDescriptor.Root();
    @NotNull
    private final BranchNodeDescriptor root = this._root;
    @NotNull
    private final EventDispatcher<BranchesTreeModel.Listener> listeners;
    @NotNull
    private final AtomicInteger loadingCounter;

    public BranchesTreeModelBase() {
        EventDispatcher eventDispatcher = EventDispatcher.create(BranchesTreeModel.Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.listeners = eventDispatcher;
        this.loadingCounter = new AtomicInteger();
    }

    @Override
    @NotNull
    public final BranchNodeDescriptor getRoot() {
        return this.root;
    }

    @Override
    public final boolean isLoading() {
        return this.loadingCounter.get() > 0;
    }

    protected final void setTree(@NotNull List<? extends BranchNodeDescriptor> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this._root.setChildren(nodes);
        ((BranchesTreeModel.Listener)this.listeners.getMulticaster()).onTreeChange();
    }

    protected final void startLoading() {
        this.loadingCounter.incrementAndGet();
        ((BranchesTreeModel.Listener)this.listeners.getMulticaster()).onLoadingStateChange();
    }

    protected final void finishLoading() {
        this.loadingCounter.decrementAndGet();
        ((BranchesTreeModel.Listener)this.listeners.getMulticaster()).onLoadingStateChange();
    }

    @Override
    public final void addListener(@NotNull BranchesTreeModel.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.addListener((EventListener)listener2);
    }

    @Override
    public final void removeListener(@NotNull BranchesTreeModel.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.removeListener((EventListener)listener2);
    }

    public final void onTreeDataChange() {
        ((BranchesTreeModel.Listener)this.listeners.getMulticaster()).onTreeDataChange();
    }
}

