/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Node;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;

public final class IndexMark {
    public static final String getIndexValue(Node node) {
        if (!node.getNodeName().endsWith("start")) {
            return Misc.getAttribute(node, "text:string-value");
        }
        return IndexMark.collectMark(node);
    }

    public static final String getKey1(Node node) {
        return Misc.getAttribute(node, "text:key1");
    }

    public static final String getKey2(Node node) {
        return Misc.getAttribute(node, "text:key2");
    }

    private static final Node getRightNode(Node node) {
        do {
            Node nextNode;
            if ((nextNode = node.getNextSibling()) == null) continue;
            return nextNode;
        } while ((node = node.getParentNode()) != null);
        return null;
    }

    private static final String collectMark(Node node) {
        StringBuilder buf = new StringBuilder();
        String sId = Misc.getAttribute(node, "text:id");
        node = IndexMark.getRightNode(node);
        while (node != null) {
            if (node.getNodeType() == 3) {
                buf.append(node.getNodeValue());
                node = IndexMark.getRightNode(node);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            boolean bReady = false;
            if (sId.equals(Misc.getAttribute(node, "text:id"))) {
                node = null;
                bReady = true;
            } else if (OfficeReader.isTextElement(node) && !OfficeReader.isNoteElement(node) && node.hasChildNodes()) {
                node = node.getFirstChild();
                bReady = true;
            }
            if (bReady) continue;
            node = IndexMark.getRightNode(node);
        }
        return buf.toString();
    }
}

