/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.protocol;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.protocol.AuthnContextComparisonType;
import org.keycloak.dom.saml.v2.protocol.RequestedAuthnContextType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.protocol.AbstractStaxSamlProtocolParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;

public class SAMLRequestedAuthnContextParser
extends AbstractStaxSamlProtocolParser<RequestedAuthnContextType> {
    private static final SAMLRequestedAuthnContextParser INSTANCE = new SAMLRequestedAuthnContextParser();

    private SAMLRequestedAuthnContextParser() {
        super(SAMLProtocolQNames.REQUESTED_AUTHN_CONTEXT);
    }

    public static SAMLRequestedAuthnContextParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected RequestedAuthnContextType instantiateElement(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        RequestedAuthnContextType context = new RequestedAuthnContextType();
        Attribute comparison = startElement.getAttributeByName(SAMLProtocolQNames.ATTR_COMPARISON.getQName());
        if (comparison != null) {
            context.setComparison(AuthnContextComparisonType.fromValue((String)comparison.getValue()));
        }
        return context;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, RequestedAuthnContextType target, SAMLProtocolQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case AUTHN_CONTEXT_CLASS_REF: {
                StaxParserUtil.advance(xmlEventReader);
                String value = StaxParserUtil.getElementText(xmlEventReader);
                target.addAuthnContextClassRef(value);
                break;
            }
            case AUTHN_CONTEXT_DECL_REF: {
                StaxParserUtil.advance(xmlEventReader);
                String value = StaxParserUtil.getElementText(xmlEventReader);
                target.addAuthnContextDeclRef(value);
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

