var charByEntityName = {
  'quot': '"',
  'amp': '&',
  'apos': '\'',
  'lt': '<',
  'gt': '>',
  'nbsp': ' ',
  'iexcl': '¡',
  'cent': '¢',
  'pound': '£',
  'curren': '¤',
  'yen': '¥',
  'brvbar': '¦',
  'sect': '§',
  'uml': '¨',
  'copy': '©',
  'ordf': 'ª',
  'laquo': '«',
  'not': '¬',
  'shy': '­',
  'reg': '®',
  'macr': '¯', // http://www.w3.org/TR/html4/sgml/entities.html
  'strns': '¯', // http://www.w3.org/TR/html5/named-character-references.html
  'deg': '°',
  'plusmn': '±', // http://www.w3.org/TR/html4/sgml/entities.html
  'pm': '±', // http://www.w3.org/TR/html5/named-character-references.html
  'sup2': '²',
  'sup3': '³',
  'acute': '´',
  'micro': 'µ',
  'para': '¶',
  'middot': '·',
  'cedil': '¸',
  'sup1': '¹',
  'ordm': 'º',
  'raquo': '»',
  'frac14': '¼',
  'half': '½', // http://www.w3.org/TR/html4/sgml/entities.html
  'frac12': '½', // http://www.w3.org/TR/html5/named-character-references.html
  'frac34': '¾',
  'iquest': '¿',
  'Agrave': 'À',
  'Aacute': 'Á',
  'Acirc': 'Â',
  'Atilde': 'Ã',
  'Auml': 'Ä',
  'Aring': 'Å', // http://www.w3.org/TR/html4/sgml/entities.html
  'angst': 'Å', // http://www.w3.org/TR/html5/named-character-references.html
  'AElig': 'Æ',
  'Ccedil': 'Ç',
  'Egrave': 'È',
  'Eacute': 'É',
  'Ecirc': 'Ê',
  'Euml': 'Ë',
  'Igrave': 'Ì',
  'Iacute': 'Í',
  'Icirc': 'Î',
  'Iuml': 'Ï',
  'ETH': 'Ð',
  'Ntilde': 'Ñ',
  'Ograve': 'Ò',
  'Oacute': 'Ó',
  'Ocirc': 'Ô',
  'Otilde': 'Õ',
  'Ouml': 'Ö',
  'times': '×',
  'Oslash': 'Ø',
  'Ugrave': 'Ù',
  'Uacute': 'Ú',
  'Ucirc': 'Û',
  'Uuml': 'Ü',
  'Yacute': 'Ý',
  'THORN': 'Þ',
  'szlig': 'ß',
  'agrave': 'à',
  'aacute': 'á',
  'acirc': 'â',
  'atilde': 'ã',
  'auml': 'ä',
  'aring': 'å',
  'aelig': 'æ',
  'ccedil': 'ç',
  'egrave': 'è',
  'eacute': 'é',
  'ecirc': 'ê',
  'euml': 'ë',
  'igrave': 'ì',
  'iacute': 'í',
  'icirc': 'î',
  'iuml': 'ï',
  'eth': 'ð',
  'ntilde': 'ñ',
  'ograve': 'ò',
  'oacute': 'ó',
  'ocirc': 'ô',
  'otilde': 'õ',
  'ouml': 'ö',
  'divide': '÷',
  'oslash': 'ø',
  'ugrave': 'ù',
  'uacute': 'ú',
  'ucirc': 'û',
  'uuml': 'ü',
  'yacute': 'ý',
  'thorn': 'þ',
  'yuml': 'ÿ',
  'Amacr': 'Ā',
  'amacr': 'ā',
  'Abreve': 'Ă',
  'abreve': 'ă',
  'Aogon': 'Ą',
  'aogon': 'ą',
  'Cacute': 'Ć',
  'cacute': 'ć',
  'Ccirc': 'Ĉ',
  'ccirc': 'ĉ',
  'Cdot': 'Ċ',
  'cdot': 'ċ',
  'Ccaron': 'Č',
  'ccaron': 'č',
  'Dcaron': 'Ď',
  'dcaron': 'ď',
  'Dstrok': 'Đ',
  'dstrok': 'đ',
  'Emacr': 'Ē',
  'emacr': 'ē',
  'Edot': 'Ė',
  'edot': 'ė',
  'Eogon': 'Ę',
  'eogon': 'ę',
  'Ecaron': 'Ě',
  'ecaron': 'ě',
  'Gcirc': 'Ĝ',
  'gcirc': 'ĝ',
  'Gbreve': 'Ğ',
  'gbreve': 'ğ',
  'Gdot': 'Ġ',
  'gdot': 'ġ',
  'Gcedil': 'Ģ',
  'Hcirc': 'Ĥ',
  'hcirc': 'ĥ',
  'Hstrok': 'Ħ',
  'hstrok': 'ħ',
  'Itilde': 'Ĩ',
  'itilde': 'ĩ',
  'Imacr': 'Ī',
  'imacr': 'ī',
  'Iogon': 'Į',
  'iogon': 'į',
  'Idot': 'İ',
  'inodot': 'ı',
  'IJlig': 'Ĳ',
  'ijlig': 'ĳ',
  'Jcirc': 'Ĵ',
  'jcirc': 'ĵ',
  'Kcedil': 'Ķ',
  'kcedil': 'ķ',
  'kgreen': 'ĸ',
  'Lacute': 'Ĺ',
  'lacute': 'ĺ',
  'Lcedil': 'Ļ',
  'lcedil': 'ļ',
  'Lcaron': 'Ľ',
  'lcaron': 'ľ',
  'Lmidot': 'Ŀ',
  'lmidot': 'ŀ',
  'Lstrok': 'Ł',
  'lstrok': 'ł',
  'Nacute': 'Ń',
  'nacute': 'ń',
  'Ncedil': 'Ņ',
  'ncedil': 'ņ',
  'Ncaron': 'Ň',
  'ncaron': 'ň',
  'napos': 'ŉ',
  'ENG': 'Ŋ',
  'eng': 'ŋ',
  'Omacr': 'Ō',
  'omacr': 'ō',
  'Odblac': 'Ő',
  'odblac': 'ő',
  'OElig': 'Œ',
  'oelig': 'œ',
  'Racute': 'Ŕ',
  'racute': 'ŕ',
  'Rcedil': 'Ŗ',
  'rcedil': 'ŗ',
  'Rcaron': 'Ř',
  'rcaron': 'ř',
  'Sacute': 'Ś',
  'sacute': 'ś',
  'Scirc': 'Ŝ',
  'scirc': 'ŝ',
  'Scedil': 'Ş',
  'scedil': 'ş',
  'Scaron': 'Š',
  'scaron': 'š',
  'Tcedil': 'Ţ',
  'tcedil': 'ţ',
  'Tcaron': 'Ť',
  'tcaron': 'ť',
  'Tstrok': 'Ŧ',
  'tstrok': 'ŧ',
  'Utilde': 'Ũ',
  'utilde': 'ũ',
  'Umacr': 'Ū',
  'umacr': 'ū',
  'Ubreve': 'Ŭ',
  'ubreve': 'ŭ',
  'Uring': 'Ů',
  'uring': 'ů',
  'Udblac': 'Ű',
  'udblac': 'ű',
  'Uogon': 'Ų',
  'uogon': 'ų',
  'Wcirc': 'Ŵ',
  'wcirc': 'ŵ',
  'Ycirc': 'Ŷ',
  'ycirc': 'ŷ',
  'Yuml': 'Ÿ',
  'Zacute': 'Ź',
  'zacute': 'ź',
  'Zdot': 'Ż',
  'zdot': 'ż',
  'Zcaron': 'Ž',
  'zcaron': 'ž',
  'fnof': 'ƒ',
  'imped': 'Ƶ',
  'gacute': 'ǵ',
  'jmath': 'ȷ',
  'circ': 'ˆ',
  'caron': 'ˇ',
  'breve': '˘',
  'dot': '˙',
  'ring': '˚',
  'ogon': '˛',
  'tilde': '˜',
  'dblac': '˝',
  'Alpha': 'Α',
  'Beta': 'Β',
  'Gamma': 'Γ',
  'Delta': 'Δ',
  'Epsilon': 'Ε',
  'Zeta': 'Ζ',
  'Eta': 'Η',
  'Theta': 'Θ',
  'Iota': 'Ι',
  'Kappa': 'Κ',
  'Lambda': 'Λ',
  'Mu': 'Μ',
  'Nu': 'Ν',
  'Xi': 'Ξ',
  'Omicron': 'Ο',
  'Pi': 'Π',
  'Rho': 'Ρ',
  'Sigma': 'Σ',
  'Tau': 'Τ',
  'Upsilon': 'Υ',
  'Phi': 'Φ',
  'Chi': 'Χ',
  'Psi': 'Ψ',
  'Omega': 'Ω', // http://www.w3.org/TR/html4/sgml/entities.html
  'ohm': 'Ω', // http://www.w3.org/TR/html5/named-character-references.html
  'alpha': 'α',
  'beta': 'β',
  'gamma': 'γ',
  'delta': 'δ',
  'epsilon': 'ε',
  'zeta': 'ζ',
  'eta': 'η',
  'theta': 'θ',
  'iota': 'ι',
  'kappa': 'κ',
  'lambda': 'λ',
  'mu': 'μ',
  'nu': 'ν',
  'xi': 'ξ',
  'omicron': 'ο',
  'pi': 'π',
  'rho': 'ρ',
  'sigmaf': 'ς', // http://www.w3.org/TR/html4/sgml/entities.html
  'varsigma': 'ς', // http://www.w3.org/TR/html5/named-character-references.html
  'sigma': 'σ',
  'tau': 'τ',
  'upsilon': 'υ',
  'phi': 'φ',
  'chi': 'χ',
  'psi': 'ψ',
  'omega': 'ω',
  'thetasym': 'ϑ', // http://www.w3.org/TR/html4/sgml/entities.html
  'vartheta': 'ϑ', // http://www.w3.org/TR/html5/named-character-references.html
  'upsih': 'ϒ',
  'varphi': 'ϕ',
  'piv': 'ϖ', // http://www.w3.org/TR/html4/sgml/entities.html
  'varpi': 'ϖ', // http://www.w3.org/TR/html5/named-character-references.html
  'Gammad': 'Ϝ',
  'gammad': 'ϝ',
  'varkappa': 'ϰ',
  'varrho': 'ϱ',
  'varepsilon': 'ϵ',
  'bepsi': '϶',
  'IOcy': 'Ё',
  'DJcy': 'Ђ',
  'GJcy': 'Ѓ',
  'Jukcy': 'Є',
  'DScy': 'Ѕ',
  'Iukcy': 'І',
  'YIcy': 'Ї',
  'Jsercy': 'Ј',
  'LJcy': 'Љ',
  'NJcy': 'Њ',
  'TSHcy': 'Ћ',
  'KJcy': 'Ќ',
  'Ubrcy': 'Ў',
  'DZcy': 'Џ',
  'Acy': 'А',
  'Bcy': 'Б',
  'Vcy': 'В',
  'Gcy': 'Г',
  'Dcy': 'Д',
  'IEcy': 'Е',
  'ZHcy': 'Ж',
  'Zcy': 'З',
  'Icy': 'И',
  'Jcy': 'Й',
  'Kcy': 'К',
  'Lcy': 'Л',
  'Mcy': 'М',
  'Ncy': 'Н',
  'Ocy': 'О',
  'Pcy': 'П',
  'Rcy': 'Р',
  'Scy': 'С',
  'Tcy': 'Т',
  'Ucy': 'У',
  'Fcy': 'Ф',
  'KHcy': 'Х',
  'TScy': 'Ц',
  'CHcy': 'Ч',
  'SHcy': 'Ш',
  'SHCHcy': 'Щ',
  'HARDcy': 'Ъ',
  'Ycy': 'Ы',
  'SOFTcy': 'Ь',
  'Ecy': 'Э',
  'YUcy': 'Ю',
  'YAcy': 'Я',
  'acy': 'а',
  'bcy': 'б',
  'vcy': 'в',
  'gcy': 'г',
  'dcy': 'д',
  'iecy': 'е',
  'zhcy': 'ж',
  'zcy': 'з',
  'icy': 'и',
  'jcy': 'й',
  'kcy': 'к',
  'lcy': 'л',
  'mcy': 'м',
  'ncy': 'н',
  'ocy': 'о',
  'pcy': 'п',
  'rcy': 'р',
  'scy': 'с',
  'tcy': 'т',
  'ucy': 'у',
  'fcy': 'ф',
  'khcy': 'х',
  'tscy': 'ц',
  'chcy': 'ч',
  'shcy': 'ш',
  'shchcy': 'щ',
  'hardcy': 'ъ',
  'ycy': 'ы',
  'softcy': 'ь',
  'ecy': 'э',
  'yucy': 'ю',
  'yacy': 'я',
  'iocy': 'ё',
  'djcy': 'ђ',
  'gjcy': 'ѓ',
  'jukcy': 'є',
  'dscy': 'ѕ',
  'iukcy': 'і',
  'yicy': 'ї',
  'jsercy': 'ј',
  'ljcy': 'љ',
  'njcy': 'њ',
  'tshcy': 'ћ',
  'kjcy': 'ќ',
  'ubrcy': 'ў',
  'dzcy': 'џ',
  'ensp': ' ',
  'emsp': ' ',
  'emsp13': ' ',
  'emsp14': ' ',
  'numsp': ' ',
  'puncsp': ' ',
  'thinsp': ' ',
  'hairsp': ' ',
  'ZeroWidthSpace': '​',
  'zwnj': '‌',
  'zwj': '‍',
  'lrm': '‎',
  'rlm': '‏',
  'hyphen': '‐',
  'ndash': '–',
  'mdash': '—',
  'horbar': '―',
  'Vert': '‖',
  'lsquo': '‘',
  'rsquo': '’', // http://www.w3.org/TR/html4/sgml/entities.html
  'rsquor': '’', // http://www.w3.org/TR/html5/named-character-references.html
  'sbquo': '‚',
  'ldquo': '“',
  'rdquo': '”', // http://www.w3.org/TR/html4/sgml/entities.html
  'rdquor': '”', // http://www.w3.org/TR/html5/named-character-references.html
  'ldquo': '“', // http://www.w3.org/TR/html4/sgml/entities.html
  'ldquor': '„', // http://www.w3.org/TR/html5/named-character-references.html
  'dagger': '†',
  'Dagger': '‡', // http://www.w3.org/TR/html4/sgml/entities.html
  'ddagger': '‡', // http://www.w3.org/TR/html5/named-character-references.html
  'bull': '•', // http://www.w3.org/TR/html4/sgml/entities.html
  'bullet': '•', // http://www.w3.org/TR/html5/named-character-references.html
  'nldr': '‥',
  'hellip': '…', // http://www.w3.org/TR/html4/sgml/entities.html
  'mldr': '…', // http://www.w3.org/TR/html5/named-character-references.html
  'permil': '‰',
  'pertenk': '‱',
  'prime': '′',
  'Prime': '″',
  'tprime': '‴',
  'bprime': '‵',
  'lsaquo': '‹',
  'rsaquo': '›',
  'oline': '‾',
  'caret': '⁁',
  'hybull': '⁃',
  'frasl': '⁄',
  'bsemi': '⁏',
  'qprime': '⁗',
  'MediumSpace': ' ',
  'NoBreak': '⁠',
  'af': '⁡',
  'it': '⁢',
  'ic': '⁣',
  'euro': '€',
  'complexes': 'ℂ',
  'incare': '℅',
  'gscr': 'ℊ',
  'hamilt': 'ℋ',
  'Poincareplane': 'ℌ',
  'quaternions': 'ℍ',
  'planckh': 'ℎ',
  'plankv': 'ℏ',
  'imagline': 'ℐ',
  'image': 'ℑ', // http://www.w3.org/TR/html4/sgml/entities.html
  'imagpart': 'ℑ', // http://www.w3.org/TR/html5/named-character-references.html
  'lagran': 'ℒ',
  'ell': 'ℓ',
  'naturals': 'ℕ',
  'numero': '№',
  'copysr': '℗',
  'weierp': '℘', // http://www.w3.org/TR/html4/sgml/entities.html
  'wp': '℘', // http://www.w3.org/TR/html5/named-character-references.html
  'primes': 'ℙ',
  'rationals': 'ℚ',
  'realine': 'ℛ',
  'real': 'ℜ', // http://www.w3.org/TR/html4/sgml/entities.html
  'realpart': 'ℜ', // http://www.w3.org/TR/html5/named-character-references.html
  'reals': 'ℝ',
  'rx': '℞',
  'trade': '™',
  'integers': 'ℤ',
  'mho': '℧',
  'zeetrf': 'ℨ',
  'iiota': '℩',
  'bernou': 'ℬ',
  'Cfr': 'ℭ',
  'escr': 'ℯ',
  'expectation': 'ℰ',
  'Fscr': 'ℱ',
  'phmmat': 'ℳ',
  'oscr': 'ℴ',
  'alefsym': 'ℵ', // http://www.w3.org/TR/html4/sgml/entities.html
  'aleph': 'ℵ', // http://www.w3.org/TR/html5/named-character-references.html
  'beth': 'ℶ',
  'gimel': 'ℷ',
  'daleth': 'ℸ',
  'DD': 'ⅅ',
  'dd': 'ⅆ',
  'exponentiale': 'ⅇ',
  'ii': 'ⅈ',
  'frac13': '⅓',
  'frac23': '⅔',
  'frac15': '⅕',
  'frac25': '⅖',
  'frac35': '⅗',
  'frac45': '⅘',
  'frac16': '⅙',
  'frac56': '⅚',
  'frac18': '⅛',
  'frac38': '⅜',
  'frac58': '⅝',
  'frac78': '⅞',
  'larr': '←', // http://www.w3.org/TR/html4/sgml/entities.html
  'slarr': '←', // http://www.w3.org/TR/html5/named-character-references.html
  'uarr': '↑', // http://www.w3.org/TR/html4/sgml/entities.html
  'uparrow': '↑', // http://www.w3.org/TR/html5/named-character-references.html
  'rarr': '→', // http://www.w3.org/TR/html4/sgml/entities.html
  'srarr': '→', // http://www.w3.org/TR/html5/named-character-references.html
  'darr': '↓', // http://www.w3.org/TR/html4/sgml/entities.html
  'downarrow': '↓', // http://www.w3.org/TR/html5/named-character-references.html
  'harr': '↔', // http://www.w3.org/TR/html4/sgml/entities.html
  'leftrightarrow': '↔', // http://www.w3.org/TR/html5/named-character-references.html
  'varr': '↕',
  'nwarrow': '↖',
  'nearrow': '↗',
  'searrow': '↘',
  'swarrow': '↙',
  'nleftarrow': '↚',
  'nrightarrow': '↛',
  'rightsquigarrow': '↝',
  'twoheadleftarrow': '↞',
  'Uarr': '↟',
  'twoheadrightarrow': '↠',
  'Darr': '↡',
  'leftarrowtail': '↢',
  'rightarrowtail': '↣',
  'mapstoleft': '↤',
  'mapstoup': '↥',
  'mapsto': '↦',
  'mapstodown': '↧',
  'larrhk': '↩',
  'rarrhk': '↪',
  'looparrowleft': '↫',
  'rarrlp': '↬',
  'leftrightsquigarrow': '↭',
  'nleftrightarrow': '↮',
  'lsh': '↰',
  'rsh': '↱',
  'ldsh': '↲',
  'rdsh': '↳',
  'crarr': '↵',
  'curvearrowleft': '↶',
  'curvearrowright': '↷',
  'olarr': '↺',
  'orarr': '↻',
  'lharu': '↼',
  'lhard': '↽',
  'upharpoonright': '↾',
  'upharpoonleft': '↿',
  'rightharpoonup': '⇀',
  'rightharpoondown': '⇁',
  'downharpoonright': '⇂',
  'downharpoonleft': '⇃',
  'rlarr': '⇄',
  'udarr': '⇅',
  'lrarr': '⇆',
  'llarr': '⇇',
  'uuarr': '⇈',
  'rrarr': '⇉',
  'downdownarrows': '⇊',
  'lrhar': '⇋',
  'rlhar': '⇌',
  'nlArr': '⇍',
  'nhArr': '⇎',
  'nrArr': '⇏',
  'lArr': '⇐',
  'uArr': '⇑',
  'rArr': '⇒',
  'dArr': '⇓',
  'hArr': '⇔', // http://www.w3.org/TR/html4/sgml/entities.html
  'iff': '⇔', // http://www.w3.org/TR/html5/named-character-references.html
  'vArr': '⇕',
  'nwArr': '⇖',
  'neArr': '⇗',
  'seArr': '⇘',
  'swArr': '⇙',
  'lAarr': '⇚',
  'rAarr': '⇛',
  'zigrarr': '⇝',
  'larrb': '⇤',
  'rarrb': '⇥',
  'duarr': '⇵',
  'loarr': '⇽',
  'roarr': '⇾',
  'hoarr': '⇿',
  'forall': '∀',
  'complement': '∁',
  'part': '∂',
  'exist': '∃',
  'nexists': '∄',
  'empty': '∅', // http://www.w3.org/TR/html4/sgml/entities.html
  'varnothing': '∅', // http://www.w3.org/TR/html5/named-character-references.html
  'nabla': '∇',
  'isin': '∈', // http://www.w3.org/TR/html4/sgml/entities.html
  'isinv': '∈', // http://www.w3.org/TR/html5/named-character-references.html
  'notin': '∉', // http://www.w3.org/TR/html4/sgml/entities.html
  'notinva': '∉', // http://www.w3.org/TR/html5/named-character-references.html
  'ni': '∋', // http://www.w3.org/TR/html4/sgml/entities.html
  'niv': '∋', // http://www.w3.org/TR/html5/named-character-references.html
  'notniva': '∌',
  'prod': '∏',
  'coprod': '∐',
  'sum': '∑',
  'minus': '−',
  'mp': '∓',
  'plusdo': '∔',
  'ssetmn': '∖',
  'lowast': '∗',
  'compfn': '∘',
  'radic': '√',
  'prop': '∝', // http://www.w3.org/TR/html4/sgml/entities.html
  'vprop': '∝', // http://www.w3.org/TR/html5/named-character-references.html
  'infin': '∞',
  'angrt': '∟',
  'ang': '∠', // http://www.w3.org/TR/html4/sgml/entities.html
  'angle': '∠', // http://www.w3.org/TR/html5/named-character-references.html
  'measuredangle': '∡',
  'angsph': '∢',
  'smid': '∣',
  'nsmid': '∤',
  'spar': '∥',
  'nspar': '∦',
  'and': '∧', // http://www.w3.org/TR/html4/sgml/entities.html
  'wedge': '∧', // http://www.w3.org/TR/html5/named-character-references.html
  'or': '∨', // http://www.w3.org/TR/html4/sgml/entities.html
  'vee': '∨', // http://www.w3.org/TR/html5/named-character-references.html
  'cap': '∩',
  'cup': '∪',
  'int': '∫',
  'Int': '∬',
  'tint': '∭',
  'oint': '∮',
  'DoubleContourIntegral': '∯',
  'Cconint': '∰',
  'cwint': '∱',
  'cwconint': '∲',
  'awconint': '∳',
  'there4': '∴', // http://www.w3.org/TR/html4/sgml/entities.html
  'therefore': '∴', // http://www.w3.org/TR/html5/named-character-references.html
  'because': '∵',
  'ratio': '∶',
  'Proportion': '∷',
  'minusd': '∸',
  'mDDot': '∺',
  'homtht': '∻',
  'sim': '∼', // http://www.w3.org/TR/html4/sgml/entities.html
  'thksim': '∼', // http://www.w3.org/TR/html5/named-character-references.html
  'bsim': '∽',
  'mstpos': '∾',
  'acd': '∿',
  'wreath': '≀',
  'nsim': '≁',
  'esim': '≂',
  'simeq': '≃',
  'nsimeq': '≄',
  'cong': '≅',
  'simne': '≆',
  'ncong': '≇',
  'asymp': '≈', // http://www.w3.org/TR/html4/sgml/entities.html
  'thkap': '≈', // http://www.w3.org/TR/html5/named-character-references.html
  'napprox': '≉',
  'approxeq': '≊',
  'apid': '≋',
  'bcong': '≌',
  'asympeq': '≍',
  'bump': '≎',
  'bumpeq': '≏',
  'esdot': '≐',
  'eDot': '≑',
  'fallingdotseq': '≒',
  'risingdotseq': '≓',
  'coloneq': '≔',
  'eqcolon': '≕',
  'eqcirc': '≖',
  'cire': '≗',
  'wedgeq': '≙',
  'veeeq': '≚',
  'trie': '≜',
  'questeq': '≟',
  'ne': '≠',
  'equiv': '≡',
  'nequiv': '≢',
  'le': '≤', // http://www.w3.org/TR/html4/sgml/entities.html
  'leq': '≤', // http://www.w3.org/TR/html5/named-character-references.html
  'ge': '≥', // http://www.w3.org/TR/html4/sgml/entities.html
  'geq': '≥', // http://www.w3.org/TR/html5/named-character-references.html
  'leqq': '≦',
  'geqq': '≧',
  'lneqq': '≨',
  'gneqq': '≩',
  'll': '≪',
  'gg': '≫',
  'twixt': '≬',
  'NotCupCap': '≭',
  'nlt': '≮',
  'ngtr': '≯',
  'nleq': '≰',
  'ngeq': '≱',
  'lsim': '≲',
  'gtrsim': '≳',
  'nlsim': '≴',
  'ngsim': '≵',
  'lg': '≶',
  'gtrless': '≷',
  'ntlg': '≸',
  'ntgl': '≹',
  'prec': '≺',
  'succ': '≻',
  'preccurlyeq': '≼',
  'succcurlyeq': '≽',
  'prsim': '≾',
  'succsim': '≿',
  'nprec': '⊀',
  'nsucc': '⊁',
  'sub': '⊂', // http://www.w3.org/TR/html4/sgml/entities.html
  'subset': '⊂', // http://www.w3.org/TR/html5/named-character-references.html
  'sup': '⊃', // http://www.w3.org/TR/html4/sgml/entities.html
  'supset': '⊃', // http://www.w3.org/TR/html5/named-character-references.html
  'nsub': '⊄',
  'nsup': '⊅',
  'sube': '⊆', // http://www.w3.org/TR/html4/sgml/entities.html
  'subseteq': '⊆', // http://www.w3.org/TR/html5/named-character-references.html
  'supe': '⊇', // http://www.w3.org/TR/html4/sgml/entities.html
  'supseteq': '⊇', // http://www.w3.org/TR/html5/named-character-references.html
  'nsubseteq': '⊈',
  'nsupseteq': '⊉',
  'subsetneq': '⊊',
  'supsetneq': '⊋',
  'cupdot': '⊍',
  'uplus': '⊎',
  'sqsubset': '⊏',
  'sqsupset': '⊐',
  'sqsubseteq': '⊑',
  'sqsupseteq': '⊒',
  'sqcap': '⊓',
  'sqcup': '⊔',
  'oplus': '⊕',
  'ominus': '⊖',
  'otimes': '⊗',
  'osol': '⊘',
  'odot': '⊙',
  'ocir': '⊚',
  'oast': '⊛',
  'odash': '⊝',
  'plusb': '⊞',
  'minusb': '⊟',
  'timesb': '⊠',
  'sdotb': '⊡',
  'vdash': '⊢',
  'dashv': '⊣',
  'top': '⊤',
  'perp': '⊥',
  'models': '⊧',
  'vDash': '⊨',
  'Vdash': '⊩',
  'Vvdash': '⊪',
  'VDash': '⊫',
  'nvdash': '⊬',
  'nvDash': '⊭',
  'nVdash': '⊮',
  'nVDash': '⊯',
  'prurel': '⊰',
  'vltri': '⊲',
  'vrtri': '⊳',
  'trianglelefteq': '⊴',
  'trianglerighteq': '⊵',
  'origof': '⊶',
  'imof': '⊷',
  'mumap': '⊸',
  'hercon': '⊹',
  'intercal': '⊺',
  'veebar': '⊻',
  'barvee': '⊽',
  'angrtvb': '⊾',
  'lrtri': '⊿',
  'xwedge': '⋀',
  'xvee': '⋁',
  'xcap': '⋂',
  'xcup': '⋃',
  'diamond': '⋄',
  'sdot': '⋅',
  'sstarf': '⋆',
  'divonx': '⋇',
  'bowtie': '⋈',
  'ltimes': '⋉',
  'rtimes': '⋊',
  'lthree': '⋋',
  'rthree': '⋌',
  'bsime': '⋍',
  'cuvee': '⋎',
  'cuwed': '⋏',
  'Subset': '⋐',
  'Supset': '⋑',
  'Cap': '⋒',
  'Cup': '⋓',
  'pitchfork': '⋔',
  'epar': '⋕',
  'ltdot': '⋖',
  'gtrdot': '⋗',
  'Ll': '⋘',
  'ggg': '⋙',
  'lesseqgtr': '⋚',
  'gtreqless': '⋛',
  'curlyeqprec': '⋞',
  'curlyeqsucc': '⋟',
  'nprcue': '⋠',
  'nsccue': '⋡',
  'nsqsube': '⋢',
  'nsqsupe': '⋣',
  'lnsim': '⋦',
  'gnsim': '⋧',
  'prnsim': '⋨',
  'succnsim': '⋩',
  'ntriangleleft': '⋪',
  'ntriangleright': '⋫',
  'ntrianglelefteq': '⋬',
  'ntrianglerighteq': '⋭',
  'vellip': '⋮',
  'ctdot': '⋯',
  'utdot': '⋰',
  'dtdot': '⋱',
  'disin': '⋲',
  'isinsv': '⋳',
  'isins': '⋴',
  'isindot': '⋵',
  'notinvc': '⋶',
  'notinvb': '⋷',
  'isinE': '⋹',
  'nisd': '⋺',
  'xnis': '⋻',
  'nis': '⋼',
  'notnivc': '⋽',
  'notnivb': '⋾',
  'barwedge': '⌅',
  'doublebarwedge': '⌆',
  'lceil': '⌈',
  'rceil': '⌉',
  'lfloor': '⌊',
  'rfloor': '⌋',
  'drcrop': '⌌',
  'dlcrop': '⌍',
  'urcrop': '⌎',
  'ulcrop': '⌏',
  'bnot': '⌐',
  'profline': '⌒',
  'profsurf': '⌓',
  'telrec': '⌕',
  'target': '⌖',
  'ulcorner': '⌜',
  'urcorner': '⌝',
  'llcorner': '⌞',
  'lrcorner': '⌟',
  'sfrown': '⌢',
  'ssmile': '⌣',
  'lang': '〈', // http://www.w3.org/TR/html4/sgml/entities.html
  'rang': '〉', // http://www.w3.org/TR/html4/sgml/entities.html
  'cylcty': '⌭',
  'profalar': '⌮',
  'topbot': '⌶',
  'ovbar': '⌽',
  'solbar': '⌿',
  'angzarr': '⍼',
  'lmoustache': '⎰',
  'rmoustache': '⎱',
  'tbrk': '⎴',
  'bbrk': '⎵',
  'bbrktbrk': '⎶',
  'OverParenthesis': '⏜',
  'UnderParenthesis': '⏝',
  'OverBrace': '⏞',
  'UnderBrace': '⏟',
  'trpezium': '⏢',
  'elinters': '⏧',
  'blank': '␣',
  'oS': 'Ⓢ',
  'boxh': '─',
  'boxv': '│',
  'boxdr': '┌',
  'boxdl': '┐',
  'boxur': '└',
  'boxul': '┘',
  'boxvr': '├',
  'boxvl': '┤',
  'boxhd': '┬',
  'boxhu': '┴',
  'boxvh': '┼',
  'boxH': '═',
  'boxV': '║',
  'boxdR': '╒',
  'boxDr': '╓',
  'boxDR': '╔',
  'boxdL': '╕',
  'boxDl': '╖',
  'boxDL': '╗',
  'boxuR': '╘',
  'boxUr': '╙',
  'boxUR': '╚',
  'boxuL': '╛',
  'boxUl': '╜',
  'boxUL': '╝',
  'boxvR': '╞',
  'boxVr': '╟',
  'boxVR': '╠',
  'boxvL': '╡',
  'boxVl': '╢',
  'boxVL': '╣',
  'boxHd': '╤',
  'boxhD': '╥',
  'boxHD': '╦',
  'boxHu': '╧',
  'boxhU': '╨',
  'boxHU': '╩',
  'boxvH': '╪',
  'boxVh': '╫',
  'boxVH': '╬',
  'uhblk': '▀',
  'lhblk': '▄',
  'block': '█',
  'blk14': '░',
  'blk12': '▒',
  'blk34': '▓',
  'square': '□',
  'squf': '▪',
  'EmptyVerySmallSquare': '▫',
  'rect': '▭',
  'marker': '▮',
  'fltns': '▱',
  'xutri': '△',
  'utrif': '▴',
  'utri': '▵',
  'rtrif': '▸',
  'triangleright': '▹',
  'xdtri': '▽',
  'dtrif': '▾',
  'triangledown': '▿',
  'ltrif': '◂',
  'triangleleft': '◃',
  'loz': '◊', // http://www.w3.org/TR/html4/sgml/entities.html
  'lozenge': '◊', // http://www.w3.org/TR/html5/named-character-references.html
  'cir': '○',
  'tridot': '◬',
  'xcirc': '◯',
  'ultri': '◸',
  'urtri': '◹',
  'lltri': '◺',
  'EmptySmallSquare': '◻',
  'FilledSmallSquare': '◼',
  'starf': '★',
  'star': '☆',
  'phone': '☎',
  'female': '♀',
  'male': '♂',
  'spades': '♠', // http://www.w3.org/TR/html4/sgml/entities.html
  'spadesuit': '♠', // http://www.w3.org/TR/html5/named-character-references.html
  'clubs': '♣', // http://www.w3.org/TR/html4/sgml/entities.html
  'clubsuit': '♣', // http://www.w3.org/TR/html5/named-character-references.html
  'hearts': '♥', // http://www.w3.org/TR/html4/sgml/entities.html
  'heartsuit': '♥', // http://www.w3.org/TR/html5/named-character-references.html
  'diams': '♦',
  'sung': '♪',
  'flat': '♭',
  'natural': '♮',
  'sharp': '♯',
  'checkmark': '✓',
  'cross': '✗',
  'maltese': '✠',
  'sext': '✶',
  'VerticalSeparator': '❘',
  'lbbrk': '❲',
  'rbbrk': '❳',
  'bsolhsub': '⟈',
  'suphsol': '⟉',
  'lobrk': '⟦',
  'robrk': '⟧',
  'langle': '⟨',
  'rangle': '⟩',
  'Lang': '⟪',
  'Rang': '⟫',
  'loang': '⟬',
  'roang': '⟭',
  'xlarr': '⟵',
  'xrarr': '⟶',
  'xharr': '⟷',
  'xlArr': '⟸',
  'xrArr': '⟹',
  'xhArr': '⟺',
  'xmap': '⟼',
  'dzigrarr': '⟿',
  'nvlArr': '⤂',
  'nvrArr': '⤃',
  'nvHarr': '⤄',
  'Map': '⤅',
  'lbarr': '⤌',
  'rbarr': '⤍',
  'lBarr': '⤎',
  'rBarr': '⤏',
  'drbkarow': '⤐',
  'DDotrahd': '⤑',
  'UpArrowBar': '⤒',
  'DownArrowBar': '⤓',
  'Rarrtl': '⤖',
  'latail': '⤙',
  'ratail': '⤚',
  'lAtail': '⤛',
  'rAtail': '⤜',
  'larrfs': '⤝',
  'rarrfs': '⤞',
  'larrbfs': '⤟',
  'rarrbfs': '⤠',
  'nwarhk': '⤣',
  'nearhk': '⤤',
  'searhk': '⤥',
  'swarhk': '⤦',
  'nwnear': '⤧',
  'toea': '⤨',
  'tosa': '⤩',
  'swnwar': '⤪',
  'rarrc': '⤳',
  'cudarrr': '⤵',
  'ldca': '⤶',
  'rdca': '⤷',
  'cudarrl': '⤸',
  'larrpl': '⤹',
  'curarrm': '⤼',
  'cularrp': '⤽',
  'rarrpl': '⥅',
  'harrcir': '⥈',
  'Uarrocir': '⥉',
  'lurdshar': '⥊',
  'ldrushar': '⥋',
  'LeftRightVector': '⥎',
  'RightUpDownVector': '⥏',
  'DownLeftRightVector': '⥐',
  'LeftUpDownVector': '⥑',
  'LeftVectorBar': '⥒',
  'RightVectorBar': '⥓',
  'RightUpVectorBar': '⥔',
  'RightDownVectorBar': '⥕',
  'DownLeftVectorBar': '⥖',
  'DownRightVectorBar': '⥗',
  'LeftUpVectorBar': '⥘',
  'LeftDownVectorBar': '⥙',
  'LeftTeeVector': '⥚',
  'RightTeeVector': '⥛',
  'RightUpTeeVector': '⥜',
  'RightDownTeeVector': '⥝',
  'DownLeftTeeVector': '⥞',
  'DownRightTeeVector': '⥟',
  'LeftUpTeeVector': '⥠',
  'LeftDownTeeVector': '⥡',
  'lHar': '⥢',
  'uHar': '⥣',
  'rHar': '⥤',
  'dHar': '⥥',
  'luruhar': '⥦',
  'ldrdhar': '⥧',
  'ruluhar': '⥨',
  'rdldhar': '⥩',
  'lharul': '⥪',
  'llhard': '⥫',
  'rharul': '⥬',
  'lrhard': '⥭',
  'udhar': '⥮',
  'duhar': '⥯',
  'RoundImplies': '⥰',
  'erarr': '⥱',
  'simrarr': '⥲',
  'larrsim': '⥳',
  'rarrsim': '⥴',
  'rarrap': '⥵',
  'ltlarr': '⥶',
  'gtrarr': '⥸',
  'subrarr': '⥹',
  'suplarr': '⥻',
  'lfisht': '⥼',
  'rfisht': '⥽',
  'ufisht': '⥾',
  'dfisht': '⥿',
  'lopar': '⦅',
  'ropar': '⦆',
  'lbrke': '⦋',
  'rbrke': '⦌',
  'lbrkslu': '⦍',
  'rbrksld': '⦎',
  'lbrksld': '⦏',
  'rbrkslu': '⦐',
  'langd': '⦑',
  'rangd': '⦒',
  'lparlt': '⦓',
  'rpargt': '⦔',
  'gtlPar': '⦕',
  'ltrPar': '⦖',
  'vzigzag': '⦚',
  'vangrt': '⦜',
  'angrtvbd': '⦝',
  'ange': '⦤',
  'range': '⦥',
  'dwangle': '⦦',
  'uwangle': '⦧',
  'angmsdaa': '⦨',
  'angmsdab': '⦩',
  'angmsdac': '⦪',
  'angmsdad': '⦫',
  'angmsdae': '⦬',
  'angmsdaf': '⦭',
  'angmsdag': '⦮',
  'angmsdah': '⦯',
  'bemptyv': '⦰',
  'demptyv': '⦱',
  'cemptyv': '⦲',
  'raemptyv': '⦳',
  'laemptyv': '⦴',
  'ohbar': '⦵',
  'omid': '⦶',
  'opar': '⦷',
  'operp': '⦹',
  'olcross': '⦻',
  'odsold': '⦼',
  'olcir': '⦾',
  'ofcir': '⦿',
  'olt': '⧀',
  'ogt': '⧁',
  'cirscir': '⧂',
  'cirE': '⧃',
  'solb': '⧄',
  'bsolb': '⧅',
  'boxbox': '⧉',
  'trisb': '⧍',
  'rtriltri': '⧎',
  'LeftTriangleBar': '⧏',
  'RightTriangleBar': '⧐',
  'iinfin': '⧜',
  'infintie': '⧝',
  'nvinfin': '⧞',
  'eparsl': '⧣',
  'smeparsl': '⧤',
  'eqvparsl': '⧥',
  'lozf': '⧫',
  'RuleDelayed': '⧴',
  'dsol': '⧶',
  'xodot': '⨀',
  'xoplus': '⨁',
  'xotime': '⨂',
  'xuplus': '⨄',
  'xsqcup': '⨆',
  'qint': '⨌',
  'fpartint': '⨍',
  'cirfnint': '⨐',
  'awint': '⨑',
  'rppolint': '⨒',
  'scpolint': '⨓',
  'npolint': '⨔',
  'pointint': '⨕',
  'quatint': '⨖',
  'intlarhk': '⨗',
  'pluscir': '⨢',
  'plusacir': '⨣',
  'simplus': '⨤',
  'plusdu': '⨥',
  'plussim': '⨦',
  'plustwo': '⨧',
  'mcomma': '⨩',
  'minusdu': '⨪',
  'loplus': '⨭',
  'roplus': '⨮',
  'Cross': '⨯',
  'timesd': '⨰',
  'timesbar': '⨱',
  'smashp': '⨳',
  'lotimes': '⨴',
  'rotimes': '⨵',
  'otimesas': '⨶',
  'Otimes': '⨷',
  'odiv': '⨸',
  'triplus': '⨹',
  'triminus': '⨺',
  'tritime': '⨻',
  'iprod': '⨼',
  'amalg': '⨿',
  'capdot': '⩀',
  'ncup': '⩂',
  'ncap': '⩃',
  'capand': '⩄',
  'cupor': '⩅',
  'cupcap': '⩆',
  'capcup': '⩇',
  'cupbrcap': '⩈',
  'capbrcup': '⩉',
  'cupcup': '⩊',
  'capcap': '⩋',
  'ccups': '⩌',
  'ccaps': '⩍',
  'ccupssm': '⩐',
  'And': '⩓',
  'Or': '⩔',
  'andand': '⩕',
  'oror': '⩖',
  'orslope': '⩗',
  'andslope': '⩘',
  'andv': '⩚',
  'orv': '⩛',
  'andd': '⩜',
  'ord': '⩝',
  'wedbar': '⩟',
  'sdote': '⩦',
  'simdot': '⩪',
  'congdot': '⩭',
  'easter': '⩮',
  'apacir': '⩯',
  'apE': '⩰',
  'eplus': '⩱',
  'pluse': '⩲',
  'Esim': '⩳',
  'Colone': '⩴',
  'Equal': '⩵',
  'eDDot': '⩷',
  'equivDD': '⩸',
  'ltcir': '⩹',
  'gtcir': '⩺',
  'ltquest': '⩻',
  'gtquest': '⩼',
  'les': '⩽',
  'ges': '⩾',
  'lesdot': '⩿',
  'gesdot': '⪀',
  'lesdoto': '⪁',
  'gesdoto': '⪂',
  'lesdotor': '⪃',
  'gesdotol': '⪄',
  'lessapprox': '⪅',
  'gtrapprox': '⪆',
  'lneq': '⪇',
  'gneq': '⪈',
  'lnapprox': '⪉',
  'gnapprox': '⪊',
  'lesseqqgtr': '⪋',
  'gtreqqless': '⪌',
  'lsime': '⪍',
  'gsime': '⪎',
  'lsimg': '⪏',
  'gsiml': '⪐',
  'lgE': '⪑',
  'glE': '⪒',
  'lesges': '⪓',
  'gesles': '⪔',
  'eqslantless': '⪕',
  'eqslantgtr': '⪖',
  'elsdot': '⪗',
  'egsdot': '⪘',
  'el': '⪙',
  'eg': '⪚',
  'siml': '⪝',
  'simg': '⪞',
  'simlE': '⪟',
  'simgE': '⪠',
  'LessLess': '⪡',
  'GreaterGreater': '⪢',
  'glj': '⪤',
  'gla': '⪥',
  'ltcc': '⪦',
  'gtcc': '⪧',
  'lescc': '⪨',
  'gescc': '⪩',
  'smt': '⪪',
  'lat': '⪫',
  'smte': '⪬',
  'late': '⪭',
  'bumpE': '⪮',
  'preceq': '⪯',
  'succeq': '⪰',
  'prE': '⪳',
  'scE': '⪴',
  'prnE': '⪵',
  'succneqq': '⪶',
  'precapprox': '⪷',
  'succapprox': '⪸',
  'prnap': '⪹',
  'succnapprox': '⪺',
  'Pr': '⪻',
  'Sc': '⪼',
  'subdot': '⪽',
  'supdot': '⪾',
  'subplus': '⪿',
  'supplus': '⫀',
  'submult': '⫁',
  'supmult': '⫂',
  'subedot': '⫃',
  'supedot': '⫄',
  'subseteqq': '⫅',
  'supseteqq': '⫆',
  'subsim': '⫇',
  'supsim': '⫈',
  'subsetneqq': '⫋',
  'supsetneqq': '⫌',
  'csub': '⫏',
  'csup': '⫐',
  'csube': '⫑',
  'csupe': '⫒',
  'subsup': '⫓',
  'supsub': '⫔',
  'subsub': '⫕',
  'supsup': '⫖',
  'suphsub': '⫗',
  'supdsub': '⫘',
  'forkv': '⫙',
  'topfork': '⫚',
  'mlcp': '⫛',
  'DoubleLeftTee': '⫤',
  'Vdashl': '⫦',
  'Barv': '⫧',
  'vBar': '⫨',
  'vBarv': '⫩',
  'Vbar': '⫫',
  'Not': '⫬',
  'bNot': '⫭',
  'rnmid': '⫮',
  'cirmid': '⫯',
  'midcir': '⫰',
  'topcir': '⫱',
  'nhpar': '⫲',
  'parsim': '⫳',
  'parsl': '⫽',
  'fflig': 'ﬀ',
  'filig': 'ﬁ',
  'fllig': 'ﬂ',
  'ffilig': 'ﬃ',
  'ffllig': 'ﬄ',
  'Ascr': '풜',
  'Cscr': '풞',
  'Dscr': '풟',
  'Gscr': '풢',
  'Jscr': '풥',
  'Kscr': '풦',
  'Nscr': '풩',
  'Oscr': '풪',
  'Pscr': '풫',
  'Qscr': '풬',
  'Sscr': '풮',
  'Tscr': '풯',
  'Uscr': '풰',
  'Vscr': '풱',
  'Wscr': '풲',
  'Xscr': '풳',
  'Yscr': '풴',
  'Zscr': '풵',
  'ascr': '풶',
  'bscr': '풷',
  'cscr': '풸',
  'dscr': '풹',
  'fscr': '풻',
  'hscr': '풽',
  'iscr': '풾',
  'jscr': '풿',
  'kscr': '퓀',
  'lscr': '퓁',
  'mscr': '퓂',
  'nscr': '퓃',
  'pscr': '퓅',
  'qscr': '퓆',
  'rscr': '퓇',
  'sscr': '퓈',
  'tscr': '퓉',
  'uscr': '퓊',
  'vscr': '퓋',
  'wscr': '퓌',
  'xscr': '퓍',
  'yscr': '퓎',
  'zscr': '퓏',
  'Afr': '프',
  'Bfr': '픅',
  'Dfr': '픇',
  'Efr': '픈',
  'Ffr': '픉',
  'Gfr': '픊',
  'Jfr': '픍',
  'Kfr': '픎',
  'Lfr': '픏',
  'Mfr': '픐',
  'Nfr': '픑',
  'Ofr': '픒',
  'Pfr': '픓',
  'Qfr': '픔',
  'Sfr': '픖',
  'Tfr': '픗',
  'Ufr': '픘',
  'Vfr': '픙',
  'Wfr': '픚',
  'Xfr': '픛',
  'Yfr': '픜',
  'afr': '픞',
  'bfr': '픟',
  'cfr': '픠',
  'dfr': '픡',
  'efr': '픢',
  'ffr': '픣',
  'gfr': '픤',
  'hfr': '픥',
  'ifr': '픦',
  'jfr': '픧',
  'kfr': '픨',
  'lfr': '픩',
  'mfr': '픪',
  'nfr': '픫',
  'ofr': '픬',
  'pfr': '픭',
  'qfr': '픮',
  'rfr': '픯',
  'sfr': '픰',
  'tfr': '픱',
  'ufr': '픲',
  'vfr': '픳',
  'wfr': '픴',
  'xfr': '픵',
  'yfr': '픶',
  'zfr': '픷',
  'Aopf': '픸',
  'Bopf': '픹',
  'Dopf': '픻',
  'Eopf': '피',
  'Fopf': '픽',
  'Gopf': '픾',
  'Iopf': '핀',
  'Jopf': '핁',
  'Kopf': '핂',
  'Lopf': '핃',
  'Mopf': '필',
  'Oopf': '핆',
  'Sopf': '핊',
  'Topf': '핋',
  'Uopf': '핌',
  'Vopf': '핍',
  'Wopf': '핎',
  'Xopf': '핏',
  'Yopf': '핐',
  'aopf': '핒',
  'bopf': '핓',
  'copf': '핔',
  'dopf': '핕',
  'eopf': '핖',
  'fopf': '핗',
  'gopf': '하',
  'hopf': '학',
  'iopf': '핚',
  'jopf': '핛',
  'kopf': '한',
  'lopf': '핝',
  'mopf': '핞',
  'nopf': '핟',
  'oopf': '할',
  'popf': '핡',
  'qopf': '핢',
  'ropf': '핣',
  'sopf': '핤',
  'topf': '핥',
  'uopf': '핦',
  'vopf': '핧',
  'wopf': '함',
  'xopf': '합',
  'yopf': '핪',
  'zopf': '핫'
};

var specialCharEntities = {
  '&': '&amp;',
  '"': '&quot;',
  '<': '&lt;',
  '>': '&gt;',
  '\xA0': '&nbsp;'
};

var entityRegExp = /&(?:#([0-9]+)|#x([0-9a-f]+)|([a-z0-9]+));/gi;
var attributeModeSpecialCharRegExp = /["&<>\xA0]/g;
var nonAttributeModeSpecialCharRegExp = /[&<>\xA0]/g;

exports.HTMLDecode = function decode(s) {
  if (!s) return '';
  return s.replace(entityRegExp, function ($0, decimalStr, hexStr, entityName) {
    if (decimalStr) {
      return String.fromCharCode(parseInt(decimalStr, 10));
    } else if (hexStr) {
      return String.fromCharCode(parseInt(hexStr, 16));
    } else {
      // Fall back to the original string if we don't know the entity, as per browser behavior:
      return charByEntityName[entityName] || $0;
    }
  });
};

function specialCharToEntity(s) {
  var entity = specialCharEntities[s];
  return entity ? entity : s;
}

exports.HTMLEncode = function encode(s, attributeMode) {
  if (!s) return '';
  if (!s.replace) return s;
  if(attributeMode) {
	  return s.replace(attributeModeSpecialCharRegExp, specialCharToEntity);
  } else {
	  return s.replace(nonAttributeModeSpecialCharRegExp, specialCharToEntity);
  }
};
