/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import ghidra.file.formats.cart.CartInvalidARC4KeyException;
import ghidra.file.formats.cart.CartV1StreamProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class CartV1StreamDecryptor
extends CartV1StreamProcessor {
    private Cipher cipher;

    public CartV1StreamDecryptor(InputStream delegate, byte[] arc4Key) throws CartInvalidARC4KeyException {
        super(delegate);
        if (arc4Key == null) {
            throw new CartInvalidARC4KeyException("Invalid null CaRT key.");
        }
        if (arc4Key.length != 16) {
            arc4Key = Arrays.copyOf(arc4Key, 16);
        }
        SecretKeySpec key = new SecretKeySpec(arc4Key, "ARCFOUR");
        try {
            this.cipher = Cipher.getInstance("ARCFOUR");
            this.cipher.init(2, (Key)key, this.cipher.getParameters());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CartInvalidARC4KeyException("CaRT key error " + String.valueOf(e));
        }
    }

    @Override
    protected boolean readNextChunk() throws IOException {
        byte[] readBuffer = new byte[65536];
        this.currentChunk = null;
        this.chunkPos = 0;
        if (this.cipher == null) {
            return false;
        }
        int bytesRead = this.delegate.read(readBuffer);
        if (bytesRead <= 0) {
            try {
                this.currentChunk = this.cipher.doFinal();
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new IOException(e);
            }
            finally {
                this.cipher = null;
            }
        } else {
            this.currentChunk = this.cipher.update(readBuffer, 0, bytesRead);
        }
        return this.currentChunk != null && this.currentChunk.length > 0;
    }
}

