/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class SynchronizedSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> spliterator;
    private final Object lock;

    public SynchronizedSpliterator(Spliterator<T> spliterator, Object lock) {
        this.spliterator = spliterator;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean result;
        AtomicReference ref = new AtomicReference();
        Object object = this.lock;
        synchronized (object) {
            result = this.spliterator.tryAdvance(ref::set);
        }
        if (!result) {
            return false;
        }
        action.accept(ref.get());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<T> trySplit() {
        Spliterator<T> newSplit;
        Object object = this.lock;
        synchronized (object) {
            newSplit = this.spliterator.trySplit();
        }
        if (newSplit == null) {
            return null;
        }
        return new SynchronizedSpliterator<T>(newSplit, this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long estimateSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.spliterator.estimateSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int characteristics() {
        Object object = this.lock;
        synchronized (object) {
            return this.spliterator.characteristics();
        }
    }
}

