/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.util.PeekableIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.util.AbstractPeekableIterator;
import ghidra.util.AddressRangeComparators;
import ghidra.util.MathUtilities;
import ghidra.util.MergeSortingIterator;
import ghidra.util.PeekableIterators;
import java.util.Collection;
import java.util.Iterator;

public class UnionAddressRangeIterator
extends AbstractPeekableIterator<AddressRange>
implements AddressRangeIterator {
    private final PeekableIterator<AddressRange> mit;
    private final boolean forward;

    public UnionAddressRangeIterator(Iterator<AddressRange> it, boolean forward) {
        this.mit = PeekableIterators.castOrWrap(it);
        this.forward = forward;
    }

    public UnionAddressRangeIterator(Collection<Iterator<AddressRange>> iterators, boolean forward) {
        this.mit = new MergeSortingIterator<AddressRange>(iterators, forward ? AddressRangeComparators.FORWARD : AddressRangeComparators.BACKWARD);
        this.forward = forward;
    }

    public Iterator<AddressRange> iterator() {
        return this;
    }

    @Override
    protected AddressRange seekNext() {
        if (!this.mit.hasNext()) {
            return null;
        }
        AddressRange peek = (AddressRange)this.mit.peek();
        Address min = peek.getMinAddress();
        Address max = peek.getMaxAddress();
        while (true) {
            this.mit.next();
            if (!this.mit.hasNext() || (peek = (AddressRange)this.mit.peek()).getAddressSpace() != min.getAddressSpace()) break;
            if (this.forward) {
                Address n = max.next();
                if (n != null && peek.getMinAddress().compareTo((Object)n) > 0) break;
                max = (Address)MathUtilities.cmax((Comparable)max, (Comparable)peek.getMaxAddress());
                continue;
            }
            Address p = min.previous();
            if (p != null && peek.getMaxAddress().compareTo((Object)p) < 0) break;
            min = (Address)MathUtilities.cmin((Comparable)min, (Comparable)peek.getMinAddress());
        }
        return new AddressRangeImpl(min, max);
    }
}

