/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.VectorResult;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ResponseVectorId
extends QueryResponseRecord {
    public List<VectorResult> vectorResults = new ArrayList<VectorResult>();

    public ResponseVectorId() {
        super("responsevectorid");
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        for (VectorResult vecResult : this.vectorResults) {
            if (vecResult == null) {
                fwrite.append(" <null/>\n");
                continue;
            }
            vecResult.saveXml(fwrite);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            if (parser.peek().getName().equals("null")) {
                parser.discardSubTree();
                this.vectorResults.add(null);
                continue;
            }
            VectorResult vecResult = new VectorResult();
            vecResult.restoreXml(parser, vectorFactory);
            this.vectorResults.add(vecResult);
        }
        parser.end();
    }
}

