/*
 * Decompiled with CFR 0.152.
 */
package docking.util;

import docking.util.AnimationPainter;
import docking.util.AnimationUtils;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import java.awt.Graphics;
import java.time.Duration;
import java.util.Objects;
import javax.swing.JComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import utility.function.Callback;
import utility.function.Dummy;

public class AnimationRunner {
    private JComponent component;
    private GGlassPane glassPane;
    private Animator animator;
    private UserDefinedPainter painter;
    private boolean removePainterWhenFinished = true;
    private Callback doneCallback = Callback.dummy();
    private Duration duration = Duration.ofSeconds(1L);
    private Double[] values = new Double[]{0.0, 1.0};

    public AnimationRunner(JComponent component) {
        this.component = component;
    }

    public void setPainter(AnimationPainter animationPainter) {
        this.painter = new UserDefinedPainter(this, animationPainter);
    }

    public void setValues(Double ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("'values' cannot be null or empty");
        }
        this.values = values;
    }

    public void setRemovePainterWhenFinished(boolean b) {
        this.removePainterWhenFinished = b;
    }

    public void setDoneCallback(Callback c) {
        this.doneCallback = Dummy.ifNull((Callback)c);
    }

    public void setDuration(Duration duration) {
        this.duration = Objects.requireNonNull(duration);
    }

    public void setCurrentValue(Double value) {
        this.painter.setValue(value);
        this.glassPane.repaint();
    }

    public Animator createAnimator() {
        if (this.animator != null) {
            return this.animator;
        }
        this.glassPane = AnimationUtils.getGlassPane(this.component);
        if (this.glassPane == null) {
            Msg.debug(AnimationUtils.class, (Object)("Cannot animate without a " + GGlassPane.class.getName() + " installed"));
            throw new IllegalStateException("Unable to find Glass Pane");
        }
        if (this.painter == null) {
            throw new IllegalStateException("A painter must be supplied");
        }
        this.setCurrentValue(this.values[0]);
        int aniationDuration = (int)this.duration.toMillis();
        if (!AnimationUtils.isAnimationEnabled()) {
            aniationDuration = 0;
        }
        this.animator = PropertySetter.createAnimator((int)aniationDuration, (Object)this, (String)"currentValue", (Object[])this.values);
        this.animator.setAcceleration(0.2f);
        this.animator.setDeceleration(0.8f);
        this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                AnimationRunner.this.done();
            }
        });
        return this.animator;
    }

    public void start() {
        if (this.painter == null) {
            throw new IllegalStateException("A painter must be supplied");
        }
        if (this.animator != null) {
            if (this.animator.isRunning()) {
                this.animator.stop();
            }
        } else {
            this.animator = this.createAnimator();
        }
        this.glassPane.addPainter((GGlassPanePainter)this.painter);
        this.animator.start();
    }

    public void stop() {
        if (this.animator != null) {
            this.animator.stop();
        }
        this.glassPane.removePainter((GGlassPanePainter)this.painter);
    }

    private void done() {
        this.setCurrentValue(this.values[this.values.length - 1]);
        if (this.removePainterWhenFinished) {
            this.glassPane.removePainter((GGlassPanePainter)this.painter);
        } else {
            this.glassPane.repaint();
        }
        this.doneCallback.call();
    }

    private class UserDefinedPainter
    implements GGlassPanePainter {
        private AnimationPainter userPainter;
        private double value;

        UserDefinedPainter(AnimationRunner animationRunner, AnimationPainter userPainter) {
            this.userPainter = userPainter;
        }

        void setValue(double value) {
            this.value = value;
        }

        public void paint(GGlassPane gp, Graphics graphics) {
            this.userPainter.paint(gp, graphics, this.value);
        }
    }
}

