/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.dvcs;

import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.ASN1Sequence;
import org.python.bouncycastle.asn1.cms.ContentInfo;
import org.python.bouncycastle.asn1.cms.SignedData;
import org.python.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import org.python.bouncycastle.cms.CMSSignedData;
import org.python.bouncycastle.dvcs.DVCSConstructionException;
import org.python.bouncycastle.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private org.python.bouncycastle.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData cMSSignedData) throws DVCSConstructionException {
        this(SignedData.getInstance((Object)cMSSignedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Response");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? org.python.bouncycastle.asn1.dvcs.DVCSResponse.getInstance((Object)contentInfo.getContent()) : org.python.bouncycastle.asn1.dvcs.DVCSResponse.getInstance((Object)ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception exception) {
            throw new DVCSConstructionException("Unable to parse content: " + exception.getMessage(), exception);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

