/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import ghidra.graph.viewer.GraphViewer;
import java.awt.geom.Point2D;

public class VisualGraphScalingControl
implements ScalingControl {
    private double crossover = 1.0;

    public void scale(VisualizationServer<?, ?> vv, float amount, Point2D at) {
        MutableTransformer layoutTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
        MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
        double modelScale = layoutTransformer.getScale();
        double viewScale = viewTransformer.getScale();
        double inverseViewScale = Math.sqrt(this.crossover) / viewScale;
        double scale = modelScale * viewScale;
        if (!this.useMouseRelativeZoom(vv)) {
            at = vv.getCenter();
        }
        if (scale * (double)amount < this.crossover) {
            viewTransformer.scale((double)amount, (double)amount, at);
        } else {
            viewTransformer.scale(inverseViewScale, inverseViewScale, at);
        }
        vv.repaint();
    }

    private boolean useMouseRelativeZoom(VisualizationServer<?, ?> vv) {
        if (!(vv instanceof GraphViewer)) {
            return true;
        }
        GraphViewer graphViewer = (GraphViewer)vv;
        return graphViewer.useMouseRelativeZoom();
    }
}

