/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class DataTypeMnemonicSettingsDefinition
implements EnumSettingsDefinition {
    public static final int DEFAULT = 0;
    public static final int ASSEMBLY = 1;
    public static final int CSPEC = 2;
    private static final String[] choices = new String[]{"default", "assembly", "C"};
    private static final String MNEMONIC = "mnemonic";
    public static final DataTypeMnemonicSettingsDefinition DEF = new DataTypeMnemonicSettingsDefinition();

    private DataTypeMnemonicSettingsDefinition() {
    }

    public int getMnemonicStyle(Settings settings) {
        if (settings == null) {
            return 1;
        }
        Long value = settings.getLong(MNEMONIC);
        if (value == null) {
            return 1;
        }
        int style = (int)value.longValue();
        if (style < 0 || style > 2) {
            style = 1;
        }
        return style;
    }

    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public int getChoice(Settings settings) {
        return this.getMnemonicStyle(settings);
    }

    public void setChoice(Settings settings, int value) {
        if (value < 0 || value > 2) {
            settings.clearSetting(MNEMONIC);
        } else {
            settings.setLong(MNEMONIC, (long)value);
        }
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return "Mnemonic-style";
    }

    public String getStorageKey() {
        return MNEMONIC;
    }

    public String getDescription() {
        return "Selects the data-type mnemonic style";
    }

    public String getDisplayChoice(int value, Settings settings) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(MNEMONIC);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(MNEMONIC);
        if (l == null) {
            destSettings.clearSetting(MNEMONIC);
        } else {
            destSettings.setLong(MNEMONIC, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(MNEMONIC) != null;
    }
}

