/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class CodeBlockImpl
implements CodeBlock {
    private CodeBlockModel model;
    private Address[] starts;
    private AddressSetView set;

    public CodeBlockImpl(CodeBlockModel model, Address[] starts, AddressSetView body) {
        if (starts != null) {
            this.starts = (Address[])starts.clone();
            Arrays.sort(this.starts);
        }
        this.model = model;
        this.set = body;
    }

    @Override
    public Address getFirstStartAddress() {
        return this.starts[0];
    }

    @Override
    public Address[] getStartAddresses() {
        return this.starts;
    }

    @Override
    public String getName() {
        return this.model.getName(this);
    }

    @Override
    public FlowType getFlowType() {
        return this.model.getFlowType(this);
    }

    @Override
    public int getNumSources(TaskMonitor monitor) throws CancelledException {
        return this.model.getNumSources(this, monitor);
    }

    @Override
    public CodeBlockReferenceIterator getSources(TaskMonitor monitor) throws CancelledException {
        return this.model.getSources(this, monitor);
    }

    @Override
    public int getNumDestinations(TaskMonitor monitor) throws CancelledException {
        return this.model.getNumDestinations(this, monitor);
    }

    @Override
    public CodeBlockReferenceIterator getDestinations(TaskMonitor monitor) throws CancelledException {
        return this.model.getDestinations(this, monitor);
    }

    @Override
    public CodeBlockModel getModel() {
        return this.model;
    }

    public String toString() {
        ArrayList<Address> sList = new ArrayList<Address>();
        ArrayList<Address> dList = new ArrayList<Address>();
        try {
            CodeBlockReferenceIterator ri = this.getSources(TaskMonitor.DUMMY);
            while (ri.hasNext()) {
                CodeBlockReference ref = ri.next();
                Address a = ref.getSourceAddress();
                sList.add(a);
            }
            CodeBlockReferenceIterator di = this.getDestinations(TaskMonitor.DUMMY);
            while (di.hasNext()) {
                CodeBlockReference ref = di.next();
                Address a = ref.getDestinationAddress();
                dList.add(a);
            }
        }
        catch (CancelledException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        return this.model.getName(this) + "  src:" + String.valueOf(sList) + "  dst:" + String.valueOf(dList);
    }

    @Override
    public boolean contains(Address a) {
        return this.set.contains(a);
    }

    @Override
    public boolean contains(Address start, Address end) {
        return this.set.contains(start, end);
    }

    @Override
    public boolean contains(AddressSetView rangeSet) {
        return this.set.contains(rangeSet);
    }

    @Override
    public boolean intersects(Address start, Address end) {
        return this.set.intersects(start, end);
    }

    @Override
    public boolean intersects(AddressSetView addrSet) {
        return this.set.intersects(addrSet);
    }

    @Override
    public AddressSet intersect(AddressSetView view) {
        return this.set.intersect(view);
    }

    @Override
    public AddressSet intersectRange(Address start, Address end) {
        return this.set.intersectRange(start, end);
    }

    @Override
    public AddressSet union(AddressSetView addrSet) {
        return this.set.union(addrSet);
    }

    @Override
    public AddressSet xor(AddressSetView addrSet) {
        return this.set.xor(addrSet);
    }

    @Override
    public AddressSet subtract(AddressSetView addrSet) {
        return this.set.subtract(addrSet);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Address getMinAddress() {
        return this.set.getMinAddress();
    }

    @Override
    public Address getMaxAddress() {
        return this.set.getMaxAddress();
    }

    @Override
    public int getNumAddressRanges() {
        return this.set.getNumAddressRanges();
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        return this.set.getAddressRanges();
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this.set.getAddressRanges();
    }

    @Override
    public long getNumAddresses() {
        return this.set.getNumAddresses();
    }

    @Override
    public AddressIterator getAddresses(boolean forward) {
        return this.set.getAddresses(forward);
    }

    @Override
    public AddressIterator getAddresses(Address start, boolean forward) {
        return this.set.getAddresses(start, forward);
    }

    @Override
    public boolean hasSameAddresses(AddressSetView view) {
        return this.set.hasSameAddresses(view);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeBlockImpl block = (CodeBlockImpl)obj;
        if (!this.model.getName().equals(block.model.getName())) {
            return false;
        }
        if (block.starts.length != this.starts.length) {
            return false;
        }
        for (int i = 0; i < this.starts.length; ++i) {
            if (this.starts[i].equals(block.starts[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean startAtFront) {
        return this.set.getAddressRanges(startAtFront);
    }

    public int hashCode() {
        return this.starts[0].hashCode();
    }

    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return this.set.getAddressRanges(start, forward);
    }

    @Override
    public AddressRange getFirstRange() {
        return this.set.getFirstRange();
    }

    @Override
    public AddressRange getLastRange() {
        return this.set.getLastRange();
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        return this.set.getRangeContaining(address);
    }

    @Override
    public Iterator<AddressRange> iterator(boolean forward) {
        return this.set.iterator(forward);
    }

    @Override
    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.set.iterator(start, forward);
    }

    @Override
    public Address findFirstAddressInCommon(AddressSetView otherSet) {
        return this.set.findFirstAddressInCommon(otherSet);
    }
}

