/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class AddressCollectors {
    public static Collector<AddressRange, AddressSet, AddressSet> toAddressSet() {
        return new Collector<AddressRange, AddressSet, AddressSet>(){

            @Override
            public Supplier<AddressSet> supplier() {
                return AddressSet::new;
            }

            @Override
            public BiConsumer<AddressSet, AddressRange> accumulator() {
                return AddressSet::add;
            }

            @Override
            public BinaryOperator<AddressSet> combiner() {
                return (s1, s2) -> {
                    s1.add((AddressSetView)s2);
                    return s1;
                };
            }

            @Override
            public Function<AddressSet, AddressSet> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Set.of();
            }
        };
    }
}

