/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.Table;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.function.Function;

public class IntPropertyMapDB
extends PropertyMapDB<Integer>
implements IntPropertyMap {
    private Function<Long, Integer> valueReader = addrKey -> {
        Table table = this.propertyTable;
        DBRecord rec = null;
        try {
            if (table != null) {
                rec = table.getRecord(addrKey.longValue());
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return rec != null ? Integer.valueOf(rec.getIntValue(0)) : null;
    };

    public IntPropertyMapDB(DBHandle dbHandle, OpenMode openMode, ErrorHandler errHandler, ChangeManager changeMgr, AddressMap addrMap, String name, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        super(dbHandle, errHandler, changeMgr, addrMap, name);
        this.checkMapVersion(openMode, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Address addr, int value) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            Integer oldValue = null;
            long addrKey = this.addrMap.getKey(addr, true);
            if (this.propertyTable == null) {
                this.createTable((Field)IntField.INSTANCE);
            } else {
                oldValue = (Integer)this.cache.get(addrKey);
                if (oldValue == null) {
                    oldValue = this.valueReader.apply(addrKey);
                }
            }
            DBRecord rec = this.schema.createRecord(addrKey);
            rec.setIntValue(0, value);
            this.propertyTable.putRecord(rec);
            this.cache.put(addrKey, (Object)value);
            this.changeMgr.setPropertyChanged(this.name, addr, oldValue, value);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getInt(Address addr) throws NoValueException {
        Integer value = this.get(addr);
        if (value == null) {
            throw NO_VALUE_EXCEPTION;
        }
        return value;
    }

    @Override
    public Integer get(Address addr) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return null;
        }
        long addrKey = this.addrMap.getKey(addr, false);
        if (addrKey == -1L) {
            return null;
        }
        return (Integer)this.cache.computeIfAbsent(addrKey, this.valueReader);
    }
}

