/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html.diff;

import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiffInput;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DiffLines
extends ArrayList<ValidatableLine> {
    private DataTypeDiffInput input;

    public DiffLines(DataTypeDiffInput input) {
        this.input = input;
        this.addAll(input.getLines());
    }

    public DiffLines(DataTypeDiffInput input, List<ValidatableLine> validatedLines) {
        this.input = input;
        this.addAll(validatedLines);
    }

    void removeLeadingEmptyRows() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ValidatableLine line = (ValidatableLine)iterator.next();
            if (line instanceof PlaceHolderLine) {
                iterator.remove();
                continue;
            }
            return;
        }
    }

    DiffLines createEmptyClone() {
        return new DiffLines(this.input, new ArrayList<ValidatableLine>());
    }

    void installNewLines(DiffLines newLines) {
        if (this.input != newLines.input) {
            throw new AssertException("Can only install new diff lines from a clone of the original");
        }
        this.clear();
        this.addAll(newLines);
    }

    private PlaceHolderLine createPlaceHolderLine(ValidatableLine oppositeLine) {
        return this.input.createPlaceHolder(oppositeLine);
    }

    void insertPlaceholder(ValidatableLine oppositeLine) {
        this.insertPlaceholder(this.size(), oppositeLine);
    }

    void insertPlaceholder(int index, ValidatableLine oppositeLine) {
        this.add(index, this.createPlaceHolderLine(oppositeLine));
    }

    @Override
    public String toString() {
        StringBuilder buffy = new StringBuilder("[\n");
        for (ValidatableLine line : this) {
            buffy.append(line.toString()).append('\n');
        }
        buffy.append(']');
        return buffy.toString();
    }
}

