/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AnalysisScheduler;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class AnalysisTask
extends BackgroundCommand<Program> {
    AnalysisScheduler scheduler;
    private MessageLog log;

    public AnalysisTask(AnalysisScheduler scheduler, MessageLog log) {
        super(scheduler.getName(), true, true, false);
        this.scheduler = scheduler;
        this.log = log;
    }

    public boolean applyTo(Program program, TaskMonitor monitor) {
        try {
            return this.scheduler.runAnalyzer(program, monitor, this.log);
        }
        catch (CancelledException e) {
            return false;
        }
    }

    public void dispose() {
        super.dispose();
        this.scheduler.runCanceled();
    }
}

