/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.MapIteratorSTL;
import generic.stl.Pair;
import generic.stl.RedBlackNode;
import generic.stl.RedBlackTree;
import generic.stl.ReverseMapIteratorSTL;
import java.util.Comparator;

public class MapSTL<K, V> {
    public static final String EOL = System.getProperty("line.separator");
    RedBlackTree<K, V> rbTree;

    public MapSTL(Comparator<K> comparator) {
        this.rbTree = new RedBlackTree(comparator, false);
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer("{");
        IteratorSTL<Pair<K, V>> begin = this.begin();
        while (!begin.isEnd()) {
            Pair<K, V> pair = begin.get();
            begin.increment();
            buffy.append(pair.toString()).append(", ").append(EOL);
        }
        buffy.append("}");
        return buffy.toString();
    }

    public void put(K key, V value) {
        this.rbTree.put(key, value);
    }

    public boolean add(K key, V value) {
        if (this.rbTree.containsKey(key)) {
            return false;
        }
        this.rbTree.put(key, value);
        return true;
    }

    public boolean contains(K key) {
        return this.rbTree.containsKey(key);
    }

    public V remove(K key) {
        return this.rbTree.remove(key);
    }

    public IteratorSTL<Pair<K, V>> begin() {
        return new MapIteratorSTL<K, V>(this.rbTree, this.rbTree.getFirst());
    }

    public IteratorSTL<Pair<K, V>> end() {
        return new MapIteratorSTL<K, V>(this.rbTree, null);
    }

    public IteratorSTL<Pair<K, V>> rBegin() {
        return new ReverseMapIteratorSTL<K, V>(this.rbTree, this.rbTree.getLast());
    }

    public IteratorSTL<Pair<K, V>> rEnd() {
        return new ReverseMapIteratorSTL<K, V>(this.rbTree, null);
    }

    public V erase(K key) {
        return this.remove(key);
    }

    public boolean empty() {
        return this.rbTree.isEmpty();
    }

    public IteratorSTL<Pair<K, V>> lower_bound(K key) {
        RedBlackNode<K, V> node = this.rbTree.lowerBound(key);
        return new MapIteratorSTL<K, V>(this.rbTree, node);
    }

    public IteratorSTL<Pair<K, V>> upper_bound(K key) {
        RedBlackNode<K, V> node = this.rbTree.upperBound(key);
        MapIteratorSTL<K, V> it = new MapIteratorSTL<K, V>(this.rbTree, node);
        return it;
    }

    public boolean isEmpty() {
        return this.rbTree.isEmpty();
    }

    public void clear() {
        this.rbTree.removeAll();
    }

    public void erase(IteratorSTL<Pair<K, V>> iter) {
        MapIteratorSTL it = (MapIteratorSTL)iter;
        RedBlackNode node = it.node;
        if (node == null) {
            throw new IndexOutOfBoundsException();
        }
        it.node = node.getSuccessor();
        it.erased = true;
        this.rbTree.deleteEntry(node);
    }

    public void erase(IteratorSTL<Pair<K, V>> start, IteratorSTL<Pair<K, V>> end) {
        while (!start.equals(end)) {
            this.erase(start);
            start.increment();
        }
    }

    public V get(K key) {
        RedBlackNode<K, V> node = this.rbTree.findFirstNode(key);
        if (node == null) {
            return null;
        }
        return node.value;
    }

    public IteratorSTL<Pair<K, V>> find(K key) {
        if (this.rbTree.containsKey(key)) {
            return this.lower_bound(key);
        }
        return this.end();
    }

    public int size() {
        return this.rbTree.size();
    }

    public void insert(IteratorSTL<Pair<K, V>> start, IteratorSTL<Pair<K, V>> end) {
        while (!start.equals(end)) {
            this.add(start.get().first, start.get().second);
            start.increment();
        }
    }
}

