/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.echosvg.css.dom.CSSOMValue;
import io.sf.carte.echosvg.css.engine.value.AbstractValueModificationHandler;
import io.sf.carte.echosvg.css.engine.value.CSSVal;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.om.CSSRule;
import org.w3c.css.om.CSSStyleDeclaration;
import org.w3c.dom.DOMException;

public class CSSOMStyleDeclaration
implements CSSStyleDeclaration {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected CSSRule parentRule;
    protected Map<String, CSSVal> values;

    public CSSOMStyleDeclaration(ValueProvider valueProvider, CSSRule cSSRule) {
        this.valueProvider = valueProvider;
        this.parentRule = cSSRule;
    }

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.handler = modificationHandler;
    }

    public String getCssText() {
        return this.valueProvider.getText();
    }

    public void setCssText(String string) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.values = null;
        this.handler.textChanged(string);
    }

    public String getPropertyValue(String string) {
        Value value = this.valueProvider.getValue(string);
        if (value == null) {
            return "";
        }
        return value.getCssText();
    }

    public CSSVal getCSSStyleValue(String string) {
        Value value = this.valueProvider.getValue(string);
        if (value == null) {
            return null;
        }
        return this.getCSSValue(string);
    }

    public String removeProperty(String string) throws DOMException {
        String string2 = this.getPropertyValue(string);
        if (string2.length() > 0) {
            if (this.handler == null) {
                throw new DOMException(7, "");
            }
            if (this.values != null) {
                this.values.remove(string);
            }
            this.handler.propertyRemoved(string);
        }
        return string2;
    }

    public String getPropertyPriority(String string) {
        return this.valueProvider.isImportant(string) ? "important" : "";
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.propertyChanged(string, string2, string3);
    }

    public int getLength() {
        return this.valueProvider.getLength();
    }

    public String item(int n) {
        return this.valueProvider.item(n);
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    protected CSSVal getCSSValue(String string) {
        CSSVal cSSVal = null;
        if (this.values != null) {
            cSSVal = this.values.get(string);
        }
        if (cSSVal == null) {
            cSSVal = this.createCSSValue(string);
            if (this.values == null) {
                this.values = new HashMap<String, CSSVal>(11);
            }
            this.values.put(string, cSSVal);
        }
        return cSSVal;
    }

    protected CSSVal createCSSValue(String string) {
        return new StyleDeclarationValue(string);
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void propertyRemoved(String var1) throws DOMException;

        public void propertyChanged(String var1, String var2, String var3) throws DOMException;
    }

    public class StyleDeclarationValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        private static final long serialVersionUID = 1L;
        protected String property;

        public StyleDeclarationValue(String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new AbstractValueModificationHandler(){

                @Override
                protected Value getValue() {
                    return StyleDeclarationValue.this.getValue();
                }

                @Override
                protected void setPropertyText(String string) throws DOMException {
                    if (CSSOMStyleDeclaration.this.values == null || StyleDeclarationValue.this.handler == null) {
                        throw new DOMException(7, "");
                    }
                    String string2 = CSSOMStyleDeclaration.this.getPropertyPriority(StyleDeclarationValue.this.property);
                    CSSOMStyleDeclaration.this.handler.propertyChanged(StyleDeclarationValue.this.property, string, string2);
                }
            });
            this.property = string;
        }

        @Override
        public Value getValue() {
            return CSSOMStyleDeclaration.this.valueProvider.getValue(this.property);
        }
    }

    public static interface ValueProvider {
        public Value getValue(String var1);

        public boolean isImportant(String var1);

        public String getText();

        public int getLength();

        public String item(int var1);
    }
}

