/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Timer;
import vtk.vtkBoxWidget;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorStyle;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkPanel;
import vtk.vtkPlaneWidget;
import vtk.vtkProp3D;
import vtk.vtkRenderWindow;

public class vtkCanvas
extends vtkPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    protected vtkGenericRenderWindowInteractor iren = new vtkGenericRenderWindowInteractor();
    protected Timer timer = new Timer(10, new DelayAction());
    protected int ctrlPressed = 0;
    protected int shiftPressed = 0;
    protected vtkPlaneWidget pw = new vtkPlaneWidget();
    protected vtkBoxWidget bw = new vtkBoxWidget();

    @Override
    public void Delete() {
        this.iren = null;
        this.pw = null;
        this.bw = null;
        super.Delete();
    }

    public vtkCanvas() {
        this.Initialize();
    }

    public vtkCanvas(vtkRenderWindow vtkRenderWindow2) {
        super(vtkRenderWindow2);
        this.Initialize();
    }

    protected void Initialize() {
        this.iren.SetRenderWindow(this.rw);
        this.iren.TimerEventResetsTimerOff();
        this.iren.AddObserver("CreateTimerEvent", this, "StartTimer");
        this.iren.AddObserver("DestroyTimerEvent", this, "DestroyTimer");
        this.iren.SetSize(200, 200);
        this.iren.ConfigureEvent();
        this.pw.AddObserver("EnableEvent", this, "BeginPlaneInteraction");
        this.bw.AddObserver("EnableEvent", this, "BeginBoxInteraction");
        this.pw.SetKeyPressActivationValue('l');
        this.bw.SetKeyPressActivationValue('b');
        this.pw.SetInteractor(this.iren);
        this.bw.SetInteractor(this.iren);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = vtkCanvas.this.getWidth();
                int n2 = vtkCanvas.this.getHeight();
                vtkCanvas.this.setSize(n, n2);
            }
        });
        this.ren.SetBackground(0.0, 0.0, 0.0);
        vtkInteractorStyleTrackballCamera vtkInteractorStyleTrackballCamera2 = new vtkInteractorStyleTrackballCamera();
        this.iren.SetInteractorStyle(vtkInteractorStyleTrackballCamera2);
    }

    public void StartTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public void DestroyTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    @Deprecated
    public vtkGenericRenderWindowInteractor getIren() {
        return this.iren;
    }

    public vtkGenericRenderWindowInteractor getRenderWindowInteractor() {
        return this.iren;
    }

    public void setInteractorStyle(vtkInteractorStyle vtkInteractorStyle2) {
        this.iren.SetInteractorStyle(vtkInteractorStyle2);
    }

    public void addToPlaneWidget(vtkProp3D vtkProp3D2) {
        this.pw.SetProp3D(vtkProp3D2);
        this.pw.PlaceWidget();
    }

    public void addToBoxWidget(vtkProp3D vtkProp3D2) {
        this.bw.SetProp3D(vtkProp3D2);
        this.bw.PlaceWidget();
    }

    public void BeginPlaneInteraction() {
        System.out.println("Plane widget begin interaction");
    }

    public void BeginBoxInteraction() {
        System.out.println("Box widget begin interaction");
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.windowset == 1) {
            this.Lock();
            this.rw.SetSize(n, n2);
            this.iren.SetSize(n, n2);
            this.iren.ConfigureEvent();
            this.UnLock();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.Lock();
        this.rw.SetDesiredUpdateRate(5.0);
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.ctrlPressed = (mouseEvent.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        if ((mouseEvent.getModifiersEx() & 0x400) == 1024) {
            this.iren.LeftButtonPressEvent();
        } else if ((mouseEvent.getModifiersEx() & 0x800) == 2048) {
            this.iren.MiddleButtonPressEvent();
        } else if ((mouseEvent.getModifiersEx() & 0x1000) == 4096) {
            this.iren.RightButtonPressEvent();
        }
        this.UnLock();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.Lock();
        this.rw.SetDesiredUpdateRate(0.01);
        this.ctrlPressed = (mouseEvent.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        switch (mouseEvent.getButton()) {
            case 1: {
                this.iren.LeftButtonReleaseEvent();
                break;
            }
            case 2: {
                this.iren.MiddleButtonReleaseEvent();
                break;
            }
            case 3: {
                this.iren.RightButtonReleaseEvent();
            }
        }
        this.UnLock();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), 0, 0, '0', 0, "0");
        this.iren.EnterEvent();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), 0, 0, '0', 0, "0");
        this.iren.LeaveEvent();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.ctrlPressed = (mouseEvent.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        this.Lock();
        this.iren.MouseMoveEvent();
        this.UnLock();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.ctrlPressed = (mouseEvent.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        this.Lock();
        this.iren.MouseMoveEvent();
        this.UnLock();
        this.UpdateLight();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.ctrlPressed = (mouseWheelEvent.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (mouseWheelEvent.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.Lock();
        if (mouseWheelEvent.getWheelRotation() > 0) {
            this.iren.SetEventInformationFlipY(mouseWheelEvent.getX(), mouseWheelEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.iren.MouseWheelBackwardEvent();
        } else if (mouseWheelEvent.getWheelRotation() < 0) {
            this.iren.SetEventInformationFlipY(mouseWheelEvent.getX(), mouseWheelEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.iren.MouseWheelForwardEvent();
        }
        this.UnLock();
        this.UpdateLight();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        char c = keyEvent.getKeyChar();
        this.ctrlPressed = (keyEvent.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (keyEvent.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, c, 0, String.valueOf(c));
        this.Lock();
        this.iren.KeyPressEvent();
        this.iren.CharEvent();
        this.UnLock();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private class DelayAction
    implements ActionListener {
        private DelayAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            vtkCanvas.this.Lock();
            vtkCanvas.this.iren.TimerEvent();
            vtkCanvas.this.UpdateLight();
            vtkCanvas.this.UnLock();
        }
    }
}

