/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.light;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Texture;
import org.sunflow.image.Bitmap;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.QMC;
import org.sunflow.math.Vector3;

public class ImageBasedLight
implements PrimitiveList,
LightSource,
Shader {
    private Texture texture = null;
    private OrthoNormalBasis basis;
    private int numSamples;
    private int numLowSamples;
    private float jacobian;
    private float[] colHistogram;
    private float[][] imageHistogram;
    private Vector3[] samples;
    private Vector3[] lowSamples;
    private Color[] colors;
    private Color[] lowColors;

    public ImageBasedLight() {
        this.updateBasis(new Vector3(0.0f, 0.0f, -1.0f), new Vector3(0.0f, 1.0f, 0.0f));
        this.numSamples = 64;
        this.numLowSamples = 8;
    }

    private void updateBasis(Vector3 vector3, Vector3 vector32) {
        if (vector3 != null && vector32 != null) {
            this.basis = OrthoNormalBasis.makeFromWV(vector3, vector32);
            this.basis.swapWU();
            this.basis.flipV();
        }
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.updateBasis(parameterList.getVector("center", null), parameterList.getVector("up", null));
        this.numSamples = parameterList.getInt("samples", this.numSamples);
        this.numLowSamples = parameterList.getInt("lowsamples", this.numLowSamples);
        String string = parameterList.getString("texture", null);
        if (string != null) {
            this.texture = sunflowAPI.getTextureCache().getTexture(sunflowAPI.resolveTextureFilename(string), false);
        }
        if (this.texture == null) {
            return false;
        }
        Bitmap bitmap = this.texture.getBitmap();
        if (bitmap == null) {
            return false;
        }
        if (string != null) {
            int n;
            this.imageHistogram = new float[bitmap.getWidth()][bitmap.getHeight()];
            this.colHistogram = new float[bitmap.getWidth()];
            float f = 1.0f / (float)bitmap.getWidth();
            float f2 = 1.0f / (float)bitmap.getHeight();
            for (n = 0; n < bitmap.getWidth(); ++n) {
                int n2;
                for (n2 = 0; n2 < bitmap.getHeight(); ++n2) {
                    float f3 = ((float)n + 0.5f) * f;
                    float f4 = ((float)n2 + 0.5f) * f2;
                    Color color = this.texture.getPixel(f3, f4);
                    this.imageHistogram[n][n2] = color.getLuminance() * (float)Math.sin(Math.PI * (double)f4);
                    if (n2 <= 0) continue;
                    float[] fArray = this.imageHistogram[n];
                    int n3 = n2;
                    fArray[n3] = fArray[n3] + this.imageHistogram[n][n2 - 1];
                }
                this.colHistogram[n] = this.imageHistogram[n][bitmap.getHeight() - 1];
                if (n > 0) {
                    int n4 = n;
                    this.colHistogram[n4] = this.colHistogram[n4] + this.colHistogram[n - 1];
                }
                n2 = 0;
                while (n2 < bitmap.getHeight()) {
                    float[] fArray = this.imageHistogram[n];
                    int n5 = n2++;
                    fArray[n5] = fArray[n5] / this.imageHistogram[n][bitmap.getHeight() - 1];
                }
            }
            n = 0;
            while (n < bitmap.getWidth()) {
                int n6 = n++;
                this.colHistogram[n6] = this.colHistogram[n6] / this.colHistogram[bitmap.getWidth() - 1];
            }
            this.jacobian = 19.739208f / (float)(bitmap.getWidth() * bitmap.getHeight());
        }
        if (parameterList.getBoolean("fixed", this.samples != null)) {
            this.samples = new Vector3[this.numSamples];
            this.colors = new Color[this.numSamples];
            this.generateFixedSamples(this.samples, this.colors);
            this.lowSamples = new Vector3[this.numLowSamples];
            this.lowColors = new Color[this.numLowSamples];
            this.generateFixedSamples(this.lowSamples, this.lowColors);
        } else {
            this.lowSamples = null;
            this.samples = null;
            this.lowColors = null;
            this.colors = null;
        }
        return true;
    }

    private void generateFixedSamples(Vector3[] vector3Array, Color[] colorArray) {
        for (int i = 0; i < vector3Array.length; ++i) {
            int n;
            int n2;
            double d = (double)i / (double)vector3Array.length;
            double d2 = QMC.halton(0, i);
            for (n2 = 0; d >= (double)this.colHistogram[n2] && n2 < this.colHistogram.length - 1; ++n2) {
            }
            float[] fArray = this.imageHistogram[n2];
            for (n = 0; d2 >= (double)fArray[n] && n < fArray.length - 1; ++n) {
            }
            float f = (float)(n2 == 0 ? d / (double)this.colHistogram[0] : (d - (double)this.colHistogram[n2 - 1]) / (double)(this.colHistogram[n2] - this.colHistogram[n2 - 1]));
            float f2 = (float)(n == 0 ? d2 / (double)fArray[0] : (d2 - (double)fArray[n - 1]) / (double)(fArray[n] - fArray[n - 1]));
            float f3 = n2 == 0 ? this.colHistogram[0] : this.colHistogram[n2] - this.colHistogram[n2 - 1];
            float f4 = n == 0 ? fArray[0] : fArray[n] - fArray[n - 1];
            float f5 = ((float)n2 + f) / (float)this.colHistogram.length;
            float f6 = ((float)n + f2) / (float)fArray.length;
            float f7 = (float)Math.sin((double)f6 * Math.PI) * this.jacobian / ((float)this.numSamples * f3 * f4);
            vector3Array[i] = this.getDirection(f5, f6);
            this.basis.transform(vector3Array[i]);
            colorArray[i] = this.texture.getPixel(f5, f6).mul(f7);
        }
    }

    public void prepareShadingState(ShadingState shadingState) {
        if (shadingState.includeLights()) {
            shadingState.setShader(this);
        }
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        if (ray.getMax() == Float.POSITIVE_INFINITY) {
            intersectionState.setIntersection(0);
        }
    }

    public int getNumPrimitives() {
        return 1;
    }

    public float getPrimitiveBound(int n, int n2) {
        return 0.0f;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        return null;
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void getSamples(ShadingState shadingState) {
        if (this.samples == null) {
            int n = shadingState.getDiffuseDepth() > 0 ? 1 : this.numSamples;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                double d = shadingState.getRandom(i, 0, n);
                double d2 = shadingState.getRandom(i, 1, n);
                for (n3 = 0; d >= (double)this.colHistogram[n3] && n3 < this.colHistogram.length - 1; ++n3) {
                }
                float[] fArray = this.imageHistogram[n3];
                for (n2 = 0; d2 >= (double)fArray[n2] && n2 < fArray.length - 1; ++n2) {
                }
                float f = (float)(n3 == 0 ? d / (double)this.colHistogram[0] : (d - (double)this.colHistogram[n3 - 1]) / (double)(this.colHistogram[n3] - this.colHistogram[n3 - 1]));
                float f2 = (float)(n2 == 0 ? d2 / (double)fArray[0] : (d2 - (double)fArray[n2 - 1]) / (double)(fArray[n2] - fArray[n2 - 1]));
                float f3 = n3 == 0 ? this.colHistogram[0] : this.colHistogram[n3] - this.colHistogram[n3 - 1];
                float f4 = n2 == 0 ? fArray[0] : fArray[n2] - fArray[n2 - 1];
                float f5 = ((float)n3 + f) / (float)this.colHistogram.length;
                float f6 = ((float)n2 + f2) / (float)fArray.length;
                float f7 = (float)Math.sin((double)f6 * Math.PI) * this.jacobian / ((float)n * f3 * f4);
                Vector3 vector3 = this.getDirection(f5, f6);
                this.basis.transform(vector3);
                if (!(Vector3.dot(vector3, shadingState.getGeoNormal()) > 0.0f)) continue;
                LightSample lightSample = new LightSample();
                lightSample.setShadowRay(new Ray(shadingState.getPoint(), vector3));
                lightSample.getShadowRay().setMax(Float.MAX_VALUE);
                Color color = this.texture.getPixel(f5, f6);
                lightSample.setRadiance(color, color);
                lightSample.getDiffuseRadiance().mul(f7);
                lightSample.getSpecularRadiance().mul(f7);
                lightSample.traceShadow(shadingState);
                shadingState.addSample(lightSample);
            }
        } else if (shadingState.getDiffuseDepth() > 0) {
            for (int i = 0; i < this.numLowSamples; ++i) {
                if (!(Vector3.dot(this.lowSamples[i], shadingState.getGeoNormal()) > 0.0f) || !(Vector3.dot(this.lowSamples[i], shadingState.getNormal()) > 0.0f)) continue;
                LightSample lightSample = new LightSample();
                lightSample.setShadowRay(new Ray(shadingState.getPoint(), this.lowSamples[i]));
                lightSample.getShadowRay().setMax(Float.MAX_VALUE);
                lightSample.setRadiance(this.lowColors[i], this.lowColors[i]);
                lightSample.traceShadow(shadingState);
                shadingState.addSample(lightSample);
            }
        } else {
            for (int i = 0; i < this.numSamples; ++i) {
                if (!(Vector3.dot(this.samples[i], shadingState.getGeoNormal()) > 0.0f) || !(Vector3.dot(this.samples[i], shadingState.getNormal()) > 0.0f)) continue;
                LightSample lightSample = new LightSample();
                lightSample.setShadowRay(new Ray(shadingState.getPoint(), this.samples[i]));
                lightSample.getShadowRay().setMax(Float.MAX_VALUE);
                lightSample.setRadiance(this.colors[i], this.colors[i]);
                lightSample.traceShadow(shadingState);
                shadingState.addSample(lightSample);
            }
        }
    }

    public void getPhoton(double d, double d2, double d3, double d4, Point3 point3, Vector3 vector3, Color color) {
    }

    public Color getRadiance(ShadingState shadingState) {
        return shadingState.includeLights() ? this.getColor(this.basis.untransform(shadingState.getRay().getDirection(), new Vector3())) : Color.BLACK;
    }

    private Color getColor(Vector3 vector3) {
        double d = 0.0;
        double d2 = 0.0;
        d = Math.acos(vector3.y);
        d2 = Math.atan2(vector3.z, vector3.x);
        float f = (float)(0.5 - 0.5 * d2 / Math.PI);
        float f2 = (float)(d / Math.PI);
        return this.texture.getPixel(f, f2);
    }

    private Vector3 getDirection(float f, float f2) {
        Vector3 vector3 = new Vector3();
        double d = 0.0;
        double d2 = 0.0;
        d2 = (double)(f * 2.0f) * Math.PI;
        d = (double)f2 * Math.PI;
        double d3 = Math.sin(d);
        vector3.x = (float)(-d3 * Math.cos(d2));
        vector3.y = (float)Math.cos(d);
        vector3.z = (float)(d3 * Math.sin(d2));
        return vector3;
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
    }

    public float getPower() {
        return 0.0f;
    }

    public Instance createInstance() {
        return Instance.createTemporary(this, null, this);
    }

    public boolean isOpaque() {
        return true;
    }

    public Color getOpacity(ShadingState shadingState) {
        return null;
    }
}

