/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.FacetCollector;

class IndexSortedFacetCollector
extends FacetCollector {
    private final CharsRefBuilder spare = new CharsRefBuilder();
    int offset;
    int limit;
    final int mincount;
    final NamedList<Integer> res = new NamedList();

    public IndexSortedFacetCollector(int offset, int limit, int mincount) {
        this.offset = offset;
        this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
        this.mincount = mincount;
    }

    @Override
    public boolean collect(BytesRef term, int count) {
        if (count < this.mincount) {
            return false;
        }
        if (this.offset > 0) {
            --this.offset;
            return false;
        }
        if (this.limit > 0) {
            this.spare.copyUTF8Bytes(term);
            this.res.add(this.spare.toString(), (Object)count);
            --this.limit;
        }
        return this.limit <= 0;
    }

    @Override
    public NamedList<Integer> getFacetCounts() {
        return this.res;
    }
}

